# hlsCheckbox 标签

hlsCheckbox框,一般与<h:hlsForm>、<h:hlsHBox>一起使用，定义一个带文字说明的选择框。

```xml
<h:hlsCheckbox  id="testCheckbox" bind="value:data.testValue" readonly="false" checkedValue="Y" uncheckedValue="N" />
```

### **主要属性**

| 属性名 | 类型 | 描述 |
| --- | --- | --- |
|promptColspan | String | 文字说明盒子的长度|
|promptClassName | String | 文字说明盒子的样式|
|promptImage|String|文字说明部分的图标(要求是一个完整的img标签)|
| prompt | String | 文字说明 | 
| bind | String | 该选择框绑定关系 |
| required | String & Boolean & 不填 | 必选|
| checkedValue | String | 选中时input框的值 |
| uncheckedValue | String | 未选中时input框的值 |
| readonly | Boolean | 是否是可点击的 |


### **用法示例**

```xml
var viewModel = kendo.observable({
	enabled: true,
	isEnabled: false,
	data: {},
});


<h:hlsForm title="hlsFormTitle" id="hlsFormTitleId" width="100%">
    <h:hlsHBox>
        <h:hlsCheckbox name="testCheckboxName" id="testCheckbox"
               bind="enabled: enabled,value:model.testValue"
               checked="checked" checkedValue="Y" prompt="hlsCheckbox测试：" uncheckedValue="N"
               promptColspan="1" style="width:100%"/>
     </h:hlsHBox>
</h:hlsForm>



```

