# HlsNavigationBar

左侧导航栏

说明：前期仅封装了一些常用的属性

### 一般属性：

| 属性 | 类型 |
| :--- | :--- |
| navigationBarTitle | String |
| navigationBar | String |
| navigationBarContent | String |
| treeTitle | String |
| navigationBarId | String |
| navigatonBarClass | String |
| barType | String |
| nodeLevel | String |

### 使用：

说明：目前系统遇到的是普通不分层的导航和分两层的导航，以下针对这两种使用说明

##### 1.hlsNavigationBar

说明：导航栏的标志标签，在这个标签内书写需要生成标签的内容

```html
 <h:hlsNavigationBar>
   <div></div>
   <div></div>
   <div></div>
   <div></div>
 </hlsNavigationBar>
```

##### 2.barType

说明：bartype有两种类型：tree（分层），normal（不分层）

```html
<h:hlsNavigationBar barType="tree">
    <div></div>
</hlsNavigationBar>
```

##### 3.navigationBar

说明：加上此属性并设为“true”表示该块内容需要导航栏

```html
<h:hlsNavigationBar barType="tree">
    <div navigationBar="true"></div>
</hlsNavigationBar>
```

##### 4.navigationBarTitle

说明：在导航栏中显示标题（如果是分层的导航栏这个就作为子标题显示），如果不写则取标签中title，若都为空则自动根据位置系统命名为"x.第x模块" x是数字

```html
<h:hlsNavigationBar barType="tree">
    <div navigationBar="true" navigationBarTitle="标题1"></div>
</hlsNavigationBar>
```

##### 5.treeTitle

说明：作为分层导航栏的父标题，如果不写则取标签中的title，若都为空则系统自动命名为"x.第x模块" x是数字

```html
<h:hlsNavigationBar barType="tree">
    <div nodeLevl="parent" navigationBar="true" treeTitle="承租人注册信息"></div>
    <div navigationBar="true" navigationBarTitle="注册信息"></div>
</hlsNavigationBar>
```

##### 6.nodeLevel

说明：添加该属性并设置为“parent”则表示该标题作为父标题，不添加则为子标题

![](/assets/4108.png)

### 使用实例：

##### 1.分层实例

```html
<h:hlsNavigationBar barType="tree">
    <div nodeLevl="parent" navigationBar="true" treeTitle="基本信息">
        //这里是内容
    </div>
    <div navigationBar="true" navigationBarTitle="基本信息">
        //这里是内容
    </div>
    <div nodeLevl="parent" navigationBar="true" treeTitle="承租人注册信息">
        //这里是内容
    </div>
    <div navigationBar="true" navigationBarTitle="注册信息">
        //这里是内容
    </div>
    <div navigationBar="true" navigationBarTitle="历史沿革">
        //这里是内容
    </div>
    <div navigationBar="true" navigationBarTitle="股权结构">
        //这里是内容
    </div>
    <<h:hlsForm navigationBar="true" navigationBarTitle="经营情况">
        //这里是内容
    </hlsForm>
    <div navigationBar="true" navigationBarTitle="财务状况">
        //这里是内容
    </div>
    <div nodeLevl="parent" navigationBar="true" treeTitle="租赁交易分析">
        //这里是内容
    </div>
    <div navigationBar="true" navigationBarTitle="租赁报价方案">
        //这里是内容
    </div>
    <h:dataSource></dataSource>
    <h:hlsGridBox navigationBar="true" navigationBarTitle="租赁物信息"></hlsGridBox>
</hlsNavigationBar>
```

##### 效果图：![](/assets/import.png)2.不分层实例

```html
<h:hlsNavigationBar barType="tree">
    <div navigationBar="true" navigationBarTitle="基本信息">
        //这里是内容
    </div>
    <div navigationBar="true" navigationBarTitle="开票信息">
        //这里是内容
    </div>
    <div navigationBar="true" navigationBarTitle="地址信息">
        //这里是内容
    </div>
    <div navigationBar="true" navigationBarTitle="联系人信息">
        //这里是内容
    </div>
    <<h:hlsForm navigationBar="true" navigationBarTitle="关联方信息">
        //这里是内容
    </hlsForm>
    <h:dataSource></dataSource>
    <h:hlsGridBox navigationBar="true" navigationBarTitle="银行账户信息"></hlsGridBox>
</hlsNavigationBar>
```

效果图：

![](/assets/215412.png)

