# 新建数据库

# 1. 创建数据库-Mysql

> 在开始之前最好修改一下 MySQL的配置文件 my.cnf (or my.ini)
,在 [mysqld] 下添加

```
lower_case_table_names=1
character_set_server=utf8
max_connections=500
```

   * 用管理员登陆mysql
   * 创建数据库hls_dev
 
   ```sql
   create schema hls_dev default character set utf8;
   ```
   
   * 创建用户hls_dev,并将密码设置为hls_dev
   
   ```sql
   CREATE USER hls_dev@'%' IDENTIFIED BY 'hls_dev';
   CREATE USER hls_dev@'localhost' IDENTIFIED BY 'hls_dev';
   ```
   * 将上面新建的hls_dev权限赋予用户hls  
   
   ```sql
   GRANT ALL PRIVILEGES ON hls_dev.* TO hls_dev@'%';
   GRANT ALL PRIVILEGES ON hls_dev.* TO hls_dev@'localhost';
   flush privileges; 
   ```
# 2. 创建数据库-Oracle
  * 使用管理员登陆
  * 创建表空间  
 
  ```sql
  CREATE BIGFILE TABLESPACE tbs_perm_hls
    DATAFILE 'tbs_perm_hls.dat'
      SIZE 200M
      AUTOEXTEND ON NEXT 20M MAXSIZE 500M;  
  ```    
  ```sql
  CREATE TEMPORARY TABLESPACE tbs_temp_hls
    TEMPFILE 'tbs_temp_hls.dbf'
    SIZE 200M
    AUTOEXTEND ON NEXT 20M MAXSIZE 500M;
  ```
   
  * 创建用户 schema   
     
  ```sql
  CREATE USER hls_dev
    IDENTIFIED BY hls_dev
    DEFAULT TABLESPACE tbs_perm_hls
    TEMPORARY TABLESPACE tbs_temp_hls
    QUOTA 200M on tbs_perm_hls;
  ```
    
  * 授权
          
  ```sql  
  GRANT create session TO hls_dev;
  GRANT create table TO hls_dev;
  GRANT create view TO hls_dev;
  GRANT create any trigger TO hls_dev;
  GRANT create any procedure TO hls_dev;
  GRANT create sequence TO hls_dev;
  GRANT create synonym TO hls_dev;
  ```

# 3. 创建数据库-sql server
  * 使用管理员登陆
  * 创建数据库 
 
  ```sql
  CREATE DATABASE hls_dev COLLATE Chinese_PRC_CI_AS;
  ```    
   
  * 创建用户 hls 并授权  
     
  ```sql
  sp_addlogin 'hls','hls_dev';
  use hls_dev
  go
  sp_adduser 'hls_dev','hls_dev'
  go
  sp_addrolemember 'db_owner','hls'
  go
  ```