# 新开项目

本章节将引导您从零开始，创建一个可以运行的 Demo 工程。此工程基于HLS融租易标准版，包含一个 demo 实例。
  
## 开发工具准备
- JDK 1.8 及以上
- IntelliJ IDEA 或 Eclipse
- Git
- redis 3.0 及以上
- maven 3.3 及以上
- Tomcat 7+  (**不支持 Tomcat 6**)
- 数据库（任选）
  - Mysql server 5.6 及以上
  - SqlServer 2012 及以上
  - Oracle 9 以上
- Navicat Premium（或其他）
### 软件安装

#### Java 安装

1. 在 [Oracle 官网 ](https://nodejs.orghttp://www.oracle.com/technetwork/cn/java/javase/downloads/index.html)下载对应平台的 JDK 1.8 以上的环境。
2. 本地执行安装文件，安装 JDK 环境。
3. Win 在环境变量系统变量中 path 配置 JDK 的环境变量指向 JDK 安装目录下 ` JDK/bin `。
4. 配置完成后打开 cmd 执行 ` javac `，有提示则说明环境安装成功。

> eclipse 中 JRE 的配置需要指定 JDK 目录，不能是 JRE。(maven 需要 JDK)


#### Git 安装

1. 在 [Git 官网 ](https://git-scm.com/download/)下载对应平台的 Git。
2. 本地执行安装文件， 安装 Git 环境。
3. Win 在环境变量中系统变量的 path 配置 Git 的环境变量指向 Git 安装目录下的 ` /bin `。
4. 配置完成后打开 cmd 执行 ` git `，有提示则说明环境安装成功。

[Git简明教程](git_guide.md)
> 对于 Windows，安装 Git 以后，你可以在任意目录右键，`Git Bash Here`
> 打开的 MINGW 命令窗口可以执行 **兼容 linux 系统** 的命令，如`rm`，`ls` 等

#### Maven 安装

1. 在 [Maven 官网 ](http://mirror.bit.edu.cn/apache/maven/)下载对应平台的合适的 maven 版本的压缩包。
2. 本地解压压缩包。
3. Win 在环境变量中系统变量的 path 配置 maven 的环境变量指向 maven 解压目录下的 ` /bin `。
4. 配置完成后打开 cmd 执行 ` mvn -v `，有提示则说明环境安装成功。

#### Redis 安装

1. 在 [Redis win 官网 ](https://github.com/MSOpenTech/redis/releases)下载最新的 redis 版本的压缩包。
2. 本地解压压缩包。
3. Win 在解压目录下打开 cmd 执行 ` redis-server.exe redis.windows.conf `，有提示则说明 Redis 已经启动。  
4. Win 平台下如果启动失败，修改 redis.windows.conf 文件中的 maxheap 为 ` maxheap 1024000000 `。

**注：** 开发需要依赖 Redis 环境，所以在启动后台程序时，请确保 Redis 已经启动，如redis需配置集群，[请参考Redis集群部署](/后端开发/redis.md)
* redis GUI 客户端下载 ：http://redisdesktop.com/
* redis 命令手册：http://doc.redisfans.com/
  * redis 清空缓存命令：flushall

> Mac, Linux 用户, 请到 http://redis.io 下载源码，编译安装
  
### 新建项目  (依赖融租易HLS1.0)
#### 确定项目信息
1. groupId  本项目的代号，比如融租易项目，代号为 hls
2. artifactId  本项目的顶层目录名称，使用项目代号,各个单词使用-连接，如 hls-custom
3. package 包名称，使用项目代号 + core ,如 Hls.core
4. archetypeVersion 是指模板项目的版本，可以使用以下版本号
>  1.0-RELEASE

确定上述信息后，可以使用如下命令新建项目：

`注意`  maven-archetype-plugin `2.4`及以下版本可以正常使用下面命令

```
mvn archetype:generate  -D archetypeGroupId=hls-custom -D archetypeArtifactId=hls-custom-parent-archetype -D archetypeVersion=1.0-RELEASE -D groupId=hls -D artifactId=hls-custom -D package=Hls.core -D version=1.0-RELEASE -D archetypeRepository=https://hls.hand-china.com/nexus/content/repositories/Hls-Releases

```

在maven-archetype-plugin `3.0.0` 版本中，移除了对-D archetypeRepository参数的支持，会报以下错误
![](/assets/mvn_archetype_plugin.png)

解决方案：
指定使用2.4版本的archetype-plugin插件：
```
mvn org.apache.maven.plugins:maven-archetype-plugin:2.4:generate  -D archetypeGroupId=com.hand.hls -D archetypeArtifactId=hls-custom-parent-archetype -D archetypeVersion=1.0.0-RELEASE -D groupId=com.hand.hls.custom -D artifactId=hls-custom -D package=com.hand.hls.custom -D version=1.0.0-RELEASE -D archetypeRepository=https://hel.hand-china.com/nexus/content/repositories/Hls-Releases

```


> 以下内容所指的 `hls-custom` 均指上面命令中的参数 `artifactId` 的值，请按实际情况替换

新的项目目录结构如下：
```
.
├── README.md (项目README，请在此处写上项目开发的注意信息，方便团队协同)
├── core（功能实现项目）
│   ├── pom.xml （子项目core的pom.xml文件）
│   └── src
│       └── main
│           ├── java
│           │   ├── hls
│           │   │   └── core（前面的包名称）
│           │   │       ├── db（数据表结构，数据初始化入口文件）
│           │   │       │   └── liquibase.groovy
│           │   └── resources（项目配置文件目录）
│           │       ├── spring （spring配置文件目录）
│           │       ├── config.properties
│           │       └── logback.xml（日志配置文件）
│           └── webapp（Webapp目录）
│               ├── resources（UI 资源库目录）
|               |        └── demo.js(demo.js样例，可以删除)
│               └── WEB-INF
│                   └── view（页面文件目录）
│                       └── demo.html（demo.html样例，可以删除）
├── core-db（数据库脚本及初始化数据项目）
│   ├── pom.xml
│   └── src
│       └── main
│           └── java
│               └── hls
│                   └── core
│                       └── db
│                           ├── data（数据文件）
│                           │   └── (init-data)
│                           └── table（数据库表结构管理）
│                               └── 2016-06-01-init-migration.groovy
└── pom.xml

```

### 确定本项目使用的数据库

> 目前已经测试过支持的数据库有Mysql,Oracle,SqlServer 
> 按照[创建数据库](/后端开发/database-init.md)中的步骤创建数据库
> 请修改 `hls-custom/core/src/main/java/hls/core/db/liquibase.groovy` 以适配不同的数据库

### 修改项目配置文件

[修改项目配置文件](/后端开发/database-config.md)


### 编译整个项目
在 HlsParent 目录下执行：
```
mvn clean install -Dmaven.test.skip=true
```

### 初始化数据库表结构及基础数据
在 HlsParent 项目录下执行：

- MySql 
     - `mvn process-resources -D skipLiquibaseRun=false -D db.driver=com.mysql.jdbc.Driver -D db.url="jdbc:mysql://127.0.0.1:3306/hls_dev?useUnicode=true&characterEncoding=utf8" -Ddb.user=hls_dev -Ddb.password=hls_dev`
- SqlServer 
     - `mvn process-resources -D skipLiquibaseRun=false  -Ddb.user=hls_dev -Ddb.password=hls_dev-D db.driver=com.microsoft.sqlserver.jdbc.SQLServerDriver -D db.url="jdbc:sqlserver://127.0.0.1:1433; DatabaseName=hls"`
- Oracle 
     - `mvn process-resources -D skipLiquibaseRun=false -D db.driver=oracle.jdbc.driver.OracleDriver -D db.url=jdbc:oracle:thin:@127.0.0.1:1521:hls -Ddb.user=hls_dev -Ddb.password=hls_dev`
     
- 以上命令中，需要按实际情况修改 url，user，password

### 测试
1. 在 HlsParent 工程目录下执行命令(IntelliJ IDEA 用户可以跳过此步骤)
  ```
  mvn eclipse:eclipse
  ```
2. 将项目工程导入 IDE 工具（Eclipse，IntelliJ IDEA）中，并配置服务（tomcat等）后启动运行。

### 更新HLS依赖

  [更新项目依赖的HLS版本](project-update.md)

