## hlsGrid

#### 表格

对于API文档中的所有属性，考虑实际需要，有些属性没必要实现，本文档若未列出，就代表并未实现

#### xml配置

```xml
 <!--h:为命名空间,必须要加的，grid为组件名;id可写可不写-->
 <h:hlsGrid id="grid"/>
```

```xml
<!--grid-->
<h:hlsGrid dataSource="dataSource" selectable="multiple, rowbox" editable="true">
    <h:pageable pageSizes="5, 10, 20, 50" buttonCount="5" refresh="true">
    </h:pageable>
    <h:columns>
        <h:column field="moduleCode" title='' width="100"/>
        <h:column field="functionCode" title='' width="180"/>
    </h:columns>
</h:hlsGrid>
```

---

对于所有属性，无论是直接属性，还是子标签的属性，都遵循以下原则：  
1.若是简单的属性，就添加到当前标签上，若是对象，就创建子标签，这里的简单属性是指能直接被描述在当前标签上的属性，如字符串，函数，\(函数只是一个引用\)，布尔类型，数字类型等等，对象是指这个属性又包含了子属性，所以我们不得不向下创建子标签才能将其子属性描述出来。  
2.对于String和Function类型，必须用fn：前缀加以区分，  
3.对于数组，有些数组是字符串数组，这种直接当作简单的属性处理，用逗号分隔每个字符串即可，有些数组是list集合数组，这种必须先创建属性子标签，再创建item子标签来描述集合，详情可参考子标签columns

---

### **一般属性 **

> **提示:**
>
> * 属性用法请参考kendoui API文档的grid: [http:\/\/docs.telerik.com\/kendo-ui\/api\/javascript\/ui\/gird](http://docs.telerik.com/kendo-ui/api/javascript/ui/gird)

| 属性名 | 类型 | 描述 |
| :--- | :--- | :--- |
| allowCopy | Boolean | 允许复制 |
| altRowTemplate | String & Function | 呈现交替表行的模板 |
| autoBind | Boolean | 绑定数据源 |
| columnResizeHandleWidth | Integer | 设置列宽度 |
| columnMenu | Boolean | 设置列菜单 |
| dataSource | kendo.data.DataSource\(Function\) | 数据源 |
| detailTemplate | String & Function | 呈现详细的模板 |
| editable | Boolean & String | 设置是否可编辑 |
| groupable | Boolean | 设置分组 |
| height | Integer & String | 设置高度 |
| mobile | Boolean & String | 设置网格 |
| navigatable | Boolean | 导航栏 |
| noRecords | Boolean | 显示类似“没有记录”的标记默认为false |
| pageable | Boolean | 显示网格默认为false |
| reorderable | Boolean | 拖动标题排序默认为false |
| resizable | Boolean | 拖动表格边缘来调大小 |
| rowTemplate | String & Function | 呈现一个行 |
| scrollable | Boolean | 出现滚动条 |
| selectable | Boolean & String | 可以选择默认为false |
| sortable | Boolean | 可以分组 |
| toolbar | String & Function | 表格上面设置按钮 |
| cancel | Function | 取消事件 |
| change | Function | 改变事件 |
| columnHide | Function | 列隐藏函数 |
| columnMenuInit | Function | 列菜单初始化触发事件 |
| columnReorder | Function | 更改列触发事件 |
| columnResize | Function | 可以调整列 |
| columnShow | Function | 展示列 |
| dataBinding | Function | 数据源绑定 |
| dataBound | Function | 数据加载完之后触发 |
| detailCollapse | Function | 折叠表行时触发 |
| detailExpand | Function | 展开表行时触发 |
| detailInit | Function | 表行初始化时触发 |
| edit | Function | 编辑时触发 |
| excelExport | Function | excel导出 |
| filter | Function | 过滤 |
| group | Function | 分组 |
| page | Function | 分页 |
| pdfExport | Function | pdf导出 |
| filterMenuInit | Function | 第一次打开筛选器时触发 |
| remove | Function | 点击删除按钮触发 |
| save | Function | 点击保存时触发 |
| saveChanges | Function | 点击保存时触发 |
| sort | Function | 排序 |
| columnLock | Function | 锁定列时触发 |
| columnUnlock | Function | 接触列锁定触发 |
| navigate | Function | 开启导航栏 |

用法示例：

```javascript
//注意这是写在script标签里的内容
var dataSource = new kendo.data.DataSource({
    data: [
        { name: "Jane Doe", age: 30 },
        { name: "John Doe", age: 33 }
    ]
});

function edit(){
//...
}

function rowTemplate(){
//...
}
```

```xml
<h:grid id="grid" dataSource="dataSource" resizable= "true" height= "100%" edit ="edit" rowTemplate="fn:rowTemplate"/>
```

> **提示:**
>
> * 上述所有属性直接添加在标签内即可，（**\[\*\***属性名\]**\*\* = "..."**）,对于类型是函数的属性，需要另外在script标签中具体定义函数，这里只是一个引用,对于类型**既是函数又是字符串**类型的属性，一定要加**fn:** 来区分，加fn:的代表这是一个函数，对于**既是字符串又是布尔类型**的属性，照常输入就行了。

#### **子标签**

| 属性名 | 类型 | 描述 |
| :--- | :--- | :--- |
| allowCopy | Object | 允许复制 |
| columns | Array | 列 |
| columnMenu | Object | 列菜单 |
| editable | Object | 是否可编辑 |
| messages | Object | 提示 信息 |
| scrollable | Object | 出现滚动条 |
| sortable | Object | 可以排序 |
| toolbar | Array | 按钮 |

#### **allowCopy**子标签

| 属性 | 类型 | 描述 |
| :--- | :--- | :--- |
| delimeter | String & Object | 同一行之间的分节符 |

```xml
<!--delimeter是Object类型-->
<h:hlsGrid>
    <h:allowCopy>
         <h:delimeter />
    </h:allowCopy>
</h:hlsGrid>

<!--delimeter是String类型-->
<h:hlsGrid>
    <h:allowCopy delimeter=",">
    </h:allowCopy>
</h:hlsGrid>
```

#### **columns**子标签

| 属性 | 类型 | 描述 |
| :--- | :--- | :--- |
| attributes | Object | 属性 |
| command | Object | 显示命令按钮 |
| editor | Function | 编辑时触发 |
| encoded | Boolean | 设置编码 |
| field | String | 字段id |
| footerTemplate | String & Function | 页脚表单 |
| format | String | 格式化 |
| sortable | Object | 可排序 |
| template | String & Function | 离开某个输入单元触发 |
| title | String | 标题 |
| width | Integer & String | 宽度 |
| hidden | Boolean | 隐藏 |
| menu | Boolean | 菜单 |
| locked | Boolean | 锁定 |
| columns | Object | 列 |
| filterable | Object | 可过滤 |
| groupable | Boolean | 可分组 |
| values | Array | 设置值 |

#### **columns-filterable**子标签

| 属性 | 类型 | 描述 |
| :--- | :--- | :--- |
| cell | Object | 设置为行时头单元格的选项 |
| dataSource | Function | 数据源 |
| itemTemplate | Function | 允许制定逻辑 |
| operators | Object | 单元格过滤默认运算符 |
| search | Boolean | 查询 |
| ui | Object | ui |

**attributes**用法:

```xml
  <h:hlsGrid>
      <h:columns>
          <h:column>
               <h:attributes "style"="text-align:center"/>
          </h:column>
      </h:columns>
  </h:hlsGrid>
```

**command**用法：

```xml
<!--对于数组来说，有两种形式，一种是直接用逗号分隔，放在标签上的,如 aggregates;另一种是创建子标签，再创建item子标签，再将数组内的内容整合到item子标签上，如command，先创建command子标签，再创建item子标签，再将数组中的每一个集合放在item标签上-->
<h:hlsGrid>
   <h:columns aggregates="count,min,max">
      <h:column template="fn:template"/>
      <h:column field="functionId" width="30px/>
      <h:column title="列头" locked="true">
          <h:command>
             <h:item name="edit"></h:item>
             <h:item name="destroy"></h:item>
          </h:command>
      </h:column>
   </h:columns>
</h:hlsGrid>
```

**editor**用法：

```javascript
function editor(){
//...
}
```

```xml
<h:hlsGrid>
    <h:columns>
         <h:column editor="editor">
         </h:column>
    </h:coulmns>
</h:hlsGrid>
```

**filterable**用法：

```xml
<!--以filterable举例 遇到对象就向下添加子标签-->
<h:hlsGrid>
     <h:columns>
          <h:column>
              <h:filterable>
                   <h:cell dataTextField="name"/>
              </h:filterable>
          </h:column>   
     </h:columns>
</h:hlsGrid>
```

**headerAtrributes**用法:

```xml
<h:hlsGrid>
    <h:columns>
        <h:column>
             <h:headerAttributes "style"="color:red">
        </h:column>
    </h:columns>
</h:hlsGrid>
```

#### **ColumnMenu**子标签

| 属性 | 类型 | 描述 |
| :--- | :--- | :--- |
| columns | Boolean | 列 |
| filterable | Boolean | 允许过滤 |
| sortable | Boolean | 允许排序 |
| messages | Object | 消息内容 |

用法:

```xml
<h:hlsGrid id="grid">
    <h:columnMenu columns="true" fileterable="false">
        <h:messages columns="choose columns"/>
    </h:columnMenu>
</h:hlsGrid >
```

#### **editable**子标签

| 属性 | 类型 | 描述 |
| :--- | :--- | :--- |
| confirmation | Object | 执行销毁命令时弹出提示框 |
| cancelDelete | String | 执行销毁命令时的提示框用于取消 |
| confirmDelete | String | 执行销毁命令提示框用于确定 |
| destroy | Boolean | 设置删除数据项 |
| mode | String | 设置编辑模式 |
| template | String & Function | 弹出编辑器的模板 |
| update | Boolean | 设为true可以编辑数据项 |

用法:

```xml
<h:hlsGrid id="grid">
    <h:columnMenu columns="true" fileterable="false">
        <h:messages columns="choose columns"/>
    </h:columnMenu>
</h:hlsGrid >
```

#### **pageable**子标签

| 属性 | 类型 | 描述 |
| :--- | :--- | :--- |
| pageSize | Integer | 设置页大小 |
| previousNext | Boolean | 可以选择上一页 |
| numeric | Boolean | 显示默认按钮 |
| buttonCount | Integer | 按钮总数 |
| input | Boolean | 提供输入任意页码的框 |
| pageSizes | Boolean & Array | 选择每页显示大小 |
| refresh | Boolean | 刷新 |
| info | Boolean | 显示分页情况 |
| messages | Object | 显示文本信息 |

用法:

```xml
<!--pageSizes 为array时-->
<h:hlsGrid>
   <h:pageable pageSizes="all,5,10,20,50" buttonCount="5" refresh="true">
      <h:messages display="show"/>
   </h:pageable>
</h:hlsGrid>
```

#### **messages**子标签

| 属性 | 类型 | 描述 |
| :--- | :--- | :--- |
| commands | Object | 显示命令按钮的文本，主要用于本地化 |
| noRecords | String | 定义没有数据时的视图 |

用法:

```xml
<h:hlsGrid>
   <h:messages noRecords="no data">
      <h:commands cancel="cancel"/>
   </h:messages >
</h:hlsGrid>
```

#### **noRecords**子标签

| 属性 | 类型 | 描述 |
| :--- | :--- | :--- |
| template | String & Function | 当前视图无记录时的展示 |

用法:

```xml
<h:hlsGrid>
    <h:noRecords template="no records">
    </h:noRecords>
</h:hlsGrid>
```

#### **scrollable**子标签

| 属性名 | 类型 | 描述 |
| :--- | :--- | :--- |
| virtual | String | 显示单页数据 |

用法:

```xml
<h:hlsGrid>
    <h:scrollable virtual="true"/>
</h:hlsGrid>
```

#### **sortable**子标签

| 属性 | 类型 | 描述 |
| :--- | :--- | :--- |
| allowUnsort | Boolean | 设置单行或者多行排序 |
| mode | String | 设置单行或者多行排序 |

用法:

```xml
<h:hlsGrid>
   <h:sortable allowUnsort="true" mode="multiple"/>
</h:hlsGrid>
```

#### **toolbar**子标签

| 属性 | 类型 | 描述 |
| :--- | :--- | :--- |
| name | String | 名字 |
| template | String & Function | 按钮展示模板 |
| text | String | 设置名称 |

```javascript
function template(){
//...
}
```

```xml
<!--toolbar是数组 所以属性都是针对于数组内的集合来说的-->
<h:hlsGrid>
   <h:toolbar>
      <h:item name="create">
            <!--当template为String时，由于xml会对标签的封闭符号敏感，所以可以采取下面的方式-->
            <h:template>
              <![CDATA[<span class=" btn btn-primary k-grid-add">#=text#</span>]]>
            </h:template>
         </h:item>
   </h:toolbar>
</h:hlsGrid>
```

> **提示**：
>
> * 遇到**object**类型 就向下添加子标签，当遇到普通类型时，就添加到当前的标签上,就像处理一般属性那样。   






### 任务通知栏（noticeTable）

    
    
```xml
    <h:hlsGrid gridType="noticeTable" titleSearchId="titleSearchId" titleSearchInputId="titleSearchInputId"
               hlsDataSource="taskListData" title="任务列表" inputPlaceHolder="搜索任务" titleIcon="fa fa-tasks"
               inputImg="${base.contextPath}/resources/images/MAIN/hls-todo-search.png" locateEvent="af" maxPageSize="3"
               id="noticeTable"></h:hlsGrid>
```


**常用属性**

| 属性名 | 类型 | 作用 | 是否必输|
|:---: | :---: | :---: | :---: | 
| id | string | 唯一标识  | Y |
| gridType | string | 组件类型  | Y |
| titleSearchId | string | input查询框图标的id | 
| titleSearchInputId | string | input框id | 
| hlsDataSource | Array | 数据源 | 
| title | string | 组件标题 | 
| titleIcon | string | 组件标题icon(字体图标) |
| inputImg | string | 查询框图标 ||
| locateEvent | function | 行点击事件调用的函数|
| maxPageSize | Number | 记录最大的条数||



**提示：**
 >- 每个noticeTable在window下面都会有以该ID命名的对象，该对象上有以下常用方法  
 
 
| 方法名 | 参数 | 返回值 | 作用|
|:---: | :---: | :---: | :---: | 
| renderUI |  |   | 重新渲染图表,(渲染之前改变传入的数据等信息)|
| selectCheckedItem |  | 选中行的数据信息 | 获得选中行的数据信息|


>- locateEvent参数传递一个定义好的方法名字,locateEvent = "testFunc"     

```javascript
function testFunc(e,rowdata){
    
}

```
该函数返回两个参数，参数1: 事件对象; 参数2: 该行数据信息






