## NumericTextBox

提示：以下配置，方法和事件均为个人了解到的，不代表组件的全部。

### 配置：

##### 1.[culture](http://docs.telerik.com/kendo-ui/api/javascript/ui/numerictextbox#configuration-culture)[`String`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)_\(default: "en-US"\)_

```html
<!--
    TODO: Add the kendo.culture.de-DE.min.js file as it is required!
    Here is a sample script tag:
    <script src="http://kendo.cdn.telerik.com/{kendo version}/js/cultures/kendo.culture.de-DE.min.js">
    </script>
    For more information check this help topic:
    http://docs.telerik.com/kendo-ui/framework/globalization/overview
-->
<input id="numerictextbox"/>
<script>
    $("#numerictextbox").kendoNumericTextBox
    ({
        culture:"de-DE"
    });
</script>
```

##### 2.[decimals](http://docs.telerik.com/kendo-ui/api/javascript/ui/numerictextbox#configuration-decimals)[`Number`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)_\(default: null\)_

说明：指定数量精度NumericTextBox时。 例如,如果小数是`2`和用户输入`12.346`,将成为价值`12.35`。 如果用户输入`12.99`,将成为价值`13.00`。

```html
<input id="numerictextbox"/>
<script>
    $("#numerictextbox").kendoNumericTextBox
    ({
        decimals:2
    });
</script>
```

##### 3.[downArrowText](http://docs.telerik.com/kendo-ui/api/javascript/ui/numerictextbox#configuration-downArrowText)[`String`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)_\(default: "Decrease value"\)_

```html
<input id="numerictextbox"/>
<script>
    $("#numerictextbox").kendoNumericTextBox
    ({
        downArrowText:"Less"
    });
</script>
```

4.[factor](http://docs.telerik.com/kendo-ui/api/javascript/ui/numerictextbox#configuration-factor)[`Number`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)_\(default: "1"\)_

说明：假设以数字15输入，并把NumberitextBox的属性设为0.01，则显示的结果为15%。

```html
<input id="numerictextbox" />

<script>
$("#numerictextbox").kendoNumericTextBox({
   format: "p0",
   factor: 100,
   min: 0,
   max: 1,
   step: 0.01
});
</script>
```

输入前：![](/assets/2.png)输入后：![](/assets/3.png)

##### 5.[format](http://docs.telerik.com/kendo-ui/api/javascript/ui/numerictextbox#configuration-format)[`String`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)_\(default: "n"\)_

说明： 设置控件显示的格式，常用的有c（货币形式）、n（数值形式）和p（百分比形式），实例中的c3表示货币形式，精确到小数后三位。

```html
<input id="numerictextbox" />
<script>
$("#numerictextbox").kendoNumericTextBox({
   format: "c3"
});
</script>
```

输入前：![](/assets/4.png)输入后：![](/assets/5.png)

##### 6.[max](http://docs.telerik.com/kendo-ui/api/javascript/ui/numerictextbox#configuration-max)[`Number`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)_\(default: null\)_

说明：限制显示的最大数

```html
<input id="numerictextbox" />
<script>
$("#numerictextbox").kendoNumericTextBox({
    max: 100
});
</script>
```

输入前：![](/assets/20170727140825.png)输入后：![](/assets/20170727140905.png)

##### 6.[placeholder](http://docs.telerik.com/kendo-ui/api/javascript/ui/numerictextbox#configuration-placeholder)[`String`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)_\(default: ""\)_

说明：设置文本框里面的默认值

```html
<input id="numerictextbox" />
<script>
$("#numerictextbox").kendoNumericTextBox({
    placeholder: "Set A Value"
});
</script>
```

![](/assets/20170727190929.png)

##### 7.[restrictDecimals](http://docs.telerik.com/kendo-ui/api/javascript/ui/numerictextbox#configuration-restrictDecimals)[`Boolean`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)_\(default: false\)_

说明：当点击文框，是否允许设置显示的最大小数长度

```html
<input id="numerictextbox" />
<script>
$("#numerictextbox").kendoNumericTextBox({
    decimals: 3,
    restrictDecimals: false
});
</script>
```

点击前：![](/assets/1500.png)点击中：![](/assets/91517.png)

##### 8.[spinners](http://docs.telerik.com/kendo-ui/api/javascript/ui/numerictextbox#configuration-spinners)[`Boolean`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)_\(default: true\)_

说明：是否启用文本框右边的上下按钮

```html
<input id="numerictextbox" />
<script>
$("#numerictextbox").kendoNumericTextBox({
    spinners: false
});
</script>
```

##### 9.[step](http://docs.telerik.com/kendo-ui/api/javascript/ui/numerictextbox#configuration-step)[`Number`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)_\(default: 1\)_

说明：点击右边上下按钮增加或者减少的值

```html
<input id="numerictextbox" />
<script>
$("#numerictextbox").kendoNumericTextBox({
    step: 0.1
});
</script>
```

##### 10.[value](http://docs.telerik.com/kendo-ui/api/javascript/ui/numerictextbox#configuration-value)[`Number`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)_\(default: null\)_

说明：设置默认值

```html
<input id="numerictextbox" />
<script>
$("#numerictextbox").kendoNumericTextBox({
    value: 10
});
</script>
```

### 方法：

##### 1.[enable](http://docs.telerik.com/kendo-ui/api/javascript/ui/numerictextbox#methods-enable)

说明：是否启用编辑

```html
<input id="numerictextbox" disabled="disabled" />
<script>
$("#numerictextbox").kendoNumericTextBox();
var numerictextbox = $("#numerictextbox").data("kendoNumericTextBox");
numerictextbox.enable(false);
</script>
```

![](/assets/193025.png)

##### 2.[readonly](http://docs.telerik.com/kendo-ui/api/javascript/ui/numerictextbox#methods-readonly)

说明：是否启用只读

```html
<input id="numerictextbox" />
<script>
$("#numerictextbox").kendoNumericTextBox();
var numerictextbox = $("#numerictextbox").data("kendoNumericTextBox");
numerictextbox.readonly();
</script>
```

![](/assets/93141.png)

##### 3.[focus](http://docs.telerik.com/kendo-ui/api/javascript/ui/numerictextbox#methods-focus)

说明：聚焦

```html
<input id="numerictextbox" />
<script>
$("#numerictextbox").kendoNumericTextBox();
var numerictextbox = $("#numerictextbox").data("kendoNumericTextBox");
numerictextbox.focus();
</script>
```

##### 4.[value](http://docs.telerik.com/kendo-ui/api/javascript/ui/numerictextbox#methods-value)

说明：获取和设置值

```html
<input id="numerictextbox" />
<script>
$("#numerictextbox").kendoNumericTextBox();
var numerictextbox = $("#numerictextbox").data("kendoNumericTextBox");
//获取值
var value = numerictextbox.value();
//设置值
numerictextbox.value(0.5);
</script>
```

### 事件：

##### 1.[change](http://docs.telerik.com/kendo-ui/api/javascript/ui/numerictextbox#events-change)

```html
<input id="numerictextbox" />
<script>
//方法一
$("#numerictextbox").kendoNumericTextBox({
    change: function() {
        var value = this.value();
    }
});
//方法二
$("#numerictextbox").kendoNumericTextBox();
var numerictextbox = $("#numerictextbox").data("kendoNumericTextBox");
numerictextbox.bind("change", function() {
    var value = this.value();
});
</script>
```



