

# 前端开发规范

前端开发规范

### I. 文件命名规范

* html,js,scss文件命名统一用小写的英文字母且三个文件名必须相同，若文件名过长可以简写或者有`-`链接，不得包含汉字空格和特殊字符。

### 原则：

* 1）方便理解，见名知义  
* 2）方便查找

    ![](/picture/h.png)

### [II. controller命名规范(js)](id:controller)

*  控制器命名统一用 文件名+Ctrl，若文件名拼接则第一个单词首字母小写其余单词首字母大写,另外为了方便前台调用需要给每个控制器as一个别名（每个控制器命名和别名的设定必须具有唯一性），如下图所示：

    ![](/picture/h4.png)
    
*  js文件的书写具有规范性，不安规范书写会出错

    ![](/picture/js-controller.png)   
    
     - 严格遵循MVC模式
     - controller名称不允许从复
     - js中许多地方都有controller，编写js是全部修改过来
     - angularjs 采用依赖注入的方式，服务注入顺序必须保持一致即如下图,js中需要哪些服务注入哪些，多余的建议删除
     
     ![](/picture/controller-server.png)
     
*  采用 `this`关键字代替js中 `$scope`，因存在效率问题

    ![](/picture/controller-this.png)
    
*  html中使用`controller`需要注意，因变量声明不采取`$scope`方式，故html中使用有点区别。采用`controller`别名加属性名的方式  如下

    ![](/picture/controller-html.png)  
   

### III. 样式文件的编写

*  样式文件采用SASS语法规则与CSS语法差别不大
，具体语法参考http://www.w3cplus.com/sassguide/syntax.html 样式文件的编写安照如下所示

    ![](/picture/scss.png)
    
    ![](/picture/html-scss.png)
    
      - 页面上需引用`public-style`为项目上写好的公用样式
      - 申明自己的样式`partner-create`此样式不能重复，建议使用文件名，页面上其余样式均写在此样式之下，若超过此样式如下图,此样式为全局样式，对所有页面都会产生影响。不允许此类写法
      
        ![](/picture/scss-globle.png)
*  因采用混合开发，经常会遇到Android与IOS样式不一样，处理不同平台的样式文件统一写在`scss/publicStyle.scss`文件里面

    ![](/img/scss-ios.png)
    
*  当创建一个新SCSS文件后，要在theme目录下app.core.scss文件里import,如下图所示：

    ![](/picture/h1.png)

    ![](/picture/h3.png)

### IV. 前端样式开发注意点

* 1）class选择器在SCSS文件里编写样式时要注意在前面加‘.’ ，如下图所示：

    ![](/picture/a.png)

* 2）前端布局开发，建议使用flex布局（方便）
* 3）前端样式在写宽度 width时，必须使用百分号（%）来确定宽度，不允许使用px。原因：使用%来确定width，不会随着屏幕的增大而导致样式改变。如下图所示：

    ![](/picture/a1.png)

* 4）前端当一个页面引入了model框，那么要在该页面的scss下方导入model框的scss。如下图所示：

    ![](/picture/a2.png)


