# SVC及接口开发规范

***
* ### I. SVC文件创建
***

 * 1.1 创建svc文件所在位置
***
SVC文件创建的所在位置是在项目的web目录下modules文件夹下创建。这里为了方便与便捷，可以直接复制现有的SVC文件，粘贴到指定目录下，然后rename一下即可进行开发编写。
![](/picture/svc.png)
 * 1.2 svc文件命名规范
***

统一用小写的英文字母，数字和下划线的组合，不得包含汉字空格和特殊字符。

原则： 1）方便理解，见名之意。

​      2）方便查找。
如图所示：
![](/picture/svc1.png)
***

* ### II. BM文件创建
***

 * 2.1 创建BM文件所在位置
***
bm文件创建的所在位置是在项目的WEB-INF目录下classes文件夹下创建。这里为了方便与便捷，可以直接复制现有的bm文件，粘贴到指定目录下，然后rename一下即可进行开发编写。（ps:bm文件所在classes目录下位置要和svc所在modules目录下位置相同）
![](/picture/bm.png)
 * 2.2 BM文件命名规范
***
统一用小写的英文字母，数字和下划线的组合，不得包含汉字空格和特殊字符。
原则： 1）方便理解，见名之意。
​ 2）方便查找。

如图所示：
![](/picture/bm1.png)
* ### III. SVC及接口开发
***
 * 3.1 svc文件主要编写的内容
***
svc文件主要编写的内容是大致是关联对应的bm文件，执行对应的sql语句，如果有返回数据，则对返回的数据进行相关的处理和展示。
如图所示：![](/picture/svc2.png)
 * 3.2 bm文件主要编写的内容
***
BM文件关联数据库，接口通过调用BM文件访问到数据库，执行脚本对数据进行处理，并返回相关数据。(个人感觉类似于hibernate)
BM 文件 可以是一个查表语句，也可以是一个调用数据库存储过程。
![](/picture/svc3.png)
parameters和fields用法：
1）parameters  用来传参的从svc传到bm里,如图：![](/picture/bm2.png)
2）fields   用来从bm传到svc，如图：![](/picture/bm3.png)
![](/picture/svc4.png)
* ### IV. 页面注册
***
当接口写完时，需要写一个注册脚本目录如图下所示：![](/picture/sql.png)
注册脚本写法如图下所示：![](/picture/sql1.png)
写完之后需要将脚本语句在拿到数据库中执行并且commit步骤如图下所示：![](/picture/sql2.png)



