## 公用封装函数
APP开发会出现很多功能相同的函数和组件，现封装了很多公共函数可直接调用减少开发时间，提高开发效率。需在`controller`中注入`hlsUtil`服务。
##### 1.校验身份证号 `isCardID`函数
- 函数参数为`( 身份证号码 )`。
- 返回值为`( 身份证校验结果 )`，通过返回空，不通过返回具体内容。
- 调用如下

  ```javascript
  function checkIdCard(){
    var result =hlsUtil.isCardID(342623198712122312);
    if(result){
      hlsPopup.showShortCenterToast(result);
    }
  }
  ```

##### 2.时间格式化函数 `Date.prototype.format`
- 函数参数为`( 格式字符串 )` 如 `yyyy-MM-dd`
- 返回值为`( 格式化后的时间 )` 如 `2017-09-08`
- 调用实例如下

  ```javascript
  function dataFormat() {
    var date = new Date;
    alert(date.format('yyyy-MM-dd'));
  }
  ```

##### 3.数组移除函数 `Array.prototype.remove`
- 函数参数为`( 数组下标 )`
- 返回`( 新的数组 )`
- 调用实例如下

  ```javascript
  function arrayRemove() {
    var array=['1','2','3'];
    alert(angular.toJson(array.remove(1)));
  }
  ```

##### 4.对象转成数组 `objToString`
- 函数参数为`( 对象 )`
- 返回`( 字符串 )`
- 调用实例如下

  ```javascript
  function objToString(){
    var obj={
      "apiKey":'123123SFgy',
      "apiSecret":'QEZ!$XHFHFTV'
    }
    hlsUtil.objToString(obj);
  }
  ```

##### 5.判断数组中是否含有某个元素  `inArray`
- 函数参数为`( 数组、元素 )`
- 返回 `true of false`
- 调用实例如下

  ```javascript
  function inArray(){
    var array=['1','2','3'];
    var ele = 2;
    hlsUtil.inArray(array,ele);
  }
  ```

##### 6.判断是否为11电话号码 `phoneNumber`
- 参数为`( 手机号 )`
- 通过正则表达式校验 返回 `true of false`
- 调用实例如下

  ```javascript
  function phoneNumber(){
      alert(hlsUtil.phoneNumber(18325379820));
    }
  ```

##### 7.判断+86后11位电话号码 `phoneNumber86`
- 参数为`( 手机号 )`
- 通过正则表达式校验 返回 `true of false`
- 调用实例如下

  ```javascript
  function phoneNumber86(){
    alert(hlsUtil.phoneNumber86('+8618325379820'));
  }
  ```

##### 7.是否是邮件格式 `isEmailAddress`
- 参数为`( 邮箱地址 )`
- 通过正则表达式校验 返回 `true of false`
- 调用实例如下

  ```javascript
  function isEmailAddress(){
      alert(hlsUtil.isEmailAddress('jingchao.wu@hand-china.com'));
    }
  ```
  
##### 8.拨打电话 `callPhone`
- 参数为`( 电话号码 )`
- 调用实例如下

  ```javascript
  //打电话
  function callPhone() {
    hlsUtil.callPhone('18325379820');
  }
  ```
- 实现效果如下
  
  ![](/img/callPhone.PNG)

##### 9.操作表 `showSheet`
- 参数1`(sheet标题)`
- 参数2`(操作列表)数组形式`如`['拍照', '从相册选择']`
- 参数3`(回调函数 function)` 回调函数返回操作列表的`index`可自行根据返回值进行其他操作
- 调用实例如下
```javascript
vm.showSheet = function () {
    hlsUtil.showSheet('照片选择方式', ['拍照', '从相册选择'], function (index) {
      alert(index);
    })
  }
```

- 实现效果如下

  ![](/img/ionicSheet.PNG)


##### 10.图片转成base64 `getImageToBase64`
- 参数1`( 图片地址)`
- 参数2`(回调函数 function)`回调函数返回图片的Base64位
- 调用实例如下

  ```javascript
  vm.imageTo64 = function () {
    hlsUtil.getImageToBase64('build/img/login/icon.png', function (imgdata) {
      alert(imgdata);
    });
  }
  ````






