## 金融工商函数类
 租赁系统都会进行报价计算而后台PKG计算报价的方法太慢，严重影响效率，现封装了一些金融计算公式，包括PMT，PV，IRR等。** 前段计算会出现小数精度问题，特别是IRR，一般情况下只能作为参考** 需在`controller`中注入`hlsFinance`服务。

 
 ##### 一、PMT计算公式
 - 需要传递的参数如下
 ```javascript
 /**
   * @param ir  interest rate per month
   * @param np  number of periods (months)
   * @param pv  present value
   * @param fv  future value (residual value)
   * @returns {number} 计算结果;
   * @constructor
   */
   PMT: function (ir, np, pv, fv, type) {
   }
 ```
 - 调用实例如下
 ```javascript
 hlsFinance.PMT(int_rato / pay_times, lease_times, -(result.finance_amount), 0, 0)
 ```
 ##### 二、IRR计算公式 
 - 需要传递的参数为 数组
 - 调用实例** irr会出现精度缺失不可作为实际值 **
 ```javascript
   function IRR() {
    var array = [-950000, 90258.31, 90258.31, 90258.31, 90258.31, 90258.31, 90258.31, 90258.31, 90258.31, 90258.31, 70358.31];
    var irr = hlsFinance.IRR(array);
  }
 ```
 ##### 三、其他金融公式可自行参考 
   app\scripts\util-finance.js
 

