## 一、前端开发说明
1. 所有的项目文件必须采用UTF-8编码，IDEA及Eclipse需要手动设置项目编码以及编译编码。 
    - Eclipse中修改项目编码的方法参考：[Eclipse修改编码方法](http://jingyan.baidu.com/article/647f0115b0c9887f2148a822.html)  
    - IDEA中修改项目编码的方法参考：[IDEA修改编码方法](http://jingyan.baidu.com/article/948f5924e4de57d80ff5f998.html])    
2. 前端开发采用Angular的MVC模式,项目中预设了一些`module`每个`module`的作用在此简单说明(原则上不允许项目组进行更改)
```javascript
var applicationModule = angular.module('applicationModule',[]);
var chartsModule = angular.module('chartsModule',[]);
var toolsModule = angular.module('toolsModule',[]);
var myInfoModule = angular.module('myInfoModule',[]);
var workflowModule = angular.module('workflowModule',[]);
var derectiveModule = angular.module('derectiveModule',[]);
var tabModule = angular.module('tabModule',[]);
var loginModule = angular.module('loginModule',[]);
var utilModule = angular.module('utilModule',[]);
var JPushServiceModule = angular.module('JPushServiceModule',[]);
```
  *  `applicationModule`是主页tab各个功能使用的module
  *  `chartsModule`是报表tab使用的module
  *  `toolsModule`是工具tab使用的module
  *  `myInfoModule`是我的tab使用的module
  *  `tabModule`是tab使用的module
  *  `loginModule`是登录页面的使用的module
  *  `utilModule`是各个工具js的module
  
3. 项目中预设4个view分别为`tab-applications`,`tab-charts`,`tab-tools`,`tab-myInfo`
  *  `tab-applications`是主页tab各个功能使用的view
  *  `tab-charts`是报表tab功能使用的view
  *  `tab-tools`是工具tab使用的view
  *  `tab-myInfo`是我的tab使用的view
  
4.  在此举例主页tab申请创建功能
```javascript
angular.module('starter')
  .config(['$stateProvider',
    function ($stateProvider) {
      $stateProvider
        .state('tab.project-create', {
          url: '/project-create',
          views: {
            "tab-applications": {
              templateUrl: 'build/pages/applications/project-create/project-create.html',
              controller: 'projectCreateCtrl as pCreat'
            }
          }
        })
    }]);
angular.module('applicationModule')
  .controller('projectCreateCtrl', projectCreateCtrl);
projectCreateCtrl.$injet = ['$state', '$scope', '$ionicModal', 'baseConfig', 'hlsHttp',
  'hlsPopup','$stateParams'];
function projectCreateCtrl($state, $scope, $ionicModal, baseConfig, hlsHttp,
                           hlsPopup,$stateParams) {
  var vm = this;
```  
  **注册此页面的路由,路由指向project-create.html页面**
  
    ![](/picture/ionic-controller.png)
  
     **路由名称不能从复**
  *   使用`tab-applications` 的view，使用`applicationModule` modele
  *   定义`projectCreateCtrl`并取别名`pCreat` controller,命名规范参考[前端开发规范](/ionic/ionic-code-style.md)
  
     **同一应用controller不能从复**
  *   html页面的编写
  在html页面中调用controller里面的属性时
  
     ```javascript
   <div class="next-button" ng-click="pCreat.create(pCreat.project)">创建</div>
     ``` 
     **必须使用controller 别名如`pCreat.create()`函数**
     
      


































































