# 弹框提醒工具类

APP开发经常会安功能需求弹出各种提示框，此工具类封装了大部分提提示框，需在`controller`中注入`hlsPopup`服务。
#####  一、  弹出等待框`showLoading`
 - 一般用于后台处理数据时调用(锁屏),此方法需要手动解屏。调用实例如下
 
   ```javascript
   function showLoading(){
    hlsPopup.showLoading('请等待');
     //TODO 其他业务逻辑执行
    hlsPopup.hideLoading();
   }
   ```
   
   ![](/img/showloading.png)
 
#### 二、长时间底部提示框 `showLongCenterToast`
 - 一般用于提示用户字段合法性，或保存提交成功的提示等其他业务场景，代码试下如下
 
   ```javascript
   function showLongCenterToast(){
      hlsPopup.showLongCenterToast('请输入密码!');
   }
   ```
 - 函数接受一个参数`content`及内容
 - 实现的效果如下
 
     ![](/img/showToast.jpg)
  
  
#### 三、弹出确认提示框 `confirm`
 - 弹出框进行用户确认，代码实现如下
 
   ```javascript
   function open_new_win() {
      hlsPopup.confirm('技术小哥经过不懈努力...', '版本更新', function (index) {
        alert(index);
      });
    }
  ```
 - 此函数接受三个参数`content`提示内容，可以为空、`title`标题，不为空、`onConfirm`回调函数，函数返回`index` 0表示取消，1表示确定,可根据返回值执行其他逻辑。
 - 效果如下
 
     ![](/img/showConfirm.png)
  

 
 
