/**
 * 一些帮助函数
 */

/**
 * setTimeout 的 promise 封装
 * @param {Number} time
 * @returns
 */
export function timeout (time) {
  return new Promise(resolve => {
    setTimeout(resolve, time)
  })
}

/**
 * 断言
 * @param {any} condition 条件
 * @param {any} msg 信息
 */
export function assert (condition, msg) {
  if (!condition) throw new Error(`[hls-ui] ${msg}`)
}

/**
 * 改变 case 格式为 param
 * @param {String} str 字符串
 */
export function case2Param (str) {
  assert(typeof str === 'string', 'case2Param 传入数据类型错误：应为 String')

  str = str.replace(/^[A-Z]/g, $0 => $0.toLowerCase())
  return str.replace(/[A-Z]/g, $0 => `-${$0.toLowerCase()}`)
}

/**
 * 判断平台
 * @return {String} 平台
 */
export function detectOS () {
  const ua = navigator.userAgent.toLowerCase()

  if (/MicroMessenger/i.test(ua)) {
    return 'weixin'
  } else if (/iPhone|iPad|iPod|iOS/i.test(ua)) {
    return 'ios'
  } else if (/Android/i.test(ua)) {
    return 'android'
  } else {
    return 'other'
  }
}

/**
 * 取URL上的参数
 * @param  {String} param 参数名
 * @return {String}
 */
export function getUrlParam (param) {
  const result = window.location.href.match(new RegExp('(\\?|&)' + param + '(\\[\\])?=([^&#]*)'))
  return result ? result[3] : undefined
}

/**
 * 动态插入 script to html
 * @param url
 * @param callback
 */
export function createScript (url, callback) {
  const oScript = document.createElement('script')
  oScript.type = 'text/javascript'
  oScript.async = true
  oScript.src = url

  /**
   * IE6/7/8                -- onreadystatechange
   * IE9/10                 -- onreadystatechange, onload
   * Firefox/Chrome/Opera   -- onload
   */

  const isIE = !-[1,] // eslint-disable-line
  if (isIE) {
    // 判断IE8及以下浏览器
    oScript.onreadystatechange = function () {
      if (this.readyState === 'loaded' || this.readyState === 'complete') {
        callback && callback()
      }
    }
  } else {
    // IE9及以上浏览器，Firefox，Chrome，Opera
    oScript.onload = function () {
      callback && callback()
    }
  }

  document.body.appendChild(oScript)
}

export function range (num, min, max) {
  return Math.min(Math.max(num, min), max)
}

function trimExtraChar (value, char, regExp) {
  const index = value.indexOf(char)

  if (index === -1) {
    return value
  }

  if (char === '-' && index !== 0) {
    return value.slice(0, index)
  }

  return value.slice(0, index + 1) + value.slice(index).replace(regExp, '')
}

export function formatNumber (value, allowDot) {
  if (value) {
    if (allowDot) {
      value = trimExtraChar(value, '.', /\./g)
    } else {
      value = value.split('.')[0]
    }

    value = trimExtraChar(value, '-', /-/g)

    const regExp = allowDot ? /[^-0-9.]/g : /[^-0-9]/g

    return value.replace(regExp, '')
  }
}

export function isDef (val) {
  return val !== undefined && val !== null && val !== ''
}

export function isUndefined (value) {
  return Object.prototype.toString.call(value) === '[object Undefined]'
}

export function isString (value) {
  return Object.prototype.toString.call(value) === '[object String]'
}
export function isNumber (value) {
  return Object.prototype.toString.call(value) === '[object Number]'
}
export function isBoolean (value) {
  return Object.prototype.toString.call(value) === '[object Boolean]'
}
export function isNull (value) {
  return Object.prototype.toString.call(value) === '[object Null]'
}
export function isObject (value) {
  return Object.prototype.toString.call(value) === '[object Object]'
}
export function isFunction (value) {
  return Object.prototype.toString.call(value) === '[object Function]'
}
export function isArray (value) {
  return Object.prototype.toString.call(value) === '[object Array]'
}
export function isDate (value) {
  return Object.prototype.toString.call(value) === '[object Date]'
}
export function isRegExp (value) {
  return Object.prototype.toString.call(value) === '[object RegExp]'
}
