import Vue from 'vue'
import Router from 'vue-router'
const Home = resolve => require.ensure([], () => { resolve(require('@/pages/home')) }, 'home')
const ModuleFunction = resolve => require.ensure([], () => { resolve(require('@/pages/homeManager/module-function')) }, 'home')
// test工具类
const HlsPopup = resolve => require.ensure([], () => { resolve(require('@/pages/hlsPopup')) }, 'test')
const EsignPicture = resolve => require.ensure([], () => { resolve(require('@/pages/applications/utils/esignPicture')) }, 'test')
{{#wfl}}
// 工作流
const WorkflowList = resolve => require.ensure([], () => { resolve(require('@/pages/applications/workflow/workflow-list')) }, 'wfl')
const WorkflowDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/workflow/workflow-detail')) }, 'wfl')
{{/wfl}}

{{#bp}}
// 商业伙伴
const PartnerCreate = resolve => require.ensure([], () => { resolve(require('@/pages/applications/partnerManager/partner-create')) }, 'bp')
const PartnerList = resolve => require.ensure([], () => { resolve(require('@/pages/applications/partnerManager/partner-list')) }, 'bp')
const PartnerMainten = resolve => require.ensure([], () => { resolve(require('@/pages/applications/partnerManager/partner-mainten')) }, 'bp')
const PartnerOrgMainten = resolve => require.ensure([], () => { resolve(require('@/pages/applications/partnerManager/partner-org-mainten')) }, 'bp')
{{/bp}}


{{#project}}
// 融资试算
const CalculationEnter = resolve => require.ensure([], () => { resolve(require('@/pages/applications/financCalculate/calculationEnter')) }, 'project')
const CalculationMain = resolve => require.ensure([], () => { resolve(require('@/pages/applications/financCalculate/calculationMain')) }, 'project')
const ResultMain = resolve => require.ensure([], () => { resolve(require('@/pages/applications/financCalculate/resultMain')) }, 'project')
const ResultDetails = resolve => require.ensure([], () => { resolve(require('@/pages/applications/financCalculate/resultDetails')) }, 'project')

// 租赁申请
const PrjCreate = resolve => require.ensure([], () => { resolve(require('@/pages/applications/projectManager/prjCreate')) }, 'project')
const PrjMaintenList = resolve => require.ensure([], () => { resolve(require('@/pages/applications/projectManager/PrjMaintenList')) }, 'project')
const InfoMationMain = resolve => require.ensure([], () => { resolve(require('@/pages/applications/projectManager/infoMationMain')) }, 'project')
const PrjBpInfo = resolve => require.ensure([], () => { resolve(require('@/pages/applications/projectManager/prjBpInfo')) }, 'project')
const LeaseCarDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/projectManager/leaseCarDetail')) }, 'project')
const PrjQuotionInfo = resolve => require.ensure([], () => { resolve(require('@/pages/applications/projectManager/prjQuotionInfo')) }, 'project')
const PrjAttachment = resolve => require.ensure([], () => { resolve(require('@/pages/applications/projectManager/prjAttachment')) }, 'project')
{{/project}}

{{#contract}}
// 合同
const ContractMaintenList = resolve => require.ensure([], () => { resolve(require('@/pages/applications/contractMainten/contract-mainten-list')) }, 'contract')
const ContractMainten = resolve => require.ensure([], () => { resolve(require('@/pages/applications/contractMainten/contract-mainten')) }, 'contract')
const ContractSignList = resolve => require.ensure([], () => { resolve(require('@/pages/applications/contractSign/contract-sign-list')) }, 'contract')
const ContractSign = resolve => require.ensure([], () => { resolve(require('@/pages/applications/contractSign/contract-sign')) }, 'contract')
{{/contract}}

{{#riskstrom}}
// 风报
const RiskHome = resolve => require.ensure([], () => { resolve(require('@/pages/applications/riskStorm/riskHome')) }, 'riskstrom')
const RiskSearch = resolve => require.ensure([], () => { resolve(require('@/pages/applications/riskStorm/riskSearch')) }, 'riskstrom')
const RiskSearchDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/riskStorm/riskSearchDetail')) }, 'riskstrom')
const RiskDetailTab = resolve => require.ensure([], () => { resolve(require('@/pages/applications/riskStorm/riskDetailTab')) }, 'riskstrom')
{{/riskstrom}}

{{#esign}}
// E 签宝
const Esign = resolve => require.ensure([], () => { resolve(require('@/pages/applications/esign/Esign')) }, 'esign')
const BankVerified = resolve => require.ensure([], () => { resolve(require('@/pages/applications/esign/BankVerified')) }, 'esign')
const PersonAccount = resolve => require.ensure([], () => { resolve(require('@/pages/applications/esign/PersonAccount')) }, 'esign')
const SignPdf = resolve => require.ensure([], () => { resolve(require('@/pages/applications/esign/SignPdf')) }, 'esign')
const ViewPicture = resolve => require.ensure([], () => { resolve(require('@/pages/applications/esign/ViewPicture')) }, 'esign')
{{/esign}}

{{#report}}
// 报表
const Reports = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/reports')) }, 'report')
const BasicChart = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/basicChart/basicChart')) }, 'report')
const SeniorChart = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/seniorChart/seniorChart')) }, 'report')
const AreaChart = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/basicChart/areaChart/areaChart')) }, 'report')
const BreadChart = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/basicChart/breadChart/breadChart')) }, 'report')
const ColumnChart = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/basicChart/columnChart/columnChart')) }, 'report')
const CombinationChart = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/basicChart/combinationChart/combinationChart')) }, 'report')
const LineChart = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/basicChart/lineChart/lineChart')) }, 'report')
const NoodlesChart = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/basicChart/noodlesChart/noodlesChart')) }, 'report')
const PointChart = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/basicChart/pointChart/pointChart')) }, 'report')
const ArcGridChart = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/seniorChart/arcGridChart/arcGridChart')) }, 'report')
const ClickLine = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/seniorChart/clickLine/clickLine')) }, 'report')
const Guide = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/seniorChart/guide/guide')) }, 'report')
const HeartRate = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/seniorChart/heartRate/heartRate')) }, 'report')
const InteractionLegend = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/seniorChart/interactionLegend/interactionLegend')) }, 'report')
const OtherChart = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/seniorChart/otherChart/otherChart')) }, 'report')
const RadarChart = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/seniorChart/radarChart/radarChart')) }, 'report')
const StatsCard = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/seniorChart/stasCard/stasCard')) }, 'report')
const TitleTooltip = resolve => require.ensure([], () => { resolve(require('@/pages/applications/reports/seniorChart/titleTooltip/titleTooltip')) }, 'report')

{{/report}}


{{#qixin}}
// 启信宝
const QiXinBao = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinBao')) }, 'qixin')
const QiXinSearch = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinSearch')) }, 'qixin')
const QiXinDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/qiXinDetail')) }, 'qixin')
const CompanyDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/companyInformation')) }, 'qixin')
const industrialCommDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/industrialCommDetail')) }, 'qixin')
const changeRecord = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/changeRecord')) }, 'qixin')
const investRelatDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/investRelatDetail')) }, 'qixin')
const annualReports = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/annualReports')) }, 'qixin')
const annualReportsDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/annualReportsDetail')) }, 'qixin')
const courtDecisionDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/courtDecisionDetail')) }, 'qixin')
const executedPersonDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/executedPersonDetail')) }, 'qixin')
const openNoticeDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/openNoticeDetail')) }, 'qixin')
const openNoticeDetailArrow = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/openNoticeDetailArrow')) }, 'qixin')
const courtNoticeDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/courtNoticeDetail')) }, 'qixin')
const courtNoticeDetailArrow = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/courtNoticeDetailArrow')) }, 'qixin')
const loseInformation = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/loseInformation')) }, 'qixin')
const loseInformationDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/loseInformationDetail')) }, 'qixin')
const chattelMortgage = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/chattelMortgage')) }, 'qixin')
const chattelMortgageDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/chattelMortgageDetail')) }, 'qixin')
const taxesInformation = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/taxesInformation')) }, 'qixin')
const judicialSale = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/judicialSale')) }, 'qixin')
const equityPledged = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/equityPledged')) }, 'qixin')
const equityPledgedDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/equityPledgedDetail')) }, 'qixin')
const managementAbnormal = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/managementAbnormal')) }, 'qixin')
const administrativePunish = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/administrativePunish')) }, 'qixin')
const administrativePunishDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/administrativePunishDetail')) }, 'qixin')
const checkInspect = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/checkInspect')) }, 'qixin')
const equityFreeze = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/equityFreeze')) }, 'qixin')
const equityFreezeDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/riskInfo/equityFreezeDetail')) }, 'qixin')

const trademarkInformation = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/knowledgeInfo/trademarkInformation')) }, 'qixin')
const trademarkInformationDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/knowledgeInfo/trademarkInformationDetail')) }, 'qixin')
const patentInformation = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/knowledgeInfo/patentInformation')) }, 'qixin')
const patentInformationDetail = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/knowledgeInfo/patentInformationDetail')) }, 'qixin')
const copyright = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/knowledgeInfo/copyright')) }, 'radio')
const certificationInformation = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/knowledgeInfo/certificationInformation')) }, 'qixin')

const financeInformation = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/businessInfo/financeInformation')) }, 'qixin')
const newsSentiment = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/businessInfo/newsSentiment')) }, 'qixin')
const bid = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/businessInfo/bid')) }, 'radio')
const recruitInformation = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/businessInfo/recruitmentInformation')) }, 'qixin')
const internetInformation = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/businessInfo/internetInformation')) }, 'qixin')
const administrativeLicense = resolve => require.ensure([], () => { resolve(require('@/pages/applications/qiXinBao/qiXinDetail/businessInfo/administrativeLicense')) }, 'qixin')
const administrativeLicenseDetail = resolve => require.ensure([], () => { resolve(require('@/pages//applications/qiXinBao/qiXinDetail/businessInfo/administrativeLicenseDetail')) }, 'qixin')
const growthProcess = resolve => require.ensure([], () => { resolve(require('@/pages//applications/qiXinBao/qiXinDetail/businessInfo/growthProcess')) }, 'qixin')

{{/qixin}}

{{#ocr}}
// ocr
const OcrIdentify = resolve => require.ensure([], () => { resolve(require('@/pages/applications/ocrIdentify/ocrIdentify')) }, 'ocr')
const BusinessCard = resolve => require.ensure([], () => { resolve(require('@/pages/applications/ocrIdentify/businessCard')) }, 'ocr')
const BusinessLicenseInformaton = resolve => require.ensure([], () => { resolve(require('@/pages/applications/ocrIdentify/businessLicenseInformation')) }, 'ocr')
const DriverLicenseInformation = resolve => require.ensure([], () => { resolve(require('@/pages/applications/ocrIdentify/driverLicenseInformation')) }, 'ocr')
const IdCard = resolve => require.ensure([], () => { resolve(require('@/pages/applications/ocrIdentify/idCard')) }, 'ocr')
const VehicleCard = resolve => require.ensure([], () => { resolve(require('@/pages/applications/ocrIdentify/vehicleCard')) }, 'ocr')

  {{/ocr}}

Vue.use(Router)

// 全局跳转路由方法
Router.prototype.pushPage = function (param, bool) {
  let key = true
  if (bool === undefined) {
    key = true
  } else if (bool === true || bool === false) {
    key = bool
  }
  this.currentRoute.meta.nextReload = key
  this.push(param)
}

export default new Router({
  routes: [
    {
      path: '/',
      redirect: to => {
        return { name: 'Home' }
      },
    },
    { path: '/home', component: Home, name: 'Home', meta: { keepAlive: true, nextReload: true} },
    { path: '/ModuleFunction', component: ModuleFunction, name: 'ModuleFunction', meta: { keepAlive: true } },
    // test工具类
    { path: '/hls-popup', component: HlsPopup, name: 'HlsPopup', meta: { keepAlive: false, nextReload: '' } },
    { path: '/EsignPicture', component: EsignPicture, name: 'EsignPicture', meta: {keepAlive: false}},
    {{#wfl}}
    // 工作流
    {
      path: '/WorkflowList',
      component: WorkflowList,
      name: 'WorkflowList',
      meta: { keepAlive: true, nextReload: '' },
    },
    {
      path: '/WorkflowDetail',
      component: WorkflowDetail,
      name: 'WorkflowDetail',
      meta: { keepAlive: false, nextReload: '' },
    },
    {{/wfl}}

    {{#bp}}
    // 商业伙伴
    {
      path: '/PartnerCreate',
      component: PartnerCreate,
      name: 'PartnerCreate',
      meta: { keepAlive: true, nextReload: '' },
    },
    {
      path: '/PartnerList',
      component: PartnerList,
      name: 'PartnerList',
      meta: { keepAlive: false, nextReload: '' },
    },
    {
      path: '/PartnerMainten',
      component: PartnerMainten,
      name: 'PartnerMainten',
      meta: { keepAlive: false, nextReload: '' },
    },
    {
      path: '/PartnerOrgMainten',
      component: PartnerOrgMainten,
      name: 'PartnerOrgMainten',
      meta: { keepAlive: false, nextReload: '' },
    },
    {{/bp}}


    {{#project}}
    // 融资试算
    {path: '/CalculationEnter', component: CalculationEnter, name: 'CalculationEnter', meta: {keepAlive: false}},
    {path: '/calculationMain', component: CalculationMain, name: 'CalculationMain', meta: {keepAlive: false}},
    {path: '/resultMain', component: ResultMain, name: 'ResultMain', meta: {keepAlive: false}},
    {path: '/resultDetails', component: ResultDetails, name: 'ResultDetails', meta: {keepAlive: false}},

    // 租赁申请
    {path: '/PrjCreate', component: PrjCreate, name: 'PrjCreate', meta: {keepAlive: false}},
    {path: '/PrjMaintenList', component: PrjMaintenList, name: 'PrjMaintenList', meta: {keepAlive: false}},
    {path: '/InfoMationMain', component: InfoMationMain, name: 'InfoMationMain', meta: {keepAlive: false}},
    {path: '/PrjBpInfo', component: PrjBpInfo, name: 'PrjBpInfo', meta: {keepAlive: false}},
    {path: '/LeaseCarDetail', component: LeaseCarDetail, name: 'LeaseCarDetail', meta: {keepAlive: false}},
    {path: '/PrjQuotionInfo', component: PrjQuotionInfo, name: 'PrjQuotionInfo', meta: {keepAlive: false}},
    {path: '/PrjAttachment', component: PrjAttachment, name: 'PrjAttachment', meta: {keepAlive: false}},
     {{/project}}

     {{#contract}}
    // 合同维护与签约
    {
      path: '/ContractMaintenList',
      component: ContractMaintenList,
      name: 'ContractMaintenList',
      meta: { keepAlive: false, nextReload: '' },
    },
    {
      path: '/ContractMainten',
      component: ContractMainten,
      name: 'ContractMainten',
      meta: { keepAlive: false, nextReload: '' },
    },
    {
      path: '/ContractSignList',
      component: ContractSignList,
      name: 'ContractSignList',
      meta: { keepAlive: false, nextReload: '' },
    },
    {
      path: '/ContractSign',
      component: ContractSign,
      name: 'ContractSign',
      meta: { keepAlive: false, nextReload: '' },
    },
    {{/contract}}
     {{#esign}}
     {path: '/Esign', component: Esign, name: 'Esign', meta: {keepAlive: false}},
     {path: '/BankVerified', component: BankVerified, name: 'BankVerified', meta: {keepAlive: true}},
     {path: '/PersonAccount', component: PersonAccount, name: 'PersonAccount', meta: {keepAlive: true}},
     {path: '/SignPdf', component: SignPdf, name: 'SignPdf', meta: {keepAlive: true}},
     {path: '/ViewPicture', component: ViewPicture, name: 'ViewPicture', meta: {keepAlive: true}},
     {{/esign}}
     {{#riskstrom}}
    // 风报
    {path: '/RiskHome', component: RiskHome, name: 'RiskHome', meta: {keepAlive: true}},
    {path: '/RiskSearch', component: RiskSearch, name: 'RiskSearch', meta: {keepAlive: false}},
    {path: '/RiskSearchDetail', component: RiskSearchDetail, name: 'RiskSearchDetail', meta: {keepAlive: false}},
    {path: '/RiskDetailTab', component: RiskDetailTab, name: 'RiskDetailTab', meta: {keepAlive: false}},

    {{/riskstrom}}
    {{#report}}
    // 报表
    {path: '/Reports', component: Reports, name: 'Reports', meta: {keepAlive: false}},
    {path: '/BasicChart', component: BasicChart, name: 'BasicChart', meta: {keepAlive: false}},
    {path: '/SeniorChart', component: SeniorChart, name: 'SeniorChart', meta: {keepAlive: false}},
    {path: '/AreaChart', component: AreaChart, name: 'AreaChart', meta: {keepAlive: false}},
    {path: '/BreadChart', component: BreadChart, name: 'BreadChart', meta: {keepAlive: false}},
    {path: '/ColumnChart', component: ColumnChart, name: 'ColumnChart', meta: {keepAlive: false}},
    {path: '/CombinationChart', component: CombinationChart, name: 'CombinationChart', meta: {keepAlive: false}},
    {path: '/LineChart', component: LineChart, name: 'LineChart', meta: {keepAlive: false}},
    {path: '/NoodlesChart', component: NoodlesChart, name: 'NoodlesChart', meta: {keepAlive: false}},
    {path: '/PointChart', component: PointChart, name: 'PointChart', meta: {keepAlive: false}},
    {path: '/ArcGridChart', component: ArcGridChart, name: 'ArcGridChart', meta: {keepAlive: false}},
    {path: '/ClickLine', component: ClickLine, name: 'ClickLine', meta: {keepAlive: false}},
    {path: '/Guide', component: Guide, name: 'Guide', meta: {keepAlive: false}},
    {path: '/HeartRate', component: HeartRate, name: 'HeartRate', meta: {keepAlive: false}},
    {path: '/InteractionLegend', component: InteractionLegend, name: 'InteractionLegend', meta: {keepAlive: false}},
    {path: '/OtherChart', component: OtherChart, name: 'OtherChart', meta: {keepAlive: false}},
    {path: '/RadarChart', component: RadarChart, name: 'RadarChart', meta: {keepAlive: false}},
    {path: '/StasCard', component: StatsCard, name: 'StatsCard', meta: {keepAlive: false}},
    {path: '/TitleTooltip', component: TitleTooltip, name: 'TitleTooltip', meta: {keepAlive: false}},
    {{/report}}

    {{#qixin}}
    // 启信宝
    {path: '/QiXinBao', component: QiXinBao, name: 'QiXinBao', meta: {keepAlive: false}},
    {path: '/qiXinSearsh', component: QiXinSearch, name: 'QiXinSearch', meta: {keepAlive: true}},
    {path: '/qiXinDetail', component: QiXinDetail, name: 'QiXinDetail', meta: {keepAlive: false}},
    {path: '/companyInformation', component: CompanyDetail, name: 'CompanyDetail', meta: {keepAlive: false}},
    {path: '/industrialCommDetail', component: industrialCommDetail, name: 'industrialCommDetail', meta: {keepAlive: false}},
    {path: '/changeRecord', component: changeRecord, name: 'changeRecord', meta: {keepAlive: false}},
    {path: '/investRelatDetail', component: investRelatDetail, name: 'investRelatDetail', meta: {keepAlive: false}},
    {path: '/annualReports', component: annualReports, name: 'annualReports', meta: {keepAlive: false}},
    {path: '/annualReportsDetail', component: annualReportsDetail, name: 'annualReportsDetail', meta: {keepAlive: false}},
    {path: '/courtDecisionDetail', component: courtDecisionDetail, name: 'courtDecisionDetail', meta: {keepAlive: false}},
    {path: '/executedPersonDetail', component: executedPersonDetail, name: 'executedPersonDetail', meta: {keepAlive: false}},
    {path: '/openNoticeDetail', component: openNoticeDetail, name: 'openNoticeDetail', meta: {keepAlive: false}},
    {path: '/openNoticeDetailArrow', component: openNoticeDetailArrow, name: 'openNoticeDetailArrow', meta: {keepAlive: false}},
    {path: '/courtNoticeDetail', component: courtNoticeDetail, name: 'courtNoticeDetail', meta: {keepAlive: false}},
    {path: '/courtNoticeDetailArrow', component: courtNoticeDetailArrow, name: 'courtNoticeDetailArrow', meta: {keepAlive: false}},
    {path: '/loseInformation', component: loseInformation, name: 'loseInformation', meta: {keepAlive: false}},
    {path: '/loseInformationDetail', component: loseInformationDetail, name: 'loseInformationDetail', meta: {keepAlive: false}},
    {path: '/chattelMortgage', component: chattelMortgage, name: 'chattelMortgage', meta: {keepAlive: false}},
    {path: '/chattelMortgageDetail', component: chattelMortgageDetail, name: 'chattelMortgageDetail', meta: {keepAlive: false}},
    {path: '/taxesInformation', component: taxesInformation, name: 'taxesInformation', meta: {keepAlive: false}},
    {path: '/judicialSale', component: judicialSale, name: 'judicialSale', meta: {keepAlive: false}},
    {path: '/equityPledged', component: equityPledged, name: 'equityPledged', meta: {keepAlive: false}},
    {path: '/equityPledgedDetail', component: equityPledgedDetail, name: 'equityPledgedDetail', meta: {keepAlive: false}},
    {path: '/managementAbnormal', component: managementAbnormal, name: 'managementAbnormal', meta: {keepAlive: false}},
    {path: '/administrativePunish', component: administrativePunish, name: 'administrativePunish', meta: {keepAlive: false}},
    {path: '/administrativePunishDetail', component: administrativePunishDetail, name: 'administrativePunishDetail', meta: {keepAlive: false}},
    {path: '/checkInspect', component: checkInspect, name: 'checkInspect', meta: {keepAlive: false}},
    {path: '/equityFreeze', component: equityFreeze, name: 'equityFreeze', meta: {keepAlive: false}},
    {path: '/equityFreezeDetail', component: equityFreezeDetail, name: 'equityFreezeDetail', meta: {keepAlive: false}},
    {path: '/trademarkInformation', component: trademarkInformation, name: 'trademarkInformation', meta: {keepAlive: false}},
    {path: '/trademarkInformationDetail', component: trademarkInformationDetail, name: 'trademarkInformationDetail', meta: {keepAlive: false}},
    {path: '/patentInformation', component: patentInformation, name: 'patentInformation', meta: {keepAlive: false}},
    {path: '/patentInformationDetail', component: patentInformationDetail, name: 'patentInformationDetail', meta: {keepAlive: false}},
    {path: '/copyright', component: copyright, name: 'copyright', meta: {keepAlive: false}},
    {path: '/certificationInformation', component: certificationInformation, name: 'certificationInformation', meta: {keepAlive: false}},
    {path: '/financeInformation', component: financeInformation, name: 'financeInformation', meta: {keepAlive: false}},
    {path: '/newsSentiment', component: newsSentiment, name: 'newsSentiment', meta: {keepAlive: false}},
    {path: '/bid', component: bid, name: 'bid', meta: {keepAlive: false}},
    {path: '/recruitInformation', component: recruitInformation, name: 'recruitInformation', meta: {keepAlive: false}},
    {path: '/internetInformation', component: internetInformation, name: 'internetInformation', meta: {keepAlive: false}},
    {path: '/administrativeLicense', component: administrativeLicense, name: 'administrativeLicense', meta: {keepAlive: false}},
    {path: '/administrativeLicenseDetail', component: administrativeLicenseDetail, name: 'administrativeLicenseDetail', meta: {keepAlive: false}},
    {path: '/growthProcess', component: growthProcess, name: 'growthProcess', meta: {keepAlive: false}},

    {{/qixin}}
    {{#ocr}}
    // ocr
    {path: '/OcrIdentify', component: OcrIdentify, name: 'OcrIdentify', meta: {keepAlive: false}},
    {path: '/businessCard', component: BusinessCard, name: 'BusinessCard', meta: {keepAlive: false}},
    {path: '/businessLicenseInformation', component: BusinessLicenseInformaton, name: 'BusinessLicenseInformaton', meta: {keepAlive: false}},
    {path: '/driverLicenseInformation', component: DriverLicenseInformation, name: 'DriverLicenseInformation', meta: {keepAlive: false}},
    {path: '/idCard', component: IdCard, name: 'IdCard', meta: {keepAlive: false}},
    {path: '/vehicleCard', component: VehicleCard, name: 'VehicleCard', meta: {keepAlive: false}},

    {{/ocr}}
  ],
  scrollBehavior (to, from, savedPosition) {
    if (to.hash) {
      return {
        selector: to.hash,
      }
    }
  },
})
