export default {
  /**
   * 项目基本信息
   */
  carFlag: 0,
  clientInfoFlag: 0,
  offerFlag: 0,
  attachFlag: 0,
  project: {
    project_id: '',
    cdd_list_id: '',
    project_name: '',
    invoice_agent_id: null,
    invoice_agent_id_n: null,
    bp_class: null,
    bp_class_n: null,
    business_type: null,
    business_type_n: null,
    division: null,
    division_n: null,
    car_type: null,
    car_type_n: null,
    user_id: window.localStorage.user_id,
  },
  /**
   * 租赁物信息
   */
  lease: {
    project_id: '',
    business_type: '',
    user_id: window.localStorage.user_id,
    brand_id: null,
    brand_id_n: null,
    series_id: null,
    series_id_n: null,
    model_id: null,
    model_id_n: null,
    guide_price: null,
    objective_buy_car: null,
    objective_buy_car_n: null,
    invoice_price: null,
    lease_charge: 0,
    insurance_price: 0,
    gps_amount: 0,
    travel_tax: 0,
    purchase_tax: 0,
    product_name_write: null,
    down_payment: null,
    finance_amount: null,
    balloon: null,
    deposit: null,
    mouth_rental: null,
    first_amount: null,
    down_payment_ratio: null,
    deposit_ratio: null,
    balloon_ratio: null,
    annual_pay_times_n: null,
    annual_pay_times: null,
    lease_times: null,
    price_list: null,
    product_type: null,
    int_rate_display: null,
    lease_charge_ratio: null,
  },
  /**
   * 项目申请人信息
   */
  prjBp: {
    prj_bp_id: '',
    project_id: '',
    bp_id: '',
    // 客户姓名
    bp_name: null,
    // 手机号
    cell_phone: null,
    // 证件类型
    id_type_n: null,
    id_type: null,
    // 证件号码
    id_card_no: null,
    // 住房情况
    ownship_of_house: null,
    ownship_of_house_n: null,
    // 是否住房贷款
    house_loans_flag: null,
    house_loans_flag_n: null,
    // 户籍地址
    address_on_resident_booklit: null,
    // 居住地址
    living_address: null,
    // 单位名称
    work_unit: null,
    // 单位地址
    work_unit_address: null,
    // 单位电话
    work_unit_phone: null,
    // 职务
    position: null,
    position_n: null,
    user_id: window.localStorage.user_id,
  },

  cashFlows: [],

  prjItemList: null,

  prjUpdataFlag: false,

  getCarFlag () {
    return this.carFlag
  },
  setCarFlag (carFlag) {
    this.carFlag = carFlag
  },

  getClientInfoFlag () {
    return this.clientInfoFlag
  },
  setClientInfoFlag (clientInfoFlag) {
    this.clientInfoFlag = clientInfoFlag
  },
  getOfferFlag () {
    return this.offerFlag
  },
  setOfferFlag (offerFlag) {
    this.offerFlag = offerFlag
  },
  getAttachFlag () {
    return this.attachFlag
  },
  setAttachFlag (attachFlag) {
    this.attachFlag = attachFlag
  },
  /**
   *
   * @returns {project|{project_id, project_name, bp_class, division, car_type, business_type, invoice_agent_id, invoice_agent_name, user_id, create_for, times, finance, lastrental, balloon, pmt, total_amount}}
   */
  getProject () {
    return this.project
  },

  setProject (project) {
    this.project = Object.assign(this.project, project)
  },
  /**
   *
   */
  cleanProject () {
    for (let key in this.project) {
      this.project[key] = ''
    }
  },
  /**
   *
   * @returns {*}
   */
  getPrjbp: function () {
    return this.prjBp
  },
  /**
   *
   * @param prjBp
   */
  setPrjbp: function (prjBp) {
    this.prjBp = Object.assign(this.prjBp, prjBp)
  },
  /**
   *
   */
  cleanPrjBp () {
    for (let key in this.prjBp) {
      this.prjBp[key] = ''
    }
  },
  /**
   *
   * @returns {default.lease|{project_id, user_id, business_type}}
   */
  getLease: function () {
    return this.lease
  },
  /**
   *
   * @param lease
   */
  setLease: function (lease) {
    this.lease = Object.assign(this.lease, lease)
  },
  /**
   *
   */
  cleanLease () {
    for (let key in this.lease) {
      this.lease[key] = ''
    }
  },
  /**
   *
   * @returns {Array}
   */
  getCashflows: function () {
    return this.cashFlows
  },

  /**
   *
   * @param cashFlows
   */
  setCashflows: function (cashFlows) {
    this.cashFlows = cashFlows
  },
  getPrjItemList: function () {
    return this.prjItemList
  },
  setPrjItemList: function (prjItemList) {
    this.prjItemList = prjItemList
  },
  cleanPrjItemList: function () {
    this.prjItemList = ''
  },

  setProjectId: function (projectId) {
    this.project.project_id = projectId
  },
  setCddListId: function (cddListId) {
    this.project.cdd_list_id = cddListId
  },
  getCddListId: function () {
    return this.project.cdd_list_id
  },
  setProjectBpId: function (bpId) {
    this.prjBp.bp_id = bpId
  },
  setProjectBpProId: function (prjBpId) {
    this.prjBp.prj_bp_id = prjBpId
  },
  setProjectLeaseItemId: function (projectLeaseItemId) {
    this.lease.project_lease_item_id = projectLeaseItemId
  },
  getPrjUpdataFlag () {
    return this.prjUpdataFlag
  },
  setPrjUpdataFlag (flag) {
    this.prjUpdataFlag = flag
  },

  /**
   *
   * @param invoic  车价款
   * @param pay_times 还款频率
   * @param lease_times  期限
   * @param int_rato  年利率
   * @param down_payment_ratio  首付比例
   * @param balloon_ratio  尾款比例
   * @param deposit_ratio  保证金比例
   * @param lease_charge  手续费
   * @param insurance_price  保险费
   * @param gps_amount  GPS费
   * @param travel_tax  车船税
   * @param gz  购置税
   * @param pay_type  付款方式
   */
  calcQuotation: function (invoic, payTimes, leaseTimes, intRato, downPaymentRatio, balloonRatio, depositRatio, leaseCharge, insurancePrice, gpsAmount, travelTax,
    gz, payType) {
    invoic = parseFloat(invoic)
    leaseCharge = parseFloat(leaseCharge)
    insurancePrice = parseFloat(insurancePrice)
    gpsAmount = parseFloat(gpsAmount)
    travelTax = parseFloat(travelTax)
    gz = parseFloat(gz)
    if (!leaseCharge) {
      leaseCharge = 0
    } else if (!insurancePrice) {
      insurancePrice = 0
    } else if (!gpsAmount) {
      gpsAmount = 0
    } else if (!travelTax) {
      travelTax = 0
    } else if (!gz) {
      gz = 0
    }
    // 首付金额  融资额  尾付款  保证金 月供 首次支付
    let result = {
      down_payment: 0, finance_amount: 0, balloon: 0, deposit: 0, mouth_rental: 0, first_amount: 0, cash_flows: [],
    }
    let cashFlows = result.cash_flows
    result.lease_charge = leaseCharge
    result.down_payment = hlsUtil.toDecimal((invoic * downPaymentRatio))
    result.finance_amount = hlsUtil.toDecimal((invoic - result.down_payment + leaseCharge + insurancePrice + gpsAmount + travelTax + gz))
    result.balloon = hlsUtil.toDecimal((invoic * balloonRatio))
    result.deposit = hlsUtil.toDecimal(((invoic + leaseCharge + insurancePrice + gpsAmount + travelTax + gz) * depositRatio))
    result.mouth_rental = hlsUtil.toDecimal(hlsUtil.PMT(intRato / payTimes, leaseTimes, -(result.finance_amount), 0, 0))
    // result.mouth_rental = 2113.9;
    result.first_amount = hlsUtil.toDecimal((result.down_payment + result.deposit + leaseCharge + insurancePrice + gpsAmount + travelTax))

    // 剩余本金
    let outstandingPrincipal
    for (var i = 0; i <= leaseTimes; i++) {
      // 每期现金流
      var cashFlow = {
        time: 0,
        due_amount: 0,
        principal: 0,
        interest: 0,
        outstanding_principal: 0,
      }
      // 期数
      cashFlow.time = i
      if (i === 0) {
        outstandingPrincipal = result.finance_amount
        cashFlow.outstanding_principal = outstandingPrincipal
      } else if (i > 0 && i < leaseTimes) {
        // 租金
        cashFlow.due_amount = result.mouth_rental
        // 利息
        cashFlow.interest = hlsUtil.toDecimal(outstandingPrincipal * (intRato / payTimes))
        // 本金
        cashFlow.principal = hlsUtil.toDecimal((cashFlow.due_amount - cashFlow.interest))

        outstandingPrincipal = hlsUtil.toDecimal((outstandingPrincipal - cashFlow.principal))
        cashFlow.outstanding_principal = outstandingPrincipal
      } else {
        cashFlow.due_amount = result.mouth_rental
        cashFlow.principal = outstandingPrincipal
        cashFlow.interest = hlsUtil.toDecimal((cashFlow.due_amount - cashFlow.principal))
      }
      cashFlows.push(cashFlow)
    }
    return result
  },

}
