# hls-car-vue

> A Vue.js project

## Build Setup

``` bash
# install dependencies
npm install

# serve with hot reload at localhost:8080
npm run dev

# build for production with minification
npm run build

# build for production and view the bundle analyzer report
npm run build --report
```

For a detailed explanation on how things work, check out the [guide](http://vuejs-templates.github.io/webpack/) and [docs for vue-loader](http://vuejs.github.io/vue-loader).


### 文件命名规范

1. 文件夹全部采用PascalCase命名法，即每个单词首字母大写

2. 文件名全部采用PascalCase命名法,如 **UserInfo.vue,UserInfoDetail.vue**,

3. 路由的注册 `import` 语句后的单词采用 Pascal命名法，所有单词的首字母大写，其余字母小写，单词与单词之间不使用任何符号风格。如

  ```javascript
  import HomeManager from '@/pages/HomeManager/HomeManager'
  import LoadMore from '@/pages/LoadMore/LoadMore'
  import UserInfo from '@/pages/UserInfo/UserInfo'
  import UserInfoDetail from '@/pages/UserInfo/UserInfoDetail'
  ```

4. 实际路由注册需安照如下写法，`path`为 `/tab/文件名`,`/tab`是否保留按照是否存在tab页的情况而定。`component`后接的单词需和`import`的单词保持一致,`name`后接的单词也需和`import`的单词保持一致

  ```javascript
  {path: "/tab/HomeManager", component: HomeManager, name: 'HomeManager', meta: {keepAlive: true}},
  {path: '/tab/LoadMore', component: LoadMore, name: 'LoadMore', meta: {keepAlive: true}},
  {path: '/tab/UserInfo', component: UserInfo, name: 'UserInfo', meta: {keepAlive: true}},
  ```

