# stylus 指南

## 语法

[stylus 官网](http://stylus-lang.com/)

### 风格

> ⚠️ 因为 stylus 语法过于灵活，缺乏约束，部门将统一采用下列的风格约束。

1.  保留大括号、冒号、分号的语法（类似于 scss）。
2.  变量定义统一 $ 开头。
3.  函数/mixin 调用保留小括号，参数使用逗号隔开。

### 基础指引

```stylus
// 定义变量
$baseColor = #1F8CEB;

// 定义mixin，并给定参数默认值
do-something($color = $baseColor) {
  border: 1px solid $color;
}

// 使用定义的变量和mixin
.example {
  color: $baseColor;
  do-something();
}
```

## 模版已带的样式

### 1px 边框

使用方式一：公共样式类

```html
  <div class="border-top-line"></div>
  <div class="border-bottom-line"></div>
  <div class="border-left-line"></div>
  <div class="border-right-line"></div>
```

使用方式二：mixin 方法

```stylus
// 引入公共变量和公共mixin
@import '../../assets/stylus/import.styl';

// 使用
.example {
  // 单边边框
  border-line(bottom);
  border-line(top);
  border-line(left);
  border-line(right);

  // 改变颜色
  border-line(bottom, #000);

  // 四周边框
  border-radius-line();

  // 改变颜色
  border-radius-line(#000);

  // 加上圆角
  border-radius-line(#000, 20px);
}
```

## 常见问题

> 为什么是 stylus 而不是 sass/scss ?

1.  为了规避 node-sass 因为一些原因可能导致的安装失败和编译时间过长的问题。
2.  stylus 的语法更接近 js，更强大，更友好。

> 特殊情况下，如何规避工程默认的 px 自动转换成 rem？

在该行样式的后面加上 `/*no*/` ，则该行的 `px` 单位不会被转换为 `rem`。
```stylus
border: 1px solid #000; /*no*/
```
