# route 对象添加指南

* [vue-router 官方文档](https://router.vuejs.org/zh-cn/)

router 的所有配置存放在 router 目录下面，router 的配置按模块分块如果需要添加一个模块的 router 配置，只需要执行以下步骤：

1.  在 `router/modules` 目录下添加一个 js 文件，文件名以 camel 形式命名
2.  在添加的 js 文件中添加对应模块的 route 配置，形如：

    ```js
    import Home from '@/views/Home'

    const routes = [
      {
        path: '/Home',
        name: 'Home',
        component: Home,
      },
    ]

    export default routes
    ```

3.  将新添加的配置文件在 `router/routes.js` 文件中引入，形如：

    ```js
    import home from './modules/home'

    export default [
      ...home,
      {
        path: '*',
        redirect: '/home',
      },
    ]
    ```
