# i18n 极简使用指南

* [vue-i18n - github](https://github.com/kazupon/vue-i18n)
* [vuex-i18n - github](https://github.com/dkfbasel/vuex-i18n)

*i18n 配置文件在 i18n 目录中*

vue 有两个支持 i18n 的插件，vuex-i18n 使用起来舒服一些，但需要依赖 vuex，所以如果使用 cli 生成项目时，选择使用 vuex，项目中会默认配置 vuex-i18n 作为多语言插件，否则使用 vue-i18n，以下是两个插件最基本的用法，更加详细用法请自行查阅文档

**vue-i18n**

```js
// 以下三种用法都可以，但作为对象名时不能添加空格
// 如下：'project name'可以，'message key.projectName'不行
{{ $t('projectName') }}
{{ $t('message.projectName') }}
{{ $t('message-key.projectName') }}

// 切换语言
this.$i18n.locale = 'en'; // 默认是中文，zh
```

**vuex-i18n**

```js
// 以下四种用法都可以
// 数据存在store中，所有的对象子属性都会被转成store.state中的字符串键来存储，用.连接
{{ $t('projectName') }}
{{ $t('message.projectName') }}
{{ $t('message-key.projectName') }}
{{ $t('message key.projectName') }}

// 切换语言
this.$i18n.set('en'); // 默认是中文，zh
```

## 项目后期追加 i18n 配置

如果早期项目没考虑要做国际化，因此项目创建时没加入 i18n 配置，而后期需要追加国际化，此时需要做如下几步：

1.  使用初始化项目命令重新创建一个和当前项目配置相同的空项目，并选择使用 i18n
2.  将新创建项目的 src/i18n 目录拷贝到当前项目的 src 目录下
3.  将新创建项目中 src/main.js 文件中和 i18n 相关的内容，拷贝到当前项目的 src/main.js 文件中
4.  根据项目的需求安装对应的 i18n 插件，vue-i18n 或 vuex-i18n
