# 子应用开发指南

## 开发流程

1.  在入口文件 src/main.js 中引入 hmap 环境(若项目生成的时候选择了 HMAP ，则该步骤已默认引入）

```js
// src/main.js
import '@/platform/hmap/env'
```

⚠️ 默认为 在线子应用 的环境。若为 本地子应用，可修改 `src/platform/hmap/env.js` 注释掉在线子应用部分，打开离线子应用的注释，同时删除 `static/` 下的 `cordova` 文件夹。

2.  在你需要的时机使用 hmap 登录

```js
// 在 app.vue 中
import hmapLogin from '@/platform/hmap/login'

export default {
  /* ... */
  async mounted() {
    // Tips：hmapLogin 会自动判断环境以采用相应的登录方式，所以构建的包需放在相应的环境才能正确登录
    // yarn dev 为模拟登录。yarn build:alpha 测试版海马汇环境。yarn build 正式版海马汇环境。
    /**
     * hmapLogin 登录总成
     * @param  {String}  [type] 应用类型：可选:'online''local'  默认:'online'
     * @param  {Boolean} [needInfo] 是否需要获取用户详细信息  默认: true
     * @return {Object.Promise} 返回一个promise。若登录成功PromiseValue为数据对象/登录失败PromiseValue 为 false
     */
    const res = await hmapLogin()

    // 使用promise写法：
    hmapLogin().then(res => {})
  },
  /* ... */
}
```

## 参考资料

[海马汇项目实施文档](http://eco.hand-china.com/doc/hmap-cloud/latest/part5/chapter1.html)
