# 子应用部署指南

## 打包

```bash
# 测试版海马汇（测试环境）打包，输出到 /dist
yarn build:alpha

# 正式版海马汇（正式环境）打包，输出到 /dist
yarn build
```

⚠️ 不同的包与环境不能弄错，否则会造成无法登录等后果。

## 部署

### 测试环境

#### 第一步：找到相应负责人 黄昊(8467) 申请[测试环境中台](http://wechat.hand-china.com/hippius-admin)登录权限。

测试环境中台地址：`http://wechat.hand-china.com/hippius-admin`

#### 第二步：下载测试版海马汇

中台找到 应用管理 -> 应用版本管理，点击进入相应的平台。

![步骤1](img/download-1.png)

找到版本设置下的最新版本的 下载地址，复制该地址，在手机上打开下载安装。

![步骤2](img/download-2.png)

#### 第三步：中台找到 应用管理 -> 子应用管理。根据需求新建应用或编辑现有应用。

新建子应用流程：

1.  新建应用

![步骤1](img/hmap-1.png)

2.  选择`应用类型`，如果是全屏应用，需选择 `隐藏导航`

![步骤2](img/hmap-2.png)

3.  点进去你刚刚新建的应用，找到版本新建

![步骤3](img/hmap-3.png)

4.  新建版本

**在线子应用**需将打包后的 dist 文件夹重命名成子应用的名称，如 `testName` ，然后发给相应负责人上传到测试环境服务器（建议使用图形化工具操作，如 `Transmit`、`FileZilla`）。

代码资源为 `http://wechat.hand-china.com/hmapshowcase/oauth/authorize?&client_id=a765ff3f-8d33-49b4-a9c9-48e991544242&response_type=code&redirect_uri=http://wechat.hand-china.com/testName/index.html`

需将代码资源路径最后的 `testName` 改为你上面重命名的名称。（根据上传路径的不同，代码资源最后的 `redirect_uri` 也需相应变化）

⚠️ _一般情况下代码资源的前面部分都是固定的，只有最后的 `redirect_uri` 需要更改。如果在外交付的产品 `client_id` 有变化，则 `client_id` 也需要更改，具体参考[后端文档](https://hmap.hand-china.com/hippius-api/10013.html)_

![步骤4](img/hmap-4.png)

**离线子应用**先将 dist 文件夹压缩成 zip 包并点击 `上传包`。
资源目录为 `dist/index.html`。

若包文件夹名称非 `dist`，则资源目录路径也需要更改成相同名称。

⚠️ _压缩 zip 包时尽量使用操作系统自带的压缩工具，曾经有 windows 上用第三方工具压缩后打开白屏的案例。_

![步骤5](img/hmap-5.png)

5.  海马汇应用 tab 页下拉刷新，应用版本即会更新。（特殊情况可能需要杀掉进程重启海马汇或退出登录重新进入）

### 正式环境

跟测试环境部署流程相同，url 地址变更为正式环境地址。需发给有相应权限的负责人操作。

## 调试

### 方式一：vconsole 调试

通过 `yarn build:alpha` 打出的包，vconsole 会自动引入。

![调试方式1](img/hmap-test-1.png)

### 方式二：真机调试（必须是有打开调试模式的测试安装包）

**安卓**通过数据线连上电脑，chrome 中地址栏输入 `chrome://inspect/` 找到页面调试。

**iOS**需要原生帮助在你的 xcode 上跑测试版海马汇，然后打开 safari（需勾选 偏好设置 -> 高级 -> 在菜单栏中显示开发菜单），找到开发菜单中的页面调试。

![调试方式2](img/hmap-test-2.png)

### 方式三：vorlon 远程调试

[vorlon 官网](http://www.vorlonjs.com/)
