# 汉得内部子应用维护

## vue 子应用（2017-2018 初）

### 开始

[git 仓库地址](https://code.choerodon.com.cn/mobile-center-hmap/vue.git)：`https://code.choerodon.com.cn/mobile-center-hmap/vue.git`

找到相应负责人申请该仓库的开发者权限。

切换到 `develop` 分支。

### 构建命令

```bash
# 开发环境运行，使用 src/config/config.json 配置
yarn dev

# 测试环境包，使用 src/config/config-test.json 配置。输出到 /dist
yarn build # 部分子应用可能为 yarn build-test ，具体需查看 package.json

# 生产环境包，使用 src/config/config-prod.json 配置。输出到 /prod
yarn build-prod
```

### 目录结构

⚠️ 主目录下每一个文件夹都是一个单独的子应用。

* common （前期部分子应用可能依赖于该文件夹）
* emp-statement （发了吗：嘉航）
* group-active （群活动）
* group-bannerMessage （banner消息：凯华）
* group-corpMessage （企业频道消息：凯华）
* group-notice （群通知）
* group-questionnaire （群问卷：嘉航）
* group-vote （群投票）
* my-footprint （我的足迹）
* my-footprint-h5 （我的足迹分享页）
* vue-bus （班车信息：凯华）
* vue-contract-manage （CRM合同管理）
* vue-house （房屋转租）
* vue-house-share （房屋转租分享页）
* vue-suggest （我要吐槽）

### 常见问题

⚠️ 需要注意有些子应用为离线子应用。判断应用类型可以查看 后台管理页面 -> 子应用管理 -> 应用详情。

> 地图开发指南

[百度地图示例](http://lbsyun.baidu.com/jsdemo.htm)

[百度地图 API](http://lbsyun.baidu.com/cms/jsapi/reference/jsapi_reference.html)

> my-footprint（我的足迹）在开发环境中无法定位成功？

开发环境为 IP 定位，可能需要科学上网。测试/生产环境使用的是 GPS 定位，不存在此问题。

> my-footprint（我的足迹）与 my-footprint-h5（我的足迹活动页）如何通信？

my-footprint-h5 是一个单独部署的页面，通过 iframe 的方式嵌入 my-footprint 中。其中使用 postMessage 进行通信。

当 my-footprint-h5 被分享出去时，实际上是在页面链接后拼接上一个 `userId`，通过获取该字段，拿到用户的相关信息。

## ionic 子应用（2017 年前）

### 开始

[git 仓库地址](https://rdc.hand-china.com/gitlab/hmap-cloud-develop/hmap-subApp.git): `https://rdc.hand-china.com/gitlab/hmap-cloud-develop/hmap-subApp.git`

找到相应负责人申请该仓库的开发者权限。

因为历史遗留原因，所有 ionic 应用都在一个工程中，通过手动更改 app.js、gulpfile.js 等文件以达到打出不同子应用的包的目的。

**打不同包时需要修改的文件有：**

1.  app/app.js
2.  app/theme/app.core.scss
3.  gulpfile.js（可能需要）

因为该方式过于鬼畜，所以后续的部分子应用已单独到一个 git 分支中，这样直接切换分支就行。建议后续维护的过程中，将子应用都划分到不同 git 分支。

因为历史遗留原因，**ionic 子应用无法在开发环境直接运行**，需打包到手机上才能看到效果。当然你也可以自由发挥，通过其它操作运行在开发环境。

### 构建命令

```bash
# 打包
# 不同的子应用打包命令不同，具体请查看 gulpfile.js 最底部。运行指定的 gulp task 即可
```
