# git 校验说明

**注意：git 的校验是通过 husky 插件来实现的，husky 插件现在有一个 bug，需要在 git init 之后再安装 husky 才能起效，所以如果你 commit 的时候发现 husky 没工作，需要重新安装下 husky：`yarn upgrade husky` 或 `yarn add husky@next --dev`**

## eslint

该项目默认启用 eslint 进行 js 代码语法检查，检查不通过时将出现以下现象：

- 开发环境代码运行报错
- git commit 无法提交成功

当你执行 git commit 时，会在代码提交之前先执行 eslint 校验暂存区中的 js 或 vue 文件，如果 eslint 语法检查不通过，将会阻止本次提交。

如果想定制 eslint 校验规则，修改 .eslintrc.js 文件，在其中的 rules 对象中添加想用的规则。

如果你的项目不想使用 eslint，将 `config/index.js` 文件中的 `dev.useEslint` 设置为 false 即可 (推荐启用 eslint)

## commit message

同 eslint 校验，提交信息也需要校验通过才能提交成功，即 `git commit -m 'xxx'` 中 xxx 必须符合提交规范。

我们采用当下流行最广的 angular 团队的规范，结构为：`<type>(<scope>): <subject>`，具体规范要求查看下面链接

- [Commit message 和 Change log 编写指南](http://www.ruanyifeng.com/blog/2016/01/commit_message_change_log.html)

### 使所有项目成为 Commitizen-friendly

通常我们使用 git commit 来提交代码，如果你想使用 git cz 来代替 git commit，使提交代码时出现提交选项，可以做如下配置：

[Commitizen cz-cli - Github](https://github.com/commitizen/cz-cli)

- 全局安装 commitizen：`npm install -g commitizen`
  - commitizen 提供了 git cz 命令来替代 git commit，此时 git cz 等价于 git commit
- 全局安装 commitizen 适配器：`npm install -g cz-conventional-changelog`
  - 该适配器用来修改 git cz 的行为，使用这个之后 git cz 的行为和 git commit 不一样了，执行 git cz 时会出现 commit message 选项，且错误提示信息也发生改变
- 执行 CLI 在主目录中添加.czrc 配置文件：`echo '{ "path": "cz-conventional-changelog" }' > ~/.czrc`
  - 这个配置文件用来指定 commitizen 适配器路径，否则 cz-conventional-changelog 无法生效

此时在我们的任意 git 项目中都已经可以使用 commitizen 了，使用 git cz 来替代 git commit 即可，git commit 中的所有可选参数都包含在 git cz 中。
