# eslint 指南

## 风格指南

🔥 [vue 风格指南](https://cn.vuejs.org/v2/style-guide/) <br>
[eslint-standard 风格指南](https://github.com/standard/standard/blob/master/docs/README-zhcn.md)

## 配置 eslint fix

### 使用 VSCode（推荐）：

1.  安装 eslint 插件：ESLint
2.  左下角设置 -> 设置 -> 用户设置中添加如下配置

```json
"eslint.autoFixOnSave": true,
"eslint.validate": [
  { "language": "javascript", "autoFix": true },
  { "language": "javascriptreact", "autoFix": true },
  { "language": "html", "autoFix": true },
  { "language": "vue", "autoFix": true }
],
```

3.  效果：编辑文件保存时会自动 fix 代码格式。

### 使用 Atom：

1.  找到 settings -> install 安装 package： 'linter-eslint'
2.  找到 settings -> package -> linter-eslint:settings 勾选 'fix errors on save' 和 'Lint HTML Files'
3.  效果：保存文件的时候会自动 fix 当前文件的代码格式

### 使用 WebStorm：（待补充）

### 使用命令行：

1.  cmd/powershell/终端 进入工程目录，运行 node_modules/.bin/eslint --fix <path/fileName>

### 使用 webpack 配置(可能会有副作用)

1.  /build/webpack.base.conf.js 中 找到 createLintingRule 中 option 中将 fix 改为 true

```js
const createLintingRule = () => ({
  ...,
  options: {
    ...,
    fix: true, // default: false. might cause webpack to enter an infinite build loop if some issues cannot be fixed properly.
  },
});
```

2.  效果：webpack 编译的时候会 fix 所有文件的代码格式

## 常见问题

> 引入的全局变量提示未定义？在 ./eslintrc.js 中 ‘globals’ 中添加你的全局变量：

```js
  "globals": {
    navigator: false, // false 为只读（不能被复写），true 为该变量可被重写
  }
```

> 如何在文件或行中部分禁用 eslint？

在.js 中：

```js
// eslint-disable-line       // 当前行禁用
// eslint-disable-next-line  // 下一行禁用
/* eslint-disable */ // 该行以下全部禁用
/* eslint-enable */ // 该行以下全部启用
```

在.vue template 中：

```html
<!-- eslint-disable-line -->
<!-- eslint-disable-next-line -->
<!-- eslint-disable -->
<!-- eslint-enable -->
```
