# 新环境数据配置指南

项目中用到的环境数据配置存放在 `data/config` 目录下，不同环境数据单独存放在一个文件中

如果要添加一个新的环境，如 UAT 环境，需要做两步操作：

* 在 package.json 文件中的 scripts 字段中添加一行脚本，推荐在打包脚本前添加 `build:` 前缀，以 UAT 环境为例，参考 dev 和 build，只需要修改 CONFIG_ENV 为对应环境即可
  * UAT 开发：`"uat": "cross-env CONFIG_ENV=uat webpack-dev-server --inline --progress --config build/webpack.dev.conf.js",`
  * UAT 打包：`"build:uat": "cross-env CONFIG_ENV=uat node build/build.js",`
* 在 `src/data/config` 目录中添加一个环境数据配置文件 `*.env.js`(\* = CONFIG_ENV，如：uat.env.js)

**注意：CONFIG_ENV 是用来指定当前脚本执行时使用哪个环境的配置数据的，所以其值必须要和自己新建的环境数据配置文件名 `uat.env.js` 中的 uat 匹配，否则将会找不到对应环境的配置数据**

_除非需要修改 webpack 配置，否则不需要添加对应环境的 webpack 配置文件_
