# hippius-vue-init

## 项目初始化
```bash
# 注意将vue cli更新到最新版本，低版本可能报错
# <project_name> 替换成 项目名称
vue init https://rdc.hand-china.com/gitlab:hmap-cloud-develop/hippius-vue-init <project_name> -c
```

### 构建命令
```bash
# install dependencies
yarn

# 安装 chromedriver 可能会报错，源镜像被墙了，换成淘宝镜像
# yarn config set chromedriver_cdnurl https://npm.taobao.org/mirrors/chromedriver

# 开发环境：使用 src/data/dev.env.js 配置，with hot reload
yarn start | yarn run dev

# 构建测试环境包：使用 src/data/alpha.env.js 配置，会自动引入vConsole调试工具。输出到 /dist
yarn run build:alpha

# 构建生产环境包：使用 src/data/prod.env.js 配置。输出到 /dist
yarn run build

# build for production and view the bundle analyzer report
yarn run build --report

# run unit tests：使用 src/data/test.env.js 配置
yarn run unit

# run e2e tests
yarn run e2e

# run all tests
yarn test
```

## 目录结构

* api 目录 (存放与接口调用相关资源)
* assets 目录 (存放项目需要引用的资源)
  * fonts 目录 (字体资源)
  * images 目录 (图片资源)
  * stylus 目录 (全局通用的 stylus 样式资源)
* components 目录 (存放项目中的 vue 组件)
* data 目录 (存放项目中需要用到的配置数据)
* i18n 目录 (存放国际化处理的数据文件)
* libs 目录 (存放一些无法通过 npm 安装的第三方库)
* router 目录 (存放 vue-router 相关配置)
  * routes.js 文件 (存放 vue-router 的所有 route 配置)
* store 目录 (存放 vuex.store 相关配置)
  * modules 目录 (按模块分隔 store 配置，如果是所有模块的通用配置可以直接写在 store/index.js 文件中)
* utils 目录 (存放全局共享的工具函数)
  * http 目录 (存放对 axios 的一些加工处理)
  * directives.js 文件 (存放全局的 vue directive)
  * filters.js 文件 (存放全局的 vue filter)
* views 目录 (存放项目的所有页面展示组件)
* App.vue 文件 (主组件文件)
* main.js 文件 (入口文件)

## 全局对象

* $config (包含项目的通用配置数据，数据配置文件为 src/data/config/\*.env.js)

## 常见问题

### Failed to download ... 'git clone' failed with status 128

查看下vue-cli的版本是不是太低了：`vue --version`
推荐使用vue-cli 2.9.x 或 3.x.x

  - 安装2.9.x：`npm install -g vue-cli` 或 `yarn global add vue-cli`
  - 安装3.x.x：`npm install -g @vue/cli` 或 `yarn global add @vue/cli`

注意：vue-cli版本过低时可能会有个提示安装：`yarn global add @vue/cli-init`，这个命令貌似是有问题的，不要加上`-init`。

### 长时间处于 download template 状态

估计是网络问题，切换下网络试试。

### babel-polyfill

babel-polyfill 在 webpack 构建过程中已注入，无需在 main.js 中重复引入！

### 项目中使用vux注意事项

安装完vux、vux-loader、less-loader之后
修改webpack.base.conf.js文件

```js
const vuxLoader = require('vux-loader')

// 将原来moudle.exports出来的对象用const webpackConfig接收
// 然后添加以下代码

module.exports = vuxLoader.merge(webpackConfig, {
  plugins: [
    {
      name: 'vux-ui',
    },
  ],
})
```
