export default {
  companyName: '',
  organizationCode: '',
  tabList: [
    {
      name: '工商资料',
    },
    {
      name: '股东成员',
    },
    {
      name: '对外投资',
    },
    {
      name: '工商变更',
    },
    {
      name: '企业年报',
    },
    {
      name: '关联情报',
    }, {
      name: '开庭公告',
    },
    {
      name: '裁判文书',
    },
    {
      name: '执行记录',
    }, {
      name: '失信记录',
    }, {
      name: '涉诉公告',
    }, {
      name: '司法协助',
    }, {
      name: '动产融资',
    }, {
      name: '股权出质',
    },
    {
      name: '行政处罚',
    },
    {
      name: '信息披露',
    }, {
      name: '经营异常',
    }, {
      name: '担保',
    }, {
      name: '欠税记录',
    },
    {
      name: '税务异常',
    },
    {
      name: '招投标',
    }, {
      name: '土地信息',
    }, {
      name: '专利',
    }, {
      name: '著作权',
    }, {
      name: 'ICP备案',
    },

  ],

  // 正式数据
  riskInfo: {},
  // 测试数据整合
  testInfo: {
    'businessInfor': {
      '经营范围': '研究、开发和生产计算机软件、信息系统和网络产品，从事信息系统和数据管理系统的安装以及信息系统的集成，提供技术开发、咨询服务以及与该服务相关的客户支援服务，提供整体企业信息系统解决方案，销售公司自产产品，从事货物及技术的进出口业务，代理记账。 【依法须经批准的项目，经相关部门批准后方可开展经营活动】',
      '名称': '上海汉得信息技术股份有限公司',
      '注册资本': '82359.8634万人民币',
      '派出企业名称': '',
      '省市': '上海',
      '法定代表人': '陈迪清',
      '注册号': '310000400308460',
      '曾用名': [
        '上海汉得信息技术有限公司',
        '上海全富汉得软件技术有限公司',
      ],
      '经营期限至': '',
      '登记状态': '存续(在营、开业、在册)',
      '核准日期': '2002年7月15日',
      '成立日期': '2002年7月15日',
      '地址': '上海市青浦工业园区外青松公路5500号303室',
      '登记机关': '上海市工商局',
      '统一社会信用代码': '9131000074027295XF',
      '经营期限自': '2002年7月15日',
      '类型': '股份有限公司（上市、外商投资企业投资）',
    },
    'companyNumber': {
      'hits': [
        {
          'internal': {
            'pid': '',
          },
          '序号': '1',
          '成员': '刘维',
          '职务': '董事',
        },
        {
          'internal': {
            'pid': '',
          },
          '序号': '2',
          '成员': '陈迪清',
          '职务': '董事长',
        },
        {
          'internal': {
            'pid': '',
          },
          '序号': '3',
          '成员': '刘静波',
          '职务': '监事',
        },
        {
          'internal': {
            'pid': '',
          },
          '序号': '4',
          '成员': '曹惠民',
          '职务': '董事',
        },
        {
          'internal': {
            'pid': '',
          },
          '序号': '5',
          '成员': '黄青',
          '职务': '监事',
        },
        {
          'internal': {
            'pid': '',
          },
          '序号': '6',
          '成员': '范建震',
          '职务': '董事',
        },
        {
          'internal': {
            'pid': '',
          },
          '序号': '7',
          '成员': '吴滨',
          '职务': '其他人员',
        },
        {
          'internal': {
            'pid': '',
          },
          '序号': '8',
          '成员': '黄益全',
          '职务': '总经理',
        },
        {
          'internal': {
            'pid': '',
          },
          '序号': '9',
          '成员': '陈靖丰',
          '职务': '董事',
        },
      ],
      'total': 9,
    },
    'investorInfor': {
      'hits': [
        {
          'internal': {
            'pid': '',
          },
          '实缴明细': [],
          '股东': '上海得逸投资管理有限公司',
          '股东类型': '企业法人',
          '认缴明细': [],
          '责任形式': '',
        },
        {
          'internal': {
            'pid': '',
          },
          '实缴明细': [],
          '股东': 'The China Fund,Inc',
          '股东类型': '外国(地区)企业',
          '认缴明细': [],
          '责任形式': '',
        },
        {
          'internal': {
            'pid': '',
          },
          '实缴明细': [],
          '股东': '上海得竞投资管理有限公司',
          '股东类型': '企业法人',
          '认缴明细': [],
          '责任形式': '',
        },
        {
          'internal': {
            'pid': '',
          },
          '实缴明细': [],
          '股东': 'InspireEastInvestmentsLimited',
          '股东类型': '外国(地区)企业',
          '认缴明细': [],
          '责任形式': '',
        },
        {
          'internal': {
            'pid': '',
          },
          '实缴明细': [],
          '股东': '上海得拓投资管理有限公司',
          '股东类型': '企业法人',
          '认缴明细': [],
          '责任形式': '',
        },
        {
          'internal': {
            'pid': '',
          },
          '实缴明细': [],
          '股东': '上海迪宣投资管理有限公司',
          '股东类型': '企业法人',
          '认缴明细': [],
          '责任形式': '',
        },
        {
          'internal': {
            'pid': '',
          },
          '实缴明细': [],
          '股东': '上海得帆投资管理有限公司',
          '股东类型': '企业法人',
          '认缴明细': [],
          '责任形式': '',
        },
      ],
      'total': 7,
    },
    'gsbgInfor': {
      'hits': [
        {
          '_id': '58acf38a2412351244a6c9b1',
          'part_hash': '0db0239d18ad451eb90277080daab6f2',
          '变更事项': '董事备案',
          '变更前': '曹惠民;陈迪清;范建震;刘维;陈靖丰',
          '变更后': '陈靖丰;范建震;陈迪清;曹惠民;刘维',
          '变更日期': '2016-11-22',
        },
        {
          '_id': '58acf3892412351244a6c9af',
          'part_hash': '0db0239d18ad451eb90277080daab6f2',
          '变更事项': '法定代表人变更',
          '变更前': '范建震',
          '变更后': '陈迪清',
          '变更日期': '2016-11-22',
        },
        {
          '_id': '58acf3892412351244a6c9ae',
          'part_hash': '0db0239d18ad451eb90277080daab6f2',
          '变更事项': '经理备案',
          '变更前': '陈迪清',
          '变更后': '黄益全',
          '变更日期': '2016-11-22',
        },
        {
          '_id': '57182c47ffccecdb3f4506ba',
          'part_hash': 'ec3d14d3f5bfb16156e5a76c6bb46bd1',
          '变更事项': '章程备案',
          '变更前': '2015-04-23章程备案',
          '变更后': '2015-05-05章程备案',
          '变更日期': '2016-04-12',
        },
        {
          '_id': '57182c46ffccecdb3f4506b9',
          'part_hash': 'ec3d14d3f5bfb16156e5a76c6bb46bd1',
          '变更事项': '注册资本(金)变更',
          '变更前': '54906.575600万人民币',
          '变更后': '82359.8634万人民币',
          '变更日期': '2016-04-12',
        },
        {
          '_id': '570ef137ffccecdb3f442ed8',
          'part_hash': 'f6b883f9cd029b641d662ac1966ded9b',
          '变更事项': '注册资本(金)变更',
          '变更前': '53636.975600万人民币',
          '变更后': '54906.575600万人民币',
          '变更日期': '2015-05-04',
        },
        {
          '_id': '570ef137ffccecdb3f442ed7',
          'part_hash': 'f6b883f9cd029b641d662ac1966ded9b',
          '变更事项': '章程备案',
          '变更前': '2014-10-30章程备案',
          '变更后': '2015-04-23章程备案',
          '变更日期': '2015-05-04',
        },
        {
          '_id': '58acf38b2412351244a6c9dd',
          'part_hash': 'ae4b1028138f5728f538969613292baf',
          '变更事项': '经营范围变更',
          '变更前': '研究、开发和生产计算机软件、信息系统和网络产品，从事信息系统和数据管理系统的安装以及信息系统的集成，提供技术开发、咨询服务以及与该服务相关的客户支援服务，提供整体企业信息系统解决方案，销售公司自产产品，从事货物及技术的进出口业务。【依法须经批准的项目，经相关部门批准后方可开展经营活动】',
          '变更后': '研究、开发和生产计算机软件、信息系统和网络产品，从事信息系统和数据管理系统的安装以及信息系统的集成，提供技术开发、咨询服务以及与该服务相关的客户支援服务，提供整体企业信息系统解决方案，销售公司自产产品，从事货物及技术的进出口业务，代理记账。【依法须经批准的项目，经相关部门批准后方可开展经营活动】',
          '变更日期': '2015-04-21',
        },
        {
          '_id': '570ef138ffccecdb3f442edb',
          'part_hash': 'ae4b1028138f5728f538969613292baf',
          '变更事项': '注册资本(金)变更',
          '变更前': '27019.811100万人民币',
          '变更后': '53636.975600万人民币',
          '变更日期': '2015-04-21',
        },
        {
          '_id': '570ef137ffccecdb3f442eda',
          'part_hash': 'ae4b1028138f5728f538969613292baf',
          '变更事项': '一般经营项目变更',
          '变更前': '研究、开发和生产计算机软件、信息系统和网络产品，从事信息系统和数据管理系统的安装以及信息系统的集成，提供技术开发、咨询服务以及与该服务相关的客户支援服务，提供整体企业信息系统解决方案，销售公司自产产品，从事货物及技术的进出口业务',
          '变更后': '研究、开发和生产计算机软件、信息系统和网络产品，从事信息系统和数据管理系统的安装以及信息系统的集成，提供技术开发、咨询服务以及与该服务相关的客户支援服务，提供整体企业信息系统解决方案，销售公司自产产品，从事货物及技术的进出口业务，代理记账',
          '变更日期': '2015-04-21',
        },
      ],
      'total': 77,
    },
    'dcdyInfor': {
      'hits': [],
      'total': 0,
    },
    'gqczInfor': {
      'hits': [
        {
          '_id': '589dd031d578b7d62b5fac7f',
          'part_hash': 'c8be003b4d8d0ff3daf6c790fac78c96',
          '出质人': 'BEYOND PRECISION HOLDINGS LIMITED',
          '出质标的': '上海达美信息技术有限公司',
          '出质股权数额': '550.0万元',
          '备注': '',
          '注销原因': '质权人放弃质权',
          '注销日期': '2015年12月2日',
          '状态': '无效',
          '登记日期': '2015-06-05',
          '登记编号': '4120150058',
          '质权人': '上海汉得信息技术股份有限公司',
        },
        {
          '_id': '589dd032d578b7d62b5fac80',
          'part_hash': 'c8be003b4d8d0ff3daf6c790fac78c96',
          '出质人': '扬州达美投资管理有限公司',
          '出质标的': '上海达美信息技术有限公司',
          '出质股权数额': '450.0万元',
          '备注': '',
          '注销原因': '质权人放弃质权',
          '注销日期': '2015年12月2日',
          '状态': '无效',
          '登记日期': '2015-06-05',
          '登记编号': '4120150059',
          '质权人': '上海汉得信息技术股份有限公司',
        },
      ],
      'total': 2,
    },
    'nianbaoInfor': {
      'hits': [
        {
          '_id': '570ef142ffccecdb3f442ee6',
          'display_flags': {},
          '修改记录': [],
          '分支机构登记信息': [],
          '发布日期': '2017-07-06',
          '基本信息': {
            '从业人数': '企业选择不公示',
            '企业名称': '上海汉得信息技术股份有限公司',
            '企业电子邮箱': 'investors@vip.hand-china.com',
            '企业经营状态': '开业',
            '企业联系电话': '021-67002300',
            '企业通信地址': '上海市青浦区汇联路33号',
            '是否有对外提供担保信息': '',
            '是否有投资信息或购买其他公司股权': '否',
            '是否有网站或网店': '是',
            '有限责任公司本年度是否发生股东股权转让': '否',
            '统一社会信用代码/注册号': '310000400308460',
            '邮政编码': '201707',
          },
          '对外投资信息': [],
          '对外提供保证担保': [],
          '成员信息': [],
          '报送年度': '2014',
          '注册号': '9131000074027295XF',
          '章程信息': {},
          '经营范围': {},
          '网站信息': [
            {
              '名称': '上海汉得信息技术股份有限公司',
              '类型': '网站',
              '网址': 'www.hand-china.com',
            },
          ],
          '股东及出资信息': [
            {
              '实缴出资方式': '股权',
              '实缴出资时间': '2014年12月31日',
              '实缴出资额(万元)': '695.08109',
              '序号': '1',
              '股东': '范建震',
              '认缴出资方式': '股权',
              '认缴出资时间': '2014年12月31日',
              '认缴出资额(万元)': '6950.8109',
            },
            {
              '实缴出资方式': '股权',
              '实缴出资时间': '2014年12月31日',
              '实缴出资额(万元)': '6950.6244',
              '序号': '2',
              '股东': '陈迪清',
              '认缴出资方式': '股权',
              '认缴出资时间': '2014年12月31日',
              '认缴出资额(万元)': '6950.6244',
            },
            {
              '实缴出资方式': '股权',
              '实缴出资时间': '2014年12月31日',
              '实缴出资额(万元)': '26617.1661',
              '序号': '3',
              '股东': '社会公众股',
              '认缴出资方式': '股权',
              '认缴出资时间': '2014年12月31日',
              '认缴出资额(万元)': '26617.1661',
            },
          ],
          '股权变更': [],
          '资产状况信息': {
            '净利润': '企业选择不公示',
            '利润总额': '企业选择不公示',
            '所有者权益合计': '企业选择不公示',
            '纳税总额': '企业选择不公示',
            '营业总收入': '企业选择不公示',
            '营业总收入中主营业务收入': '企业选择不公示',
            '负债总额': '企业选择不公示',
            '资产总额': '企业选择不公示',
          },
        },
        {
          '_id': '570ef142ffccecdb3f442ee7',
          'display_flags': {},
          '修改记录': [],
          '分支机构登记信息': [],
          '发布日期': '2017-07-06',
          '基本信息': {
            '从业人数': '2289 人',
            '企业名称': '上海汉得信息技术股份有限公司',
            '企业电子邮箱': 'investors@vip.hand-china.com',
            '企业经营状态': '开业',
            '企业联系电话': '021-67002300',
            '企业通信地址': '上海市青浦区汇联路33号',
            '是否有对外提供担保信息': '',
            '是否有投资信息或购买其他公司股权': '否',
            '是否有网站或网店': '是',
            '有限责任公司本年度是否发生股东股权转让': '否',
            '统一社会信用代码/注册号': '310000400308460',
            '邮政编码': '201707',
          },
          '对外投资信息': [],
          '对外提供保证担保': [],
          '成员信息': [],
          '报送年度': '2013',
          '注册号': '9131000074027295XF',
          '章程信息': {},
          '经营范围': {},
          '网站信息': [
            {
              '名称': '上海汉得信息技术股份有限公司',
              '类型': '网站',
              '网址': 'www.hand-china.com',
            },
          ],
          '股东及出资信息': [
            {
              '实缴出资方式': '股权',
              '实缴出资时间': '2013年12月31日',
              '实缴出资额(万元)': '138555.27',
              '序号': '1',
              '股东': '西藏山南迪宣投资管理合伙企业(有限合伙)',
              '认缴出资方式': '股权',
              '认缴出资时间': '2013年12月31日',
              '认缴出资额(万元)': '138555.27',
            },
            {
              '实缴出资方式': '股权',
              '实缴出资时间': '2013年12月31日',
              '实缴出资额(万元)': '2810.1447',
              '序号': '2',
              '股东': '范建震',
              '认缴出资方式': '股权',
              '认缴出资时间': '2013年12月31日',
              '认缴出资额(万元)': '2810.1447',
            },
            {
              '实缴出资方式': '股权',
              '实缴出资时间': '2013年12月31日',
              '实缴出资额(万元)': '2809.073212',
              '序号': '3',
              '股东': '陈迪清',
              '认缴出资方式': '股权',
              '认缴出资时间': '2013年12月31日',
              '认缴出资额(万元)': '2809.073212',
            },
            {
              '实缴出资方式': '股权',
              '实缴出资时间': '2013年12月31日',
              '实缴出资额(万元)': '260938.78013',
              '序号': '4',
              '股东': '社会公众股',
              '认缴出资方式': '股权',
              '认缴出资时间': '2013年12月31日',
              '认缴出资额(万元)': '260938.78013',
            },
          ],
          '股权变更': [],
          '资产状况信息': {
            '净利润': '企业选择不公示',
            '利润总额': '15220.527659 万元',
            '所有者权益合计': '134173.25983 万元',
            '纳税总额': '企业选择不公示',
            '营业总收入': '77284.581651 万元',
            '营业总收入中主营业务收入': '企业选择不公示',
            '负债总额': '12527.767229 万元',
            '资产总额': '146701.027059 万元',
          },
        },
        {
          '_id': '572166f2ffccecdb3f457ba5',
          'display_flags': {},
          '修改记录': [],
          '分支机构登记信息': [],
          '发布日期': '2017-07-06',
          '基本信息': {
            '从业人数': '企业选择不公示',
            '企业名称': '上海汉得信息技术股份有限公司',
            '企业电子邮箱': 'investors@vip.hand-china.com',
            '企业经营状态': '开业',
            '企业联系电话': '021-67002300',
            '企业通信地址': '上海市青浦区汇联路33号',
            '是否有对外提供担保信息': '',
            '是否有投资信息或购买其他公司股权': '是',
            '是否有网站或网店': '是',
            '有限责任公司本年度是否发生股东股权转让': '否',
            '统一社会信用代码/注册号': '9131000074027295XF',
            '邮政编码': '201707',
          },
          '对外投资信息': [
            {
              '投资设立企业或购买股权企业名称': '上海汉得微扬信息技术有限公司',
              '注册号/统一社会信用代码': '310118003111125',
            },
            {
              '投资设立企业或购买股权企业名称': '上海汉得商业保理有限公司',
              '注册号/统一社会信用代码': '310118003135278',
            },
            {
              '投资设立企业或购买股权企业名称': '上海汉得知云软件有限公司',
              '注册号/统一社会信用代码': '310000400779743',
            },
          ],
          '对外提供保证担保': [],
          '成员信息': [],
          '报送年度': '2015',
          '注册号': '9131000074027295XF',
          '章程信息': {},
          '经营范围': {},
          '网站信息': [
            {
              '名称': '上海汉得信息技术股份有限公司',
              '类型': '网站',
              '网址': 'www.hand-china.com',
            },
          ],
          '股东及出资信息': [
            {
              '实缴出资方式': '股权',
              '实缴出资时间': '2015年12月31日',
              '实缴出资额(万元)': '10473.2764',
              '序号': '1',
              '股东': '范建震',
              '认缴出资方式': '股权',
              '认缴出资时间': '2015年12月31日',
              '认缴出资额(万元)': '10473.2764',
            },
            {
              '实缴出资方式': '股权',
              '实缴出资时间': '2015年12月31日',
              '实缴出资额(万元)': '10473.0366',
              '序号': '2',
              '股东': '陈迪清',
              '认缴出资方式': '股权',
              '认缴出资时间': '2015年12月31日',
              '认缴出资额(万元)': '10473.0366',
            },
            {
              '实缴出资方式': '股权',
              '实缴出资时间': '2015年12月31日',
              '实缴出资额(万元)': '61916.1504',
              '序号': '3',
              '股东': '社会公众股',
              '认缴出资方式': '股权',
              '认缴出资时间': '2015年12月31日',
              '认缴出资额(万元)': '61916.1504',
            },
          ],
          '股权变更': [],
          '资产状况信息': {
            '净利润': '企业选择不公示',
            '利润总额': '企业选择不公示',
            '所有者权益合计': '企业选择不公示',
            '纳税总额': '企业选择不公示',
            '营业总收入': '企业选择不公示',
            '营业总收入中主营业务收入': '企业选择不公示',
            '负债总额': '企业选择不公示',
            '资产总额': '企业选择不公示',
          },
        },
        {
          '_id': '591126eb9d014d86b3b4e1e0',
          'display_flags': {},
          '修改记录': [
            {
              '修改事项': '股东及出资信息',
              '修改前': '股东：范建震 认缴：2016年12月31日股权10473.2764万 元 实缴：2016年12月31日股权10473.2764万元；股东：陈迪清 认缴：2016年12月31日股权10473.0366万 元 实缴：2016年12月31日股权10473.0366万元；股东：社会公众股 认缴：2016年12月31日股权61413.5513万 元 实缴：2016年12月31日股权61413.5513万元；',
              '修改后': '股东：范建震 认缴：2016年12月31日股权10473.2764万 元 实缴：2016年12月31日股权10473.2764万元；股东：社会公众股 认缴：2016年12月31日股权65300.7004万 元 实缴：2016年12月31日股权65300.7004万元；股东：陈迪清 认缴：2016年12月31日股权10473.0366万 元 实缴：2016年12月31日股权10473.0366万元；',
              '修改日期': '2017年5月17日',
              '序号': '1',
            },
          ],
          '分支机构登记信息': [],
          '发布日期': '2017-07-06',
          '基本信息': {
            '从业人数': '企业选择不公示',
            '企业主营业务活动': '研究、开发和生产计算机软件、信息系统和网络产品，从事信息系统和数据管理系统的安装以及信息系统的集成，提供技术开发、咨询服务以及与该服务相关的客户支援服务，提供整体企业信息系统解决方案，销售公司自产产品等。',
            '企业名称': '上海汉得信息技术股份有限公司',
            '企业控股情况': '企业选择不公示',
            '企业电子邮箱': 'investors@vip.hand-china.com',
            '企业经营状态': '开业',
            '企业联系电话': '021-67002300',
            '企业通信地址': '上海市青浦区汇联路33号',
            '其中女性从业人数': '企业选择不公示',
            '是否有对外提供担保信息': '否',
            '是否有投资信息或购买其他公司股权': '是',
            '是否有网站或网店': '是',
            '有限责任公司本年度是否发生股东股权转让': '否',
            '统一社会信用代码/注册号': '9131000074027295XF',
            '邮政编码': '201707',
          },
          '对外投资信息': [
            {
              '投资设立企业或购买股权企业名称': '上海夏尔软件有限公司',
              '注册号/统一社会信用代码': '91310115743796871X',
            },
            {
              '投资设立企业或购买股权企业名称': '上海汉得欧俊信息技术有限公司',
              '注册号/统一社会信用代码': '9131011832083248XD',
            },
            {
              '投资设立企业或购买股权企业名称': '随身科技（上海）有限公司',
              '注册号/统一社会信用代码': '310115755040975',
            },
            {
              '投资设立企业或购买股权企业名称': '上海汉得融晶信息科技有限公司',
              '注册号/统一社会信用代码': '91310118055085080P',
            },
            {
              '投资设立企业或购买股权企业名称': '上海汉得商业保理有限公司',
              '注册号/统一社会信用代码': '91310118342422203P',
            },
            {
              '投资设立企业或购买股权企业名称': '上海汉得微扬信息技术有限公司',
              '注册号/统一社会信用代码': '91310118332460847Q',
            },
            {
              '投资设立企业或购买股权企业名称': '上海汉得知云软件有限公司',
              '注册号/统一社会信用代码': '91310000336448300D',
            },
            {
              '投资设立企业或购买股权企业名称': '上海达美信息技术有限公司',
              '注册号/统一社会信用代码': '91310000776252416K',
            },
            {
              '投资设立企业或购买股权企业名称': '扬州达美投资管理有限公司',
              '注册号/统一社会信用代码': '913210913983952750',
            },
            {
              '投资设立企业或购买股权企业名称': '上海甄汇信息科技有限公司',
              '注册号/统一社会信用代码': '91310118MA1JLFER1F',
            },
          ],
          '对外提供保证担保': [],
          '成员信息': [],
          '报送年度': '2016',
          '注册号': '9131000074027295XF',
          '章程信息': {},
          '经营范围': {},
          '网站信息': [
            {
              '名称': '上海汉得信息技术股份有限公司',
              '类型': '网站',
              '网址': 'www.hand-china.com',
            },
          ],
          '股东及出资信息': [
            {
              '实缴出资方式': '股权',
              '实缴出资时间': '2016年12月31日',
              '实缴出资额(万元)': '65300.7004',
              '序号': '1',
              '股东': '社会公众股',
              '认缴出资方式': '股权',
              '认缴出资时间': '2016年12月31日',
              '认缴出资额(万元)': '65300.7004',
            },
            {
              '实缴出资方式': '股权',
              '实缴出资时间': '2016年12月31日',
              '实缴出资额(万元)': '10473.0366',
              '序号': '2',
              '股东': '陈迪清',
              '认缴出资方式': '股权',
              '认缴出资时间': '2016年12月31日',
              '认缴出资额(万元)': '10473.0366',
            },
            {
              '实缴出资方式': '股权',
              '实缴出资时间': '2016年12月31日',
              '实缴出资额(万元)': '10473.2764',
              '序号': '3',
              '股东': '范建震',
              '认缴出资方式': '股权',
              '认缴出资时间': '2016年12月31日',
              '认缴出资额(万元)': '10473.2764',
            },
          ],
          '股权变更': [],
          '资产状况信息': {
            '净利润': '企业选择不公示',
            '利润总额': '企业选择不公示',
            '所有者权益合计': '企业选择不公示',
            '纳税总额': '企业选择不公示',
            '营业总收入': '企业选择不公示',
            '营业总收入中主营业务收入': '企业选择不公示',
            '负债总额': '企业选择不公示',
            '资产总额': '企业选择不公示',
          },
        },
      ],
      'total': 4,
    },
    'xzcfInfor': {
      'hits': [
        {
          '_id': '57da712808e3020b62f06a56',
          '处罚部门': '证监会',
          '当事人': [
            '江苏通光电子线缆股份有限公司',
            '通光线缆',
            '浙江永贵电器股份有限公司',
            '永贵电器',
            '上海汉得信息技术股份有限公司',
            '汉得信息',
            '安徽省司尔特肥业股份有限公司',
            '司尔特',
            '武汉力源信息技术股份有限公司',
            '力源信息',
            '东莞宜安科技股份有限公司',
            '宜安科技',
            '安徽国祯环保节能科技股份有限公司',
            '国祯环保',
            '快乐购物股份有限公司',
            '快乐购',
            '南京云海特种金属股份有限公司',
            '云海金属',
            '北京万邦达环保技术股份有限公司',
            '万邦达',
            '天津凯发电气股份有限公司',
            '凯发电气',
            '成都卫士通信息产业股份有限公司',
            '卫士通',
          ],
          '来源': '证监会',
          '标题': '中国证监会行政处罚决定书（肖海东）',
          '正文': '<br>〔2016〕110号<br> <br>当事人：肖海东，男，1970年12月出生，地址：四川省成都市高新区。<br>依据《中华人民共和国证券法》（以下简称《证券法》）的有关规定，我会对肖海东操纵江苏通光电子线缆股份有限公司（以下简称通光线缆）、浙江永贵电器股份有限公司（以下简称永贵电器）、上海汉得信息技术股份有限公司（以下简称汉得信息）、安徽省司尔特肥业股份有限公司（以下简称司尔特）、武汉力源信息技术股份有限公司（以下简称力源信息）、东莞宜安科技股份有限公司（以下简称宜安科技）、安徽国祯环保节能科技股份有限公司（以下简称国祯环保）、快乐购物股份有限公司（以下简称快乐购）、南京云海特种金属股份有限公司（以下简称云海金属）、北京万邦达环保技术股份有限公司（以下简称万邦达）、天津凯发电气股份有限公司（以下简称凯发电气）、成都卫士通信息产业股份有限公司（以下简称卫士通）等12只股票价格一案进行了立案调查、审理，并依法向当事人告知了作出行政处罚的事实、理由、依据及当事人依法享有的权利。当事人肖海东提交了书面陈述申辩材料。应当事人的申请，我会举行听证，听取了当事人的陈述申辩意见。本案现已调查、审理终结。<br>经查明，肖海东存在以下违法事实：<br>一、2015年1月29日至7月14日，肖海东控制使用7个账户<br>肖海东控制使用“肖某昌”“杨某平”“杨某程”“陈某秀”“杨某”证券账户及“肖某昌”“杨某”信用账户等7个账户（以下简称账户组），账户组各证券账户资金来源与去向相互交叉且集中，资金主要直接来源为肖海东、杨某（肖海东妻子）。证券账户委托下单使用的交易地址存在交叉相同且与肖海东出入境记录和航班信息高度吻合。证券账户、三方存管银行账户的开户留存电话存在交叉相同。账户组各证券账户名义持有人之间存在近亲属、姻亲或其他紧密关系。“肖某昌”“杨某平”“杨某程”“杨某”账户的名义持有人或操作人均称肖海东对涉案账户进行决策、操作，并称“陈某秀”账户根据肖海东或杨某建议操作。肖海东承认控制和使用涉案账户并操作了大部分账户，并对“陈某秀”账户的操作决策有重要影响。账户组绝大多数操纵交易由肖海东本人操作，少量交易由杨某按其指令操作。<br>二、肖海东控制使用账户组交易“通光线缆”等12只股票，获利13,413,747.87元<br>（一）账户组交易“通光线缆”的情况<br>2015年5月6日至5月26日，账户组通过在短时间内大量发出买入委托指令，买入价格呈阶梯式上升，迅速大幅推高股价，然后迅速对尚未成交的买入委托指令撤单，对通光线缆股价造成影响，获利8,724,484.65元。<br>（二）账户组交易“永贵电器”的情况<br>2015年3月23日至4月17日，账户组在3月31日、4月3日、4月9日、4月10日、4月15日、4月16日等6个交易日存在集中资金优势连续买入、多次盘中全部或部分撤销委托并反向卖出股票行为，影响该股票交易价格和交易量，亏损18,817,942.27元。<br>（三）账户组交易“汉得信息”的情况<br>2015年5月22日，账户组存在集中资金优势连续买入、多次盘中全部或部分撤销委托并反向卖出股票行为，影响该股票交易价格和交易量，亏损314,826.24元。<br>（四）账户组交易“司尔特”的情况<br>2015年1月29日至3月19日，账户组在3月6日、3月9日、3月10日等3个交易日存在集中资金优势连续买入、多次盘中全部或部分撤销委托并反向卖出股票行为，影响该股票交易价格和交易量，获利1,106,774.16元。<br>（五）账户组交易“力源信息”的情况<br>2015年4月8日至4月27日，账户组在4月20日、4月21日、4月23日等3个交易日存在集中资金优势连续买入、多次盘中全部或部分撤销委托并反向卖出股票行为，影响该股票交易价格和交易量，亏损4,861,364.33元。<br>（六）账户组交易“宜安科技”的情况<br>2015年3月26日至4月16日，账户组在4月8日、4月9日等2个交易日存在集中资金优势连续买入、多次盘中全部或部分撤销委托并反向卖出股票行为，影响该股票交易价格和交易量，获利2,517,723.97元。<br>（七）账户组交易“国祯环保”的情况<br>2015年5月11日至5月28日，账户组在5月15日、5月19日、5月21日、5月25日等4个交易日存在集中资金优势连续买入、多次盘中全部或部分撤销委托并反向卖出股票行为，影响该股票交易价格和交易量，亏损6,460,400.31元。<br>（八）账户组交易“快乐购”的情况<br>2015年1月15日至7月14日，账户组在2月17日、5月19日、5月20日、5月26日、5月27日、5月28日、5月29日、6月3日、6月5日等9个交易日存在集中资金优势连续买入、多次盘中全部或部分撤销委托并反向卖出股票行为，影响该股票交易价格和交易量，亏损3,711,816.34元。<br>（九）账户组交易“云海金属”的情况<br>2015年4月2日，账户组存在集中资金优势连续买入、多次盘中全部或部分撤销委托并反向卖出股票行为，影响该股票交易价格和交易量，获利597,366.43元。<br>（十）账户组交易“万邦达”的情况<br>2015年3月18日至5月27日，账户组在4月29日、5月7日、5月8日等3个交易日存在集中资金优势连续买入、多次盘中全部或部分撤销委托并反向卖出股票行为，影响该股票交易价格和交易量，亏损1,191,279.95元。<br>（十一）账户组交易“凯发电气”的情况<br>2015年5月21日至7月14日，账户组在5月22日、5月27日、6月1日、6月2日、6月23日、6月25日、6月30日、7月2日等8个交易日存在集中资金优势连续买入、多次盘中全部或部分撤销委托并反向卖出股票行为，影响该股票交易价格和交易量，亏损4,274,944.17元。<br>（十二）账户组交易“卫士通”的情况<br>2015年3月24日，账户组存在集中资金优势连续买入、多次盘中全部或部分撤销委托并反向卖出股票行为，影响该股票交易价格和交易量，获利467,398.66元。<br>以上事实，有相关账户交易流水、硬件信息、相关交易数据、交易所计算数据、询问笔录等证据证明，足以认定。<br>肖海东的上述行为违反了《证券法》第七十七条第一款第（一）项的规定，构成《证券法》第二百零三条所述操纵证券市场的行为。<br>听证中，肖海东及其代理人提出：第一，肖海东主观上不具有操纵证券市场、诱使其他投资者交易的故意，客观上没有制造虚假的证券行情对其他投资者进行欺诈、诱导或误导其他投资者跟风交易，依法不构成操纵证券市场，且认定的操纵区间为片面截取部分片段；第二，《行政处罚事先告知书》对“通光线缆”与“永贵电器”等十一只股票认定不一致、违法所得计算不统一。<br>经复核，我会认为：第一，账户组交易数据显示，肖海东操作账户组利用资金优势、持股优势在短时间（每笔交易指令交易平均间隔在12秒至57秒之间）内重复多次大量集中申买、阶梯提高申买价、立即撤单并反向卖出行为，影响“通光线缆”等12只股票价格，肖海东不能对此行为作出合理解释；第二，应当事人要求，我会对涉案12只股票的认定事实及违法所得计算进行了调整。<br>根据当事人违法行为的事实、性质、情节与社会危害程度，依据《证券法》第二百零三条的规定，我会决定：没收肖海东违法所得13,413,747.87元,并处以40,241,243.61元罚款。<br>上述当事人应自收到本处罚决定书之日起15日内，将罚没款汇交中国证券监督管理委员会（开户银行：中信银行总行营业部，账号：7111010189800000162，由该行直接上缴国库），并将注有当事人名称的付款凭证复印件送中国证券监督管理委员会稽查局备案。当事人如果对本处罚决定不服，可在收到本处罚决定书之日起60日内向中国证券监督管理委员会申请行政复议，也可在收到本处罚决定书之日起6个月内向有管辖权的人民法院提起行政诉讼。复议和诉讼期间，上述决定不停止执行。<br> <br> <br> <br> <br>中国证监会　 　　　　<br>2016年9月13日　　　　<br>　　　 <br> <br> <br> <br> <br> ',
        },
      ],
      'total': 1,
    },
    'swfzchInfor': {
      'hits': [],
      'total': 0,
    },
    'jyycInfor': {
      'hits': [],
      'total': 0,
    },
    'ktggInfor': {
      'hits': [
        {
          '_id': '58c979c71c306aa723ad8055',
          'entities': [
            '上海圣元空调设备有限公司',
            '黄时光',
            '天颂建设集团有限公司上海分公司',
            '天颂建设集团有限公司',
            '上海汉得信息技术股份有限公司',
          ],
          '原告/上诉人': '上海圣元空调设备有限公司',
          '开庭时间': '2017-03-22',
          '案号': '(2016)沪0118民初1919号',
          '案由': '建设工程分包合同纠纷',
          '法官': '孙佑正',
          '法庭': '第七法庭',
          '法院': '上海市徐汇区人民法院',
          '被告/被上诉人': [
            '黄时光',
            '天颂建设集团有限公司上海分公司',
            '天颂建设集团有限公司',
            '上海汉得信息技术股份有限公司',
          ],
        },
        {
          '_id': '586d25bf08e3020b623eca60',
          'entities': [
            '喜悦',
            '上海汉得信息技术股份有限公司',
          ],
          '原告/上诉人': '喜悦',
          '开庭时间': '2017-01-11',
          '案号': '(2016)沪0118民初13732号',
          '案由': '劳务合同纠纷',
          '法官': '鲁祥云',
          '法庭': '青东第三法庭',
          '法院': '上海市闵行区人民法院',
          '被告/被上诉人': ['上海汉得信息技术股份有限公司'],
        },
        {
          '_id': '5838769a08e3020b62a3dbe0',
          'entities': [
            '上海圣元空调设备有限公司',
            '黄时光',
            '天颂建设集团有限公司上海分公司',
            '天颂建设集团有限公司',
            '上海汉得信息技术股份有限公司',
          ],
          '原告/上诉人': '上海圣元空调设备有限公司',
          '开庭时间': '2016-12-09',
          '案号': '(2016)沪0118民初1919号',
          '案由': '建设工程分包合同纠纷',
          '法官': '孙佑正',
          '法庭': '第十六法庭',
          '法院': '上海市青浦区人民法院',
          '被告/被上诉人': [
            '黄时光',
            '天颂建设集团有限公司上海分公司',
            '天颂建设集团有限公司',
            '上海汉得信息技术股份有限公司',
          ],
        },
        {
          '_id': '5734b37164151d26f6419326',
          'entities': [
            '上海圣元空调设备有限公司',
            '黄时光',
            '天颂建设集团有限公司上海分公司',
            '天颂建设集团有限公司',
            '上海汉得信息技术股份有限公司',
          ],
          '原告/上诉人': '上海圣元空调设备有限公司',
          '开庭时间': '2016-05-30',
          '案号': '(2016)沪0118民初1919号',
          '案由': '建设工程分包合同纠纷',
          '法官': '孙佑正',
          '法庭': '第十二法庭',
          '法院': '上海市青浦区人民法院',
          '被告/被上诉人': [
            '黄时光',
            '天颂建设集团有限公司上海分公司',
            '天颂建设集团有限公司',
            '上海汉得信息技术股份有限公司',
          ],
        },
        {
          '_id': '56d5193564151d26f66d7ccd',
          'entities': [
            '上海圣元空调设备有限公司',
            '黄时光',
            '天颂建设集团有限公司上海分公司',
            '天颂建设集团有限公司',
            '上海汉得信息技术股份有限公司',
          ],
          '原告/上诉人': '上海圣元空调设备有限公司',
          '开庭时间': '2016-04-06',
          '案号': '(2016)沪0118民初1919号',
          '案由': '建设工程分包合同纠纷',
          '法官': '孙佑正',
          '法庭': '第十二法庭',
          '法院': '上海市青浦区人民法院',
          '被告/被上诉人': [
            '黄时光',
            '天颂建设集团有限公司上海分公司',
            '天颂建设集团有限公司',
            '上海汉得信息技术股份有限公司',
          ],
        },
      ],
      'total': 5,
    },
    'sfxzInfor': {
      'hits': [],
      'total': 0,
    },
    'shixinInfor': {
      'hits': [],
      'total': 0,
    },
    'zhixingInfor': {
      'hits': [
        {
          '_id': '55e5628f90227cbcf573af96',
          'entities': [
            '上海全富汉得软件技术有限公司',
          ],
          '执行标的': 2709.68,
          '执行法院': '上海市浦东新区人民法院',
          '案件状态': '已结案',
          '案号': '(2007)浦执字第00985号',
          '立案时间': '2007-01-17',
          '被执行人姓名/名称': '上海全富汉得软件技术有限公司',
        },
      ],
      'total': 1,
    },
    'cpwsInfor': {
      'hits': [
        {
          '_id': '595b5aa4bf330300050e4491',
          'entities': [
            '上海汉得信息技术股份有限公司',
            '刘善理',
            '何青青',
            '明一国际营养品集团有限公司',
            '宋雄',
            '卓丽玉',
          ],
          '判决时间': '2017-04-18',
          '当事人': [
            {
              '其他角色': [
                '原审原告',
              ],
              '判决结果': '胜诉',
              '名字': '上海汉得信息技术股份有限公司',
              '法定代表人': [
                '范建震',
              ],
              '类型': '公司名',
              '角色': [
                '上诉人',
              ],
            },
            {
              '其他角色': [],
              '判决结果': '其他',
              '名字': '刘善理',
              '类型': '人名',
              '组织名': '福建建达律师事务所',
              '角色': [
                '诉讼代理人',
              ],
            },
            {
              '其他角色': [],
              '判决结果': '其他',
              '名字': '何青青',
              '类型': '人名',
              '组织名': '福建建达律师事务所',
              '角色': [
                '诉讼代理人',
              ],
            },
            {
              '其他角色': [
                '原审被告',
              ],
              '判决结果': '胜诉',
              '名字': '明一国际营养品集团有限公司',
              '法定代表人': [
                '林勇',
              ],
              '类型': '公司名',
              '角色': [
                '上诉人',
              ],
            },
            {
              '其他角色': [],
              '判决结果': '其他',
              '名字': '宋雄',
              '类型': '人名',
              '组织名': '福建博世律师事务所',
              '角色': [
                '诉讼代理人',
              ],
            },
            {
              '其他角色': [],
              '判决结果': '其他',
              '名字': '卓丽玉',
              '类型': '人名',
              '组织名': '福建博世律师事务所',
              '角色': [
                '诉讼代理人',
              ],
            },
          ],
          '文书类型': '判决书',
          '标题': '上海汉得信息技术股份有限公司、明一国际营养品集团有限公司买卖合同纠纷二审民事判决书',
          '案号': '(2017)闽01民终304号',
          '案由': '买卖合同纠纷',
          '段落': [
            {
              '内容': '福建省福州市中级人民法院',
              '标签': '头部',
            },
            {
              '内容': '民 事 判 决 书',
              '标签': '头部',
            },
            {
              '内容': '(2017)闽01民终304号',
              '标签': '头部',
            },
            {
              '内容': '上诉人(原审原告)：上海汉得信息技术股份有限公司，住所地上海市青浦工业园区外青松公路5500号303室，组织机构代码74027295-X。',
              '标签': '当事人',
            },
            {
              '内容': '法定代表人：范建震，总经理。',
              '标签': '当事人',
            },
            {
              '内容': '委托诉讼代理人：刘善理、何青青，福建建达律师事务所律师。',
              '标签': '当事人',
            },
            {
              '内容': '上诉人(原审被告)：明一国际营养品集团有限公司，住所地福建省长乐市福州航空港工业集中区仙昙路3号，统一社会信用代码913501827821969754。',
              '标签': '当事人',
            },
            {
              '内容': '法定代表人：林勇，总经理。',
              '标签': '当事人',
            },
            {
              '内容': '委托诉讼代理人：宋雄、卓丽玉，福建博世律师事务所律师。',
              '标签': '当事人',
            },
            {
              '内容': '上诉人上海汉得信息技术股份有限公司（以下简称“汉得公司”）、上诉人明一国际营养品集团有限公司（以下简称“明一公司”）因买卖合同纠纷一案，不服福建省长乐市人民法院(2016)闽0182民初2680号民事判决，向本院提起上诉。',
              '标签': '庭审程序说明',
            },
            {
              '内容': '本院受理后，依法组成合议庭适用第二审程序对本案进行了审理。',
              '标签': '庭审程序说明',
            },
            {
              '内容': '上诉人的委托诉讼代理人刘善理、何青青，被上诉人委托诉讼代理人宋雄、卓丽玉到庭参加诉讼。',
              '标签': '庭审程序说明',
            },
            {
              '内容': '本案现已审理终结。',
              '标签': '庭审程序说明',
            },
            {
              '内容': '汉得公司上诉请求：1.撤销一审判决；2.明一公司继续履行合同并支付货款120万元；3.明一公司再行支付逾期付款违约金（以120万元货款为基数，按每天1‰利率计算，截止2015年5月30日共计36万元，实际计至明一公司实际付款之日止）；4.本案一、二审诉讼费由明一公司承担。',
              '标签': '诉称',
            },
            {
              '内容': '事实和理由：一、案涉合同合法有效，汉得公司并无解除合同的意思表示，双方未就解除合同达成一致意见，也不属于法定解除的情形，一审法院判令解除合同无事实依据。',
              '标签': '诉称',
            },
            {
              '内容': '二、明一公司未依据合同约定签署《ORACLE通用条款》，未支付货款，构成违约，应承担违约责任，汉得公司作为守约方，有权要求明一公司继续履行合同，并承担赔偿损失等违约责任。',
              '标签': '诉称',
            },
            {
              '内容': '三、明一公司继续履行合同要承担的是金钱债务，《中华人民共和国合同法》第一百一十条仅适用于非金钱债务的履行，不适用本案的情形，且明一公司实力雄厚，客观上具备履约的能力。',
              '标签': '诉称',
            },
            {
              '内容': '四、明一公司的违约行为给汉得公司造成重大损失，合同总金额120万元的千分之一计算逾期付款违约金并未过高，一审调整为软件总价20%不当，且一审中明一公司也未提出违约金过高，一审法院越权调整违约金不当。',
              '标签': '诉称',
            },
            {
              '内容': '明一公司辩称:一、案涉合同是附条件的合同，其所负条件为明一公司必须签署《ORACLE通用条款》，明一公司尚未签署该条款，案涉合同所附生效条件尚未成就，合同未生效。',
              '标签': '诉称',
            },
            {
              '内容': '二、汉得公司自称是甲骨文公司中国境内授权分销商，但未能出具授权文件，不能证明其有权向明一公司销售案涉产品，汉得公司无法出具授权文件的行为已经表明其不履行或无法履行合同，明一公司依法有权解除合同。',
              '标签': '诉称',
            },
            {
              '内容': '在汉得公司长时间无法出示授权文件的情况下，即使现在汉得公司能提供授权文件，明一公司也不再需要该产品。',
              '标签': '诉称',
            },
            {
              '内容': '三、合同约定汉得公司提供甲骨文公司专为明一公司定制的产品，二审中又称产品系其向北京信利恒丰公司购买，涉嫌欺诈。',
              '标签': '诉称',
            },
            {
              '内容': '四、案涉合同第十条约定明一公司拒绝接受案涉产品需支付20%违约金，这种违约金计付标准合理。',
              '标签': '诉称',
            },
            {
              '内容': '汉得公司关于日1%计付违约金的诉请无法律与合同依据。',
              '标签': '诉称',
            },
            {
              '内容': '明一公司上诉请求：1.依法撤销一审判决，改判驳回汉得公司的一审全部诉讼请求；2.本案一、二审诉讼费由汉得公司承担。',
              '标签': '诉称',
            },
            {
              '内容': '事实与理由：与前述明一公司答辩意见一致。',
              '标签': '辩称',
            },
            {
              '内容': '汉得公司辩称：与前述汉得公司上诉意见一致，另补充：案涉合同已生效，关于签署《ORACLE通用条款》的约定是明一公司应履行的义务，而非生效条件。',
              '标签': '辩称',
            },
            {
              '内容': '一审法院认定事实：2015年5月19日，汉得公司与明一公司签订《ORACLE软件销售合同》（合同编号：MYGJ-H-GX-1505-S0001）（合同所称“ORACLE”指甲骨文公司，合同所称“产品”、“软件产品”均指ORACLE授权汉得销售的其专有软件，包括软件使用许可或存储上述软件的介质），约定：明一公司向汉得公司采购软件产品（包括：SiebelCRMBase、SiebelDistributionCRMBaseOption、SiebelTools、SiebelTerritoryManagement、SiebelPartner、SiebelContractTermsandConditions、SiebelCustomerOrderManagementAdministrator、SiebelInventoryandOrderManagement、SiebelTradePromotions、SiebelLoyaltyManager），产品总价款120万元（其中包含第一年维护费216393.44元）；汉得公司在明一公司足额支付本合同约定的款项后的10天内交货；交货方式：由汉得公司或ORACLE或其他汉得公司指定的发货人通过快递或其他方式将软件使用许可证明文件或软件介质送达明一公司，明一公司收货人刘宜河或邮件专门接收人员在相关送达凭证上签收即视为已收货；软件使用范围为明一公司及分子公司；付款方式：本合同签订后10日内明一公司以银行转账方式向汉得公司支付120万元；由于本合同项下的产品是汉得公司专为明一公司而准备的，如明一公司无法定或约定理由拒绝接受符合本合同约定的产品（包括中途退货）应视为根本违约，应向汉得公司支付其拒绝接受部分（或中途退货部分）款项的20%作为违约金，并赔偿汉得公司因此造成的损失；明一公司对于本合同项下产品的使用须接受并遵守ORACLE制定的《ORACLE通用条款》（以下简称“OMA”），在本合同签署的同时明一公司应进入ORACLE指定的其官方网站内的网页链接在线签署OMA，在明一公司完成签署OMA之前，汉得公司无法为明一公司提供本合同项下的产品；如明一公司无法定或约定理由逾期付款，应按日向汉得公司支付本合同金额千分之一的违约金，如逾期超过30日则汉得公司有权解除本合同，客户应赔偿因此给汉得公司造成的损失。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '合同签订后，明一公司未进入ORACLE指定的官方网站在线签署OMA，也未向汉得公司付款，案涉软件至今未交付。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '另查，汉得公司系甲骨文公司的代理商（白金级合作伙伴）。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '以上事实由汉得公司提交并经庭审质证的《ORACLE软件销售合同》、《授权文件》以及原被告在庭审中所作的陈述等证据佐证。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '一审法院认为：本案系由于汉得公司将其代理的甲骨文公司ORACLE软件销售给明一公司而引发的纠纷，汉得公司与明一公司签订的《ORACLE软件销售合同》，系适格主体作出的真实意思表示，约定的内容未违反法律法规禁止性规定，系合法有效的合同。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '关于明一公司是否应当继续履行合同并支付120万元货款的问题。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '首先，案涉合同约定，明一公司应在合同签订当日签署《ORACLE通用条款》，在合同签订10日内履行付款义务，汉得公司在收到足额款项后10天内交货。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '但明一公司在签订案涉合同后，未按合同约定进入ORACLE指定的官方网站在线签署《ORACLE通用条款》，也未在约定时间内支付合同价款，已以自己的行为表示不愿继续履行合同。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '本院认为，根据《中华人民共和国民法通则》第四条关于“民事活动应当遵循自愿、公平、等价有偿、诚实信用的原则”的规定，本案合同签订至今已逾一年，庭审中明一公司也明确表示已不需要案涉产品，若继续履行，难以符合当事人签订合同时的真实意思表示，根据《中华人民共和国合同法》第一百一十条规定，违约方可以以承担违约责任的代价免除履行合同义务。',
              '标签': '法院意见',
            },
            {
              '内容': '本案中，尽管当事人之间存在的买卖合同关系合法有效，但从衡平各方利益角度出发，在当事人欠缺履行合意且强制履行成本过高的情况下，若判令继续履行则违反自愿公平之原则。',
              '标签': '法院意见',
            },
            {
              '内容': '因此，案涉《ORACLE软件销售合同》已实际解除，汉得公司主张要求明一公司支付120万元款项的诉讼请求，不予支持。',
              '标签': '法院意见',
            },
            {
              '内容': '关于明一公司是否应向汉得公司支付违约金的问题。',
              '标签': '法院意见',
            },
            {
              '内容': '根据《最高人民法院关于审理买卖合同纠纷案件适用法律问题的解释》第二十六条规定:“买卖合同因违约而解除后，守约方主张继续适用违约金条款的，人民法院应予支持；但约定的违约金过分高于造成的损失的，人民法院可以参照合同法第一百一十四条第二款的规定处理。',
              '标签': '法院意见',
            },
            {
              '内容': '”鉴于汉得公司在履行案涉买卖合同中没有过错，在案涉合同因明一公司违约而解除后，汉得公司因买卖合同标的产生的预期利益可通过违约金得到补偿。',
              '标签': '法院意见',
            },
            {
              '内容': '考虑到案涉标的未实际交付，结合违约金兼具补偿与惩罚的性质，合同约定的违约金已足以弥补汉得公司受到的损失。',
              '标签': '法院意见',
            },
            {
              '内容': '案涉合同第十条约定，如明一公司无法定或约定理由拒绝接受产品视为根本违约，应向汉得公司支付其拒绝接受部分款项的20%作为违约金，案涉合同第十二条约定，如明一公司逾期付款，应按日向汉得公司支付合同金额千分之一的违约金。',
              '标签': '法院意见',
            },
            {
              '内容': '现案涉合同已实际解除，该违约金的计算标准过高，应调整为按软件总价的20%计算。',
              '标签': '法院意见',
            },
            {
              '内容': '因案涉标的为软件产品，第一年的维护费用216393.44元系基于该软件产品的衍生服务，违约金的计算应以软件总价为基数（即120万元合同总价-216393.44元维护费用=983606.56元）。',
              '标签': '法院意见',
            },
            {
              '内容': '故明一公司应向汉得公司支付违约金196721.31元（983606.56元×20%），对于汉得公司超出部分的诉讼请求，不予支持。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '因案涉合同违约方系明一公司，故本案诉讼费均应由明一公司承担。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '一审法院判决：一、明一国际营养品集团有限公司于本判决生效之日起十日内支付上海汉得信息技术股份有限公司逾期付款违约金196721.31元。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '二、驳回上海汉得信息技术股份有限公司其他诉讼请求。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '案件受理费18840元，减半收取计9420元，由明一国际营养品集团有限公司负担。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '二审中，汉得公司向本院提交两份证明资料：1、《软件产品购销合同》；2、（2017）京仲裁字第0339号《北京仲裁委员会裁决书》。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '明一公司质证对《软件产品购销合同》的客观性、合法性、关联性均有异议，对（2017）京仲裁字第0339号《北京仲裁委员会裁决书》客观性无异议，但因对裁决书所依据的《软件产品购销合同》合法性、关联性有异议，故对裁决书合法性、关联性也有异议。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '经审查，对（2017）京仲裁字第0339号《北京仲裁委员会裁决书》的客观性、合法性、关联性，本院予以确认。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '本院注意到在《软件产品购销合同》中约定的交货日期是合同生效后20个工作日的情况下，《软件产品购销合同》落款无签约时间，亦未约定合同生效时间，汉得公司委托诉讼代理人刘善理亦无法向本院确定该合同签订的明确时间，甚至无法明确《软件产品购销合同》与案涉《ORACLE软件销售合同》签订的先后顺序，不合常理。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '故对该份证明资料的客观性，本院不予确认。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '一审中，汉得公司向法院提交甲骨文白金级合作伙伴证明（有效期至2015年4月7日）、甲骨文白金级合作伙伴证明（有效期至2016年4月21日）、《甲骨文合作伙伴网络全球协议》（2016年4月27）三份证明资料。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '但甲骨文白金级合作伙伴证明（有效期至2015年4月7日）、甲骨文白金级合作伙伴证明（有效期至2016年4月21日）两份证明资料均无甲骨文公司盖章，仅有richGfraffo签名确认，属于证人证言，但richGfraffo未到庭作证，故对该两份证明的客观性，本院无法确认；《甲骨文合作伙伴网络全球协议》（2016年4月27）有加盖甲骨文公司合同专用章，对其客观性、合法性本院予以认可，但该份协议2016年4月27日才生效，协议内容亦是对此后甲骨文公司与汉得公司合作关系的约定，与本案不具有关联性。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '故前述三份证明资料均不可作为本案认定事实的依据。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '根据本案现有证据，除“汉得公司系甲骨文公司的代理商（白金级合作伙伴）”外，对一审认定的事实予以确认。',
              '标签': '庭审过程其他',
            },
            {
              '内容': '本院认为，《中华人民共和国著作权法》第二十四条规定“使用他人作品应当同著作权人订立许可使用合同，本法规定可以不经许可的除外。',
              '标签': '法院意见',
            },
            {
              '内容': '”；第二十七条规定“许可使用合同和转让合同中著作权人未明确许可、转让的权利，未经著作权人同意，另一方当事人不得行使。',
              '标签': '法院意见',
            },
            {
              '内容': '”；《计算机软件保护条例》第十八条规定“许可他人行使软件著作权的，应当订立许可使用合同。',
              '标签': '法院意见',
            },
            {
              '内容': '许可使用合同中软件著作权人未明确许可的权利，被许可人不得行使。',
              '标签': '法院意见',
            },
            {
              '内容': '”本案中，《ORACLE软件销售合同》约定由汉得公司向明一公司提供甲骨文公司授权的“包括软件使用许可或存储该软件的介质”，其本质上是为明一公司提供甲骨文公司享有著作权的特定软件的使用许可，故本案的案由应为计算机软件著作权许可使用合同纠纷。',
              '标签': '法院意见',
            },
            {
              '内容': '汉得公司称其系从北京信利恒丰公司处取得该软件使用许可及介质后转让明一公司，但其至今未能证明北京信利恒丰公司或汉得公司已合法取得权利人甲骨文公司对案涉软件的转让许可，即汉得公司尚无法证明其所售产品在知识产权方面是无瑕疵或是合法的。',
              '标签': '法院意见',
            },
            {
              '内容': '故对汉得公司要求明一公司继续履行合同并支付违约金的主张，本院在当前证据条件下无法支持。',
              '标签': '法院意见',
            },
            {
              '内容': '综上，上诉人汉得公司的上诉理不成立，明一公司的上诉理由部分成立。',
              '标签': '法院意见',
            },
            {
              '内容': '依照《中华人民共和国合同法》第五十二条，中华人民共和国著作权法》第二十四条、二十七条，《计算机软件保护条例》第十八条，《中华人民共和国民事诉讼法》第一百七十条第一款第二项规定，判决如下：',
              '标签': '法院意见',
            },
            {
              '内容': '1撤销福建省长乐市人民法院(2016)闽0182民初2680号民事判决；',
              '标签': '判决结果',
            },
            {
              '内容': '2驳回上诉人上海汉得信息技术股份有限公司一审全部诉讼请求。',
              '标签': '判决结果',
            },
            {
              '内容': '本案一审案件受理费9420元，二审受理案件受理费18840元，均由上海汉得信息技术股份有限公司承担。',
              '标签': '判决结果',
            },
            {
              '内容': '本判决为终审判决。',
              '标签': '庭后告知',
            },
            {
              '内容': '审　判　长　　林秀榕',
              '标签': '结尾',
            },
            {
              '内容': '代理审判员　　魏　昀',
              '标签': '结尾',
            },
            {
              '内容': '代理审判员　　官永琪',
              '标签': '结尾',
            },
            {
              '内容': '二〇一七年四月十八日',
              '标签': '结尾',
            },
            {
              '内容': '书　记　员　　郑菡君',
              '标签': '结尾',
            },
          ],
          '法院': '福建省福州市中级人民法院',
        },
      ],
      'total': 1,
    },
    'investmentInfor': {
      'hits': [
        {
          '名称': '上海甄云信息科技有限公司',
          '曾用名': [],
          '核准日期': '2017年6月5日',
          '注册号': '',
          '登记机关': '青浦区市场监督管理局',
          '登记状态': '存续（在营、开业、在册）',
          '统一社会信用代码': '91310118MA1JLY548Q',
        },
        {
          '名称': '共享智能铸造产业创新中心有限公司',
          '曾用名': [],
          '核准日期': '2017年06月02日',
          '注册号': '',
          '登记机关': '银川高新技术产业开发区工商行政管理局',
          '登记状态': '开业',
          '统一社会信用代码': '91641100MA7618N33N',
        },
        {
          '名称': '上海甄汇信息科技有限公司',
          '曾用名': [],
          '核准日期': '2016年8月19日',
          '注册号': '',
          '登记机关': '青浦区市场监督管理局',
          '登记状态': '存续（在营、开业、在册）',
          '统一社会信用代码': '91310118MA1JLFER1F',
        },
        {
          '名称': '上海汉得信息技术股份有限公司深圳分公司',
          '曾用名': [],
          '核准日期': '2016年11月23日',
          '注册号': '440301506066777',
          '登记机关': '深圳市市场监督管理局',
          '登记状态': '存续',
          '统一社会信用代码': '91440300578816495E',
        },
        {
          '名称': '扬州达美投资管理有限公司',
          '曾用名': [],
          '核准日期': '2016年01月19日',
          '注册号': '913210913983952750',
          '登记机关': '扬州经济技术开发区市场监督管理局',
          '登记状态': '在业',
          '统一社会信用代码': '913210913983952750',
        },
        {
          '名称': '上海汉得知云软件有限公司',
          '曾用名': [],
          '核准日期': '2015年9月6日',
          '注册号': '310000400779743',
          '登记机关': '上海市工商局',
          '登记状态': '存续（在营、开业、在册）',
          '统一社会信用代码': '91310000336448300D',
        },
        {
          '名称': '上海兴富创业投资管理中心',
          '曾用名': [],
          '核准日期': '2015年5月28日',
          '注册号': '310120002776318',
          '登记机关': '奉贤区市场监管局',
          '登记状态': '存续（在营、开业、在册）',
          '统一社会信用代码': '91310120341981353C',
        },
        {
          '名称': '上海汉得商业保理有限公司',
          '曾用名': [],
          '核准日期': '2015年5月19日',
          '注册号': '',
          '登记机关': '青浦区市场监督管理局',
          '登记状态': '存续（在营、开业、在册）',
          '统一社会信用代码': '91310118342422203P',
        },
        {
          '名称': '上海汉得微扬信息技术有限公司',
          '曾用名': [],
          '核准日期': '2015年3月23日',
          '注册号': '',
          '登记机关': '青浦区市场监督管理局',
          '登记状态': '存续（在营、开业、在册）',
          '统一社会信用代码': '91310118332460847Q',
        },
        {
          '名称': '上海黑骥马股权投资合伙企业',
          '曾用名': [],
          '核准日期': '2014年4月2日',
          '注册号': '310000000124838',
          '登记机关': '上海市工商局',
          '登记状态': '存续（在营、开业、在册）',
          '统一社会信用代码': '',
        },
        {
          '名称': '上海汉得欧俊信息技术有限公司',
          '曾用名': [],
          '核准日期': '2014年11月4日',
          '注册号': '',
          '登记机关': '青浦区市场监督管理局',
          '登记状态': '存续（在营、开业、在册）',
          '统一社会信用代码': '9131011832083248XD',
        },
        {
          '名称': '上海汉得融晶信息科技有限公司',
          '曾用名': [],
          '核准日期': '2012年10月11日',
          '注册号': '310118002776274',
          '登记机关': '青浦区市场监督管理局',
          '登记状态': '存续（在营、开业、在册）',
          '统一社会信用代码': '91310118055085080P',
        },
        {
          '名称': '上海达美信息技术有限公司',
          '曾用名': [],
          '核准日期': '2005年6月2日',
          '注册号': '310115000894993',
          '登记机关': '自贸区市场监督管理局',
          '登记状态': '存续（在营、开业、在册）',
          '统一社会信用代码': '91310000776252416K',
        },
        {
          '名称': '随身科技（上海）有限公司',
          '曾用名': [
            '随身行软件（上海）有限公司',
          ],
          '核准日期': '2003年10月29日',
          '注册号': '',
          '登记机关': '自贸区市场监督管理局',
          '登记状态': '存续（在营、开业、在册）',
          '统一社会信用代码': '91310115755040975A',
        },
        {
          '名称': '上海夏尔软件有限公司',
          '曾用名': [],
          '核准日期': '2002年10月21日',
          '注册号': '310115000713440',
          '登记机关': '自贸区市场监督管理局',
          '登记状态': '存续（在营、开业、在册）',
          '统一社会信用代码': '91310115743796871X',
        },
        {
          '名称': '上海全富汉得软件技术有限公司中环办事处',
          '曾用名': [],
          '核准日期': '',
          '注册号': '',
          '登记机关': '上海市工商局',
          '登记状态': '',
          '统一社会信用代码': '',
        },
      ],
      'total': 16,
    },
    'ssggInfo': {
      'hits': [],
      'total': 0,
    },
    'tudiInfor': {
      'hits': [
        {
          '_id': '56f1c63b64151d26f6bbe3b2',
          'entities': [
            '上海汉得信息技术股份有限公司',
          ],
          '公告类别': '地块公示',
          '公示期': '2012-02-17',
          '出让年限': '50年',
          '单位地址': '',
          '受让单位': '上海汉得信息技术股份有限公司',
          '土地用途': '工业用地',
          '土地面积(公顷)': '5.81258',
          '地块位置': '东至:大田,南至:上达河,西至:汇金路,北至:绿谷公司',
          '备注': '',
          '成交价格(万元)': '3488',
          '标题': '宝应县2012-1号成交公示',
          '电子邮件': '',
          '联系人': '',
          '联系单位': '',
          '联系电话': '',
          '行政区': '常州市本级',
          '邮政编码': '',
        },
      ],
      'total': 1,
    },
    'patentInfor': {
      'hits': [
        {
          'Locarno分类': '',
          '_id': '56428cae90227cbcf5f6690f',
          'entities': [
            '上海汉得信息技术股份有限公司',
          ],
          '专利代理机构': '上海君铁泰知识产权代理事务所(普通合伙)31274',
          '专利类型': '发明公告',
          '代理人': '潘建玲',
          '发明人': '邹秉灵',
          '发明（设计）名称': '基于云计算的中小企业供应链金融平台',
          '国际分类': 'G07F19/00(2006.01)I',
          '地址': '201708上海市青浦区青浦工业园区外青松公路5500号303室',
          '摘要': '本发明属于企业管理技术领域，提供了基于云计算的中小企业供应链金融平台，包括：云平台摒弃了复杂的权限配置和主数据管理，通过向导模式完成系统初始化设置；云平台根据访问的用户身份不同，动态集成私有云中ERP系统用户身份认证服务，从而控制数据访问权限；云平台用户功能由企业用户在ERP系统中根据需求灵活定制，以适用不同用户环境下的访问需求，包括：系统应用模块、中小企业融资模块、信贷风险控制模块、中小企业信息管理模块、应收应付管理模块、总账管理模块、资产管理模块。本发明具有更加简洁、实用、使用方便，并且能够根据企业需要进行自主选择功能模块、成本低、适用于中小企业使用的优点。',
          '申请人': '上海汉得信息技术股份有限公司',
          '申请公布号': 'CN103810794A',
          '申请公布日': '2014-05-21',
          '申请号': '2014100987935',
          '申请日': '2014-03-18',
        },
        {
          'Locarno分类': '',
          '_id': '5640c01f90227cbcf5e626e4',
          'entities': [
            '上海汉得信息技术股份有限公司',
          ],
          '专利代理机构': '上海君铁泰知识产权代理事务所(普通合伙)31274',
          '专利类型': '发明公告',
          '代理人': '潘建玲',
          '发明人': '张礼军; 刘海螺; 刘智聪',
          '发明（设计）名称': '一种基于云计算的系统运营支持系统',
          '国际分类': 'G06Q10/06(2012.01)I',
          '地址': '201700上海市青浦区青浦工业园区外青松公路5500号303室',
          '摘要': '本发明公开了一种基于云计算的系统运营支持系统，包括：事故管理模块，支持对突发事件和服务请求的响应和处理，用于单个事故的记录、调度、调查诊断、跟踪、升级、关闭、监控和改善，快速获得运维人员通过第二输入输出模块对事故的处理结果；变更管理模块，针对配置的变更进行评估和影响分析，负责变更计划管理、变更阶段管理及变更审批；配置管理模块，记录所有IT硬件、软件、文档与知识之间的关系，其数据供该变更管理模块与该事故管理模块使用，联合确定和管理配置影响范围和变更记录；知识库，用于信息收集、整理以及数据分析、统计；第一至第四输入输出模块，本发明可为企业节省大量的IT服务人员，提升企业的IT管理效率，降低成本。',
          '申请人': '上海汉得信息技术股份有限公司',
          '申请公布号': 'CN103390227A',
          '申请公布日': '2013-11-13',
          '申请号': '2013103452256',
          '申请日': '2013-08-08',
        },
        {
          'Locarno分类': '',
          '_id': '563e0d8c90227cbcf5c69042',
          'entities': [
            '上海汉得信息技术股份有限公司',
          ],
          '专利代理机构': '上海君铁泰知识产权代理事务所(普通合伙) 31274',
          '专利类型': '发明公告',
          '代理人': '潘建玲',
          '发明人': '田剑鹏',
          '发明（设计）名称': '一种基于EBS企业系统中快速开取增值税发票的方法',
          '国际分类': 'G06Q30/04(2012.01)I',
          '地址': '201700 上海市青浦区青浦工业园区外青松公路5500号303室',
          '摘要': '本发明提供了一种基于EBS企业系统中快速开取增值税发票的方法，包含以下步骤：（1）数据预处理，检测开票数据信息的完整性；（2）合法性检查，检查是否具备开票权限和所能开具的发票种类；（3）数据导出，将已预处理且合法性检查完成的数据信息传输至金税系统；（4）开取发票，金税系统根据所获得的数据信息开取发票。本发明对开票数据进行了预处理，能够在开取发票前核对开票信息的完整性并且设定好开票的种类，防止开票时由于数据不符合被开票系统拒接；避免了开票过程中发现数据一致性错误或开票种类错误产生的废票；避免因传输导致的数据泄露。可以显著地加快开票处理流程，缩减处理时间，提高开票的准确率，减少废票。',
          '申请人': '上海汉得信息技术股份有限公司',
          '申请公布号': 'CN102722843A',
          '申请公布日': '2012-10-10',
          '申请号': '2012101702784',
          '申请日': '2012-05-29',
        },
        {
          'Locarno分类': '',
          '_id': '563e0fb190227cbcf5c6ab46',
          'entities': [
            '上海汉得信息技术股份有限公司',
          ],
          '专利代理机构': '上海君铁泰知识产权代理事务所(普通合伙)31274',
          '专利类型': '发明公告',
          '代理人': '潘建玲',
          '发明人': '陈超',
          '发明（设计）名称': 'PLM-ERP集成过程中的交易控制方法',
          '国际分类': 'G06Q10/06(2012.01)I',
          '地址': '201700上海市青浦工业园区外青松公路5500号303室',
          '摘要': '本发明涉及企业信息系统之间的集成方法，提供了一种PLM-ERP集成过程中的交易控制方法，包含：创建数据集成接口，所述数据集成接口将从PLM导出ECN数据、物料数据和OM数据相互关联整合为一个完整的数据集成接口；该数据集成接口将PLM全部创建和变更ECN数据模块、物料数据模块、BOM数据模块所需的数据同步到SAP系统中。本发明方法主要用于实现高端ERP系统与PLM系统的数据集成，以满足企业业务中研发的物料清单的变更准确、安全、高效的同步到ERP软件中并指导生产。',
          '申请人': '上海汉得信息技术股份有限公司',
          '申请公布号': 'CN102750610A',
          '申请公布日': '2012-10-24',
          '申请号': '201210170291X',
          '申请日': '2012-05-29',
        },
        {
          'Locarno分类': '',
          '_id': '562f7a1990227cbcf5683e63',
          'entities': [
            '上海全富汉得软件技术有限公司',
          ],
          '专利代理机构': '上海三方专利事务所',
          '专利类型': '发明公告',
          '代理人': '吴干权',
          '发明人': '吴滨',
          '发明（设计）名称': '基于Oracle AQ技术实现Oracle Form9i的Web嵌入的方法',
          '国际分类': 'G06F9/44',
          '地址': '201700上海市青浦区青浦工业园区外青松公路5500号303室',
          '摘要': '本发明涉及用于外部数据处理的计算机技术领域，具体地说是一种基于Oracle AQ技术实现Oracle Form9i的Web嵌入的方法。一种基于Oracle AQ技术实现Oracle Form9i的Web嵌入的方法，通过使用AQ的在Oracle数据库中的通信特性，实现在Web界面中通过点击WEB页面上的链接，使已经打开的基础FORM可以通过OPEN_FORM()方法打开新的FORM。其特征在于：从用户的观点来看，WEBFORM和WEB/JSP结合到一起，通过点击WEB/JSP上相应的链接可以打开相应的WEBFORM，就像点击FORM窗体上按钮一样。通过这种方式，即能使用成熟的WEB技术来进行外观的布置，创造出美观的外观，又解决了通过链接打开FORM会造成窗口的增多，消耗大量的资源的问题。从而实现了WEB页面中嵌入WEBFORM。',
          '申请人': '上海全富汉得软件技术有限公司',
          '申请公布号': 'CN1664780',
          '申请公布日': '2005-09-07',
          '申请号': '2005100246036',
          '申请日': '2005-03-24',
        },
        {
          'Locarno分类': '',
          '_id': '562f96ba90227cbcf5698ebd',
          'entities': [
            '上海全富汉得软件技术有限公司',
          ],
          '专利代理机构': '上海三方专利事务所',
          '专利类型': '发明授权',
          '代理人': '吴干权',
          '发明人': '吴滨',
          '发明（设计）名称': 'Oracle Form9i和Microsoft Excel透视表的自动转换的方法',
          '国际分类': 'G06F17/30',
          '地址': '201700上海市青浦区青浦工业园区外青松公路5500号303室',
          '摘要': '本发明涉及用于外部数据处理的计算机技术领域，具体地说是一种Oracle Form9i和Microsoft Excel透视表的自动转换的方法。一种Oracle Form9i和Microsoft Excel透视表的自动转换的方法，其特征在于这种方法包含的步骤有：(1)选定要导出的数据的数据块；(2)对要导出的数据定义其透视表的格式；(3)把数据块中的数据导出到服务器上的某个文件中；(4)打开WEB/JSP页面，读取服务器上的存放数据的文件；(5)通过WEB/JSP中嵌入的VBScript，按照定义的格式，把数据生成透视表，并用Excel打开；本发明与现有技术相比，实现能够从Form中导出数据生成Excel文件，并且能够按照设置，生成的Excel文件已经具有透视表转换，用户可以直接在这个Excel中进行数据分析。同时，本发明操作简便，适合用户使用。',
          '申请人': '上海全富汉得软件技术有限公司',
          '申请公布号': 'CN1664817',
          '申请公布日': '2005-09-07',
          '申请号': '2005100246040',
          '申请日': '2005-03-24',
        },
      ],
      'total': 6,
    },
    'zzqInfor': {
      'hits': [
        {
          '_id': '57a92f5c64151d26f6647fc3',
          '作品名称': '汉得供应链金融服务云平台软件',
          '公告日期': '2015-08-09',
          '公告类型': '科技软件著作权登记公告',
          '分类号': '30200-0000',
          '版本号': 'V2.0',
          '登记号': '2016SR209622',
          '登记日期': '2016-08-08',
          '著作权人': '上海汉得信息技术股份有限公司',
          '软件全称': '汉得供应链金融服务云平台软件',
          '软件简称': '供应链金融平台',
          '首次发表日期': '2016-05-30',
        },
        {
          '_id': '57a6c7f064151d26f6636517',
          '作品名称': '汉得医院资源计划管理系统',
          '公告日期': '2016-08-05',
          '公告类型': '计算机软件著作权登记公告',
          '分类号': '30200-8500',
          '版本号': 'V1.0',
          '登记号': '2016SR205948',
          '登记日期': '2016-08-04',
          '著作权人': '上海汉得信息技术股份有限公司',
          '软件全称': '汉得医院资源计划管理系统',
          '软件简称': 'HHRP',
          '首次发表日期': '2016-03-31',
        },
        {
          '_id': '57929ee264151d26f656196f',
          '作品名称': '汇联易报销及费用管理平台软件',
          '公告日期': '2014-07-23',
          '公告类型': '信息软件著作权登记公告',
          '分类号': '30212-0000',
          '版本号': 'V1.0',
          '登记号': '2016SR190255',
          '登记日期': '2016-07-22',
          '著作权人': '上海汉得信息技术股份有限公司',
          '软件全称': '汇联易报销及费用管理平台软件',
          '软件简称': '汇联易',
          '首次发表日期': '2016-04-19',
        },
        {
          '_id': '5758a83964151d26f62cb0e4',
          '作品名称': '汉得投资管理软件',
          '公告日期': '2016-06-08',
          '公告类型': '计算机软件著作权登记公告',
          '分类号': '30200-8300',
          '版本号': 'V2.0',
          '登记号': '2016SR135174',
          '登记日期': '2016-06-07',
          '著作权人': '上海汉得信息技术股份有限公司',
          '软件全称': '汉得投资管理软件',
          '软件简称': 'HIM',
        },
        {
          '_id': '56f2571d64151d26f6bf47fc',
          '作品名称': '汉得投资管理软件',
          '公告日期': '2016-03-02',
          '公告类型': '计算机软件著作权登记公告',
          '分类号': '30200-8300',
          '版本号': 'V1.0',
          '登记号': '2016SR041456',
          '登记日期': '2016-03-01',
          '著作权人': '上海汉得信息技术股份有限公司',
          '软件全称': '汉得投资管理软件',
          '软件简称': 'HIM',
        },
        {
          '_id': '56f2571d64151d26f6bf4805',
          '作品名称': '汉得固定资产管理软件',
          '公告日期': '2016-03-02',
          '公告类型': '计算机软件著作权登记公告',
          '分类号': '30200-8300',
          '版本号': 'V1.0',
          '登记号': '2016SR041455',
          '登记日期': '2016-03-01',
          '著作权人': '上海汉得信息技术股份有限公司',
          '软件全称': '汉得固定资产管理软件',
          '软件简称': 'HEAM',
        },
        {
          '_id': '56f2575564151d26f6bfa31f',
          '作品名称': '汉得供应链金融服务平台软件',
          '公告日期': '2015-12-17',
          '公告类型': '计算机软件著作权登记公告',
          '分类号': '30200-7100',
          '版本号': 'V1.0',
          '登记号': '2015SR263688',
          '登记日期': '2015-12-16',
          '著作权人': '上海汉得信息技术股份有限公司',
          '软件全称': '汉得供应链金融服务平台软件',
          '软件简称': 'HSCF',
          '首次发表日期': '2015-05-31',
        },
        {
          '_id': '56f2581e64151d26f6c1e72b',
          '作品名称': '汉得移动报销（安卓版）软件',
          '公告日期': '2015-01-09',
          '公告类型': '计算机软件著作权登记公告',
          '分类号': '30200-7400',
          '版本号': 'V1.0',
          '登记号': '2015SR003564',
          '登记日期': '2015-01-08',
          '著作权人': '上海汉得信息技术股份有限公司',
          '软件全称': '汉得移动报销（安卓版）软件',
          '软件简称': '移动报销',
          '首次发表日期': '2014-09-25',
        },
        {
          '_id': '56f2581e64151d26f6c1e75a',
          '作品名称': '汉得费控软件',
          '公告日期': '2015-01-09',
          '公告类型': '计算机软件著作权登记公告',
          '分类号': '30200-7400',
          '版本号': 'V3.0',
          '登记号': '2015SR003538',
          '登记日期': '2015-01-08',
          '著作权人': '上海汉得信息技术股份有限公司',
          '软件全称': '汉得费控软件',
          '软件简称': 'HEC',
          '首次发表日期': '2014-06-01',
        },
        {
          '_id': '56f2581e64151d26f6c1e719',
          '作品名称': '汉得物料主数据管理软件',
          '公告日期': '2015-01-09',
          '公告类型': '计算机软件著作权登记公告',
          '分类号': '30200-7400',
          '版本号': 'V1.0',
          '登记号': '2015SR003585',
          '登记日期': '2015-01-08',
          '著作权人': '上海汉得信息技术股份有限公司',
          '软件全称': '汉得物料主数据管理软件',
          '软件简称': 'HAND MDM System',
          '首次发表日期': '2014-02-15',
        },
      ],
      'total': 32,
    },
    'icpInfor': {
      'hits': [
        {
          '_id': '570e947c64151d26f61fa233',
          '主办单位名称': '上海汉得信息技术股份有限公司',
          '主办单位性质': '企业',
          '备案/许可证号': '沪ICP备14039535号',
          '审核通过时间': '2014-09-18',
          '网站名称': 'hand-china.com',
          '网站域名': [
            'hand-china.com',
          ],
          '网站备案/许可证号': '沪ICP备14039535号-1',
          '负责人姓名': '',
        },
      ],
      'total': 1,
    },
    'qsjlInfor': {
      'hits': [
        {
          '_id': '58c338251c306aa7233955f0',
          '公告类型': '催缴公告',
          '发布时间': '2016-02-06',
          '名称': '上海汉得信息技术股份有限公司',
          '法定代表人姓名': '范建震',
          '省份': '上海市',
          '税务机关': '上海市青浦区国家税务局',
          '税种': '增值税',
          '识别号': '31022974027295X',
          '高级税务机关': '上海市青浦区国家税务局',
        },
        {
          '_id': '58c3382a1c306aa72339632b',
          '公告类型': '催缴公告',
          '发布时间': '2016-02-06',
          '名称': '上海汉得信息技术股份有限公司',
          '法定代表人姓名': '范建震',
          '省份': '上海市',
          '税务机关': '上海市青浦区国家税务局',
          '税种': '增值税',
          '识别号': '31022974027295X',
          '高级税务机关': '上海市青浦区国家税务局',
        },
      ],
      'total': 2,
    },
    'ztbInfor': {
      'hits': [
        {
          '_id': '5915c1444aabffb6808605e4',
          '中标人': [],
          '代理机构': '河南招标采购服务有限公司',
          '候选人': [],
          '公告信息': {
            '中标日期': '2017年05月12日',
            '公告时间': '2017年05月12日  17:16',
            '品目': '',
            '总中标金额': '￥0 万元（人民币）',
            '本项目招标公告日期': '2017年05月12日',
            '行政区域': '河南省',
            '评审专家名单': '王志超、苏楠、吴云军',
            '采购单位': '中原农业保险股份有限公司',
            '采购项目名称': '中原农业保险股份有限公司费控系统建设采购项目结果公告',
          },
          '公告类型': '中标公告',
          '包': [
            '整包',
          ],
          '发布时间': '2017-05-12',
          '地区': '河南',
          '标题': '中原农业保险股份有限公司费控系统建设采购项目结果公告',
          '正文': '编号：HNZB[2017]N072号(公开改磋商)河南招标采购服务有限公司受中原农业保险股份有限公司的委托，就费控系统建设采购项目进行了竞争性磋商，按规定程序进行了开标，现就本次磋商项目的成交结果公布如下：一、磋商项目名称：中原农业保险股份有限公司费控系统建设采购项目二、磋商公告发出日期：2017年4月28日 三、磋商信息：磋商日期：2017年5月10日上午9:00磋商地点：河南招标采购服务有限公司评标会议室磋商小组成员：王志超、苏楠、吴云军四、中标信息：第一成交人：上海汉得信息技术股份有限公司, 中标金额为628000元人民币。成交人地址：上海市青浦工业园区外青松公路第二成交人：用友金融信息技术股份有限公司, 中标金额为580000元人民币。成交人地址：北京市海淀区北清路68号院五、本次磋商联系事项：采购单位：中原农业保险股份有限公司联系人：李其峰       联系电话：0371-56563769联系地址：郑州市郑东新区商务外环20号海联大厦采购代理机构：河南招标采购服务有限公司联系人：冯先生；        联系（传真）电话：0371-65950225 联系地址：郑州市纬四路13号（花园路与纬四路交叉口东50米路北）                      邮政编码：450003各有关当事人对成交结果有异议的，可以在成交公告发布之日起三天内，以书面形式同时向采购人和采购代理机构提出质疑(加盖单位公章且法人签字)，由法定代表人或其授权代表携带企业营业执照复印件（加盖公章）及本人身份证件（原件及复印件）一并提交（邮寄、传真件不予受理），并以质疑函接受确认日期作为受理时间。逾期未提交或未按照要求提交的质疑函将不予受理。请成交人速来我公司领取中标（成交）通知书。请未成交的投标人速到我公司办理保证金退还手续。                                   二〇一七年五月十二日',
          '联系人及联系方式': {
            '代理机构名称': '河南招标采购服务有限公司',
            '代理机构地址': '郑州市纬四路13号（花园路与纬四路交叉口东50米路北）',
            '代理机构联系方式': '0371-65950225',
            '采购单位': '中原农业保险股份有限公司',
            '采购单位地址': '郑州市郑东新区商务外环20号海联大厦',
            '采购单位联系方式': '0371-56563769',
            '项目联系人': '冯先生',
            '项目联系电话': '0371-65950225',
          },
          '采购人': [
            '中原农业保险股份有限公司',
          ],
          '采购品目': '',
        },
        {
          '_id': '59151a714aabffb6803bdc8e',
          '中标人': [],
          '候选人': [],
          '公告类型': '中标结果公告',
          '包': [
            '整包',
          ],
          '发布时间': '2017-05-11',
          '地区': '陕西省',
          '标题': '陕西黄河集团有限公司低空航空电子管理系统研制及产业化项目生产资源计划管理能力建设项目 中标候选人公示中标公告',
          '正文': '陕西黄河集团有限公司低空航空电子管理系统研制及产业化项目生产资源计划管理能力建设项目（招标编号：SCZC2017-ZB-297/6）评标工作已结束，经评委集体评审，推荐中标候选人为： 第一名 :上海汉得信息技术股份有限公司 第二名：西安尚俊信息技术有限公司 第三名：西安瑞科软件信息技术有限公司 本公示有效日期自即日起三天，如有异议请持有关材料与本项目招标代理机构联系。 招标代理机构：陕西省采购招标有限责任公司 电话： 029-85257505联系人：孟 凌、钟国红 二○一七年五月十一日',
          '采购人': [
            '',
          ],
        },
        {
          '_id': '59115b324aabffb680ae6061',
          '中标人': [],
          '代理机构': '吉林瑞成工程招标造价咨询有限公司',
          '候选人': [],
          '公告信息': {
            '公告时间': '2017年05月09日  11:33',
            '品目': '服务/其他服务',
            '总成交金额': '￥0 万元（人民币）',
            '成交日期': '2017年05月05日',
            '本项目招标公告日期': '2017年04月21日',
            '行政区域': '吉林省',
            '谈判小组、询价小组成员、磋商小组成员名单及单一来源采购人员名单': '-',
            '采购单位': '吉林省农村信用社联合社',
            '采购项目名称': '监管数据报送项目关联财务管理系统工程师外包服务',
          },
          '公告类型': '成交公告',
          '包': [
            '整包',
          ],
          '发布时间': '2017-05-09',
          '地区': '吉林',
          '标题': '吉林省农村信用社联合社监管数据报送项目关联财务管理系统工程师外包服务成交公告',
          '正文': '吉林瑞成工程招标造价咨询有限公司受吉林省农村信用社联合社的委托，就监管数据报送项目关联财务管理系统工程师外包服务项目（项目编号：JRC2017S118 (S01)）组织采购，评标工作已经结束，成交结果如下： 一、项目信息项目编号：JRC2017S118 (S01)项目名称：监管数据报送项目关联财务管理系统工程师外包服务项目联系人：吴工联系方式：0431-89668108 二、采购单位信息采购单位名称：吉林省农村信用社联合社采购单位地址：吉林省农村信用社联合社采购单位联系方式：联系人：吴工 电 话：0431-89668108 三、采购代理机构信息采购代理机构全称：吉林瑞成工程招标造价咨询有限公司采购代理机构地址：长春市前进大街2000号阳光大厦1208室采购代理机构联系方式：联系人：常延浩 电话：0431-85199868-805 四、成交信息招标文件编号：JRC2017S118 (S01)本项目招标公告日期：2017年04月21日成交日期：2017年05月05日总成交金额：0.0 万元（人民币） 成交供应商名称、地址及成交金额： 序号 成交供应商名称 成交供应商联系地址 成交金额(万元) 1 上海汉得信息技术股份有限公司 上海市青浦工业园区外青松公路5500号303室 0.0 谈判小组、询价小组、磋商小组成员名单及单一来源采购人员名单：- 五、项目用途、简要技术要求及合同履行日期：监管数据报送项目关联财务管理系统工程师外包服务成交结果公示 吉林瑞成工程招标造价咨询有限公司受吉林省农村信用社联合社的委托，代理“监管数据报送项目关联财务管理系统工程师外包服务”单一来源采购业务。该项目于2017年5月5日在吉林省农村信用社联合社（吉林省长春市人民大街7251号吉林农信大厦）谈判，现将预成交结果公布如下：    项目名称：监管数据报送项目关联财务管理系统工程师外包服务项目编号：JRC2017S118 (S01)预成交供应商单位名称：上海汉得信息技术股份有限公司 预成交供应商地址：上海市青浦工业园区外青松公路5500号303室预成交结果公示一天，在公示期间如果本项目的投标人对预成交结果有异议，请在公示期内以书面形式向监督部门提出质疑。公示期如无异议，招标人将向成交供应商发成交通知书。        采 购 人：吉林省农村信用社联合社联 系 人：吴工        联系电话：0431-89668108代理机构：吉林瑞成工程招标造价咨询有限公司办公地址：长春市前进大街2000号阳光大厦1208室联系人：常延浩       联系电话：0431-85199868-805 六、成交标的名称、规格型号、数量、单价、服务要求：监管数据报送项目关联财务管理系统工程师外包服务 七、其它补充事宜',
          '联系人及联系方式': {
            '代理机构名称': '吉林瑞成工程招标造价咨询有限公司',
            '代理机构地址': '长春市前进大街2000号阳光大厦1208室',
            '代理机构联系方式': '联系人：常延浩 电话：0431-85199868-805',
            '采购单位': '吉林省农村信用社联合社',
            '采购单位地址': '吉林省农村信用社联合社',
            '采购单位联系方式': '联系人：吴工     电  话：0431-89668108',
            '项目联系人': '吴工',
            '项目联系电话': '0431-89668108',
          },
          '采购人': [
            '吉林省农村信用社联合社',
          ],
          '采购品目': '服务/其他服务',
        },
        {
          '_id': '5908772f4aabffb680d37ffd',
          '中标人': [],
          '代理机构': '甘肃正信招标代理有限公司',
          '候选人': [],
          '公告信息': {
            '中标日期': '2017年04月13日',
            '公告时间': '2017年05月02日  16:05',
            '品目': '服务/金融服务/银行服务/其他银行服务',
            '总中标金额': '￥0 万元（人民币）',
            '本项目招标公告日期': '2017年03月27日',
            '行政区域': '甘肃省',
            '评审专家名单': '邢兆雄、胡仲奎、吕向前、刘建荣、张淑华、李亚立、梁楠、杜雅晶、魏君安、尹丹、王瑜婕',
            '采购单位': '甘肃银行股份有限公司',
            '采购项目名称': '甘肃银行股份有限公司反洗钱及反恐怖融资名单库及名单监控系统建设项目',
          },
          '公告类型': '中标公告',
          '包': [
            '二包',
            '一包',
          ],
          '发布时间': '2017-05-02',
          '地区': '甘肃',
          '标题': '甘肃银行股份有限公司反洗钱及反恐怖融资名单库及名单监控系统建设项目中标公告',
          '正文': '甘肃正信招标代理有限公司受甘肃银行股份有限公司的委托，就甘肃银行股份有限公司反洗钱及反恐怖融资名单库及名单监控系统建设项目项目（项目编号：GSZX2016-24GK-12163）组织采购，评标工作已经结束，中标结果如下： 一、项目信息项目编号：GSZX2016-24GK-12163项目名称：甘肃银行股份有限公司反洗钱及反恐怖融资名单库及名单监控系统建设项目项目联系人：张昕怡联系方式：0931-4104999 二、采购单位信息采购单位名称：甘肃银行股份有限公司采购单位地址：甘肃省兰州市城关区一只船北街525号甘肃银行大厦采购单位联系方式：李亚立 0931-8771827 三、项目用途、简要技术要求及合同履行日期：无 四、采购代理机构信息采购代理机构全称：甘肃正信招标代理有限公司采购代理机构地址：兰州市城关区永昌路与武都路什字西南角安泰大厦采购代理机构联系方式：张昕怡 0931-4104999 五、中标信息招标公告日期：2017年03月27日中标日期：2017年04月13日总中标金额：0.0 万元（人民币）中标供应商名称、联系地址及中标金额：第一包：上海汉得信息技术股份有限公司第二包：上海汉得信息技术股份有限公司 评审专家名单：邢兆雄、胡仲奎、吕向前、刘建荣、张淑华、李亚立、梁楠、杜雅晶、魏君安、尹丹、王瑜婕 中标标的名称、规格型号、数量、单价、服务要求：无 六、其它补充事宜',
          '联系人及联系方式': {
            '代理机构名称': '甘肃正信招标代理有限公司',
            '代理机构地址': '兰州市城关区永昌路与武都路什字西南角安泰大厦',
            '代理机构联系方式': '张昕怡 0931-4104999',
            '采购单位': '甘肃银行股份有限公司',
            '采购单位地址': '甘肃省兰州市城关区一只船北街525号甘肃银行大厦',
            '采购单位联系方式': '李亚立 0931-8771827',
            '项目联系人': '张昕怡',
            '项目联系电话': '0931-4104999',
          },
          '采购人': [
            '甘肃银行股份有限公司',
          ],
          '采购品目': '服务/金融服务/银行服务/其他银行服务',
        },
        {
          '_id': '5901f9081c306aa723733943',
          '中标人': [
            {
              '包': '整包',
              '名字': '上海汉得信息技术股份有限公司',
              '排名': 0,
            },
          ],
          '代理机构': '吉林瑞成工程招标造价咨询有限公司',
          '候选人': [],
          '公告信息': {
            '公告时间': '2017年04月21日  08:35',
            '品目': '服务/其他服务',
            '行政区域': '吉林省',
            '采购单位': '吉林省农村信用社联合社',
            '采购项目名称': '监管数据报送项目关联财务管理系统工程师外包服务',
            '预算金额': '￥0万元（人民币）',
          },
          '公告类型': '单一来源公告',
          '包': [
            '整包',
          ],
          '发布时间': '2017-04-21',
          '地区': '吉林',
          '标题': '吉林省农村信用社联合社监管数据报送项目关联财务管理系统工程师外包服务单一来源公告',
          '正文': '吉林瑞成工程招标造价咨询有限公司受吉林省农村信用社联合社委托，根据《中华人民共和国政府采购法》等有关规定，现对监管数据报送项目关联财务管理系统工程师外包服务进行单一来源招标，欢迎合格的供应商前来投标。 项目名称：监管数据报送项目关联财务管理系统工程师外包服务项目编号：JRC2017S118 (S01)项目联系方式：项目联系人：吴工项目联系电话：0431-89668108 采购单位联系方式：采购单位：吉林省农村信用社联合社采购单位地址：吉林省农村信用社联合社采购单位联系方式：联系人：吴工 电 话：0431-89668108 代理机构联系方式：代理机构：吉林瑞成工程招标造价咨询有限公司代理机构联系人：联系人：常延浩 电话：0431-85199868-805代理机构地址： 长春市前进大街2000号阳光大厦1208室   一、拟采购的货物或者服务的说明:1.采购内容：技术人员服务等。2.服务范围：根据吉林农信项目建设需要，提供关联财务管理系统关联改造及系统维护服务。3.服务周期：有效期至2019年6月30日。 二、采用单一来源采购方式的原因及相关说明:本次采购的监管数据报送项目关联财务管理系统工程师外包服务，上海汉得信息技术股份有限公司为系统原建厂商，本次采购内容属于在原系统平台上进行优化升级改造，确保与原系统平稳对接，保障生产系统安全稳定运行，拟采购原厂实施服务。 三、开标时间： 四、拟定的唯一供应商名称及其地址：供应商名称：上海汉得信息技术股份有限公司地址：上海市 五、其它补充事宜监管数据报送项目关联财务管理系统工程师外包服务单一来源采购公示项目编号：JRC2017S118 (S01) 一、采购人名称：吉林省农村信用社联合社。二、采购项目名称：监管数据报送项目关联财务管理系统工程师外包服务三、拟采购内容及说明：1.采购内容：技术人员服务等。2.服务范围：根据吉林农信项目建设需要，提供关联财务管理系统关联改造及系统维护服务。3.服务周期：有效期至2019年6月30日。四、采用单一来源采购方式的原因及相关说明：本次采购的监管数据报送项目关联财务管理系统工程师外包服务，上海汉得信息技术股份有限公司为系统原建厂商，本次采购内容属于在原系统平台上进行优化升级改造，确保与原系统平稳对接，保障生产系统安全稳定运行，拟采购原厂实施服务。 供应商名称：上海汉得信息技术股份有限公司地址：上海市 五、公示时间2017年4月21日至2017年4月27日。任何供应商、单位或者个人对采用单一来源采购方式公示有异议的，可以在公示期内将书面意见反馈到监督部门。六、联系事项：采购人：吉林省农村信用社联合社联系人：吴工                电  话：0431-89668108招标代理机构：吉林瑞成工程招标造价咨询有限公司地址：长春市前进大街2000号阳光大厦1208室联系人：常延浩 电话：0431-85199868-805 六、预算金额预算金额：0.0 万元（人民币）',
          '联系人及联系方式': {
            '代理机构名称': '吉林瑞成工程招标造价咨询有限公司',
            '代理机构地址': '长春市前进大街2000号阳光大厦1208室',
            '代理机构联系方式': '联系人：常延浩 电话：0431-85199868-805',
            '采购单位': '吉林省农村信用社联合社',
            '采购单位地址': '吉林省农村信用社联合社',
            '采购单位联系方式': '联系人：吴工     电  话：0431-89668108',
            '项目联系人': '吴工',
            '项目联系电话': '0431-89668108',
          },
          '采购人': [
            '吉林省农村信用社联合社',
          ],
          '采购品目': '服务/其他服务',
        },
        {
          '_id': '58cb55651c306aa723fa6a20',
          '中标人': [],
          '候选人': [
            {
              '包': '整包',
              '名字': '上海汉得信息技术股份有限公司',
              '排名': 1,
            },
            {
              '包': '整包',
              '名字': '金蝶软件',
              '排名': 2,
            },
            {
              '包': '整包',
              '名字': '陕西思宇信息技术股份有限公司',
              '排名': 3,
            },
          ],
          '公告类型': '中标结果公告',
          '包': [
            '整包',
          ],
          '发布时间': '2017-03-17',
          '地区': '陕西省',
          '标题': '陕西钢铁集团有限公司 陕西钢铁集团ERP系统软件采购 中 标 公 示 单中标公告',
          '正文': '陕西钢铁集团有限公司 陕西钢铁集团 ERP系统软件采购 中 标 公 示 单 陕西钢铁集团ERP系统软件采购（招标编号： 0866-16B2SXQY218），开评标工作于 2017年 3月 14日完成，现根据评标委员会递交的评标报告将评标结果予以公示。公示发布媒体为：陕西省招投标协会网 http://www.sntba.com/ 公示时间自 2017年 3月 17日开始，公示三天。 中标侯选人： 第一名 ： 上海汉得信息技术股份有限公司 第二名 ： 金蝶软件（中国）有限公司 第三名 ： 陕西思宇信息技术股份有限公司 有关单位对此结果如有异议，请在公示时间内向本项目监督机构、招标人及招标代理单位反映，过期不再受理。 招标人：陕西钢铁集团有限公司 详细地址：陕西省西安市二环北路西段 5号禹龙国际酒店 708室 联系人：严工 电话： 029-68515026 招标代理单位：陕西秦源招标有限责任公司 联 系 人：刘工 乔工 联系电话： 029-81615623 地 址：西安市自强西路 38号梅苑温泉小区东院南楼 311室 监督（质疑）电话： 029-81613218',
          '采购人': [
            '',
          ],
        },
        {
          '_id': '5902413b1c306aa723dce2ed',
          '中标人': [
            {
              '包': '整包',
              '名字': '上海汉得信息技术股份有限公司',
              '排名': 0,
            },
          ],
          '代理机构': '北京中教仪国际招标代理有限公司',
          '候选人': [],
          '公告信息': {
            '中标日期': '2017年03月03日',
            '公告时间': '2017年03月03日  17:57',
            '品目': '服务/信息技术服务/软件开发服务/应用软件开发服务/行业应用软件开发服务,服务/信息技术服务/软件开发服务/应用软件开发服务/通用应用软件开发服务',
            '总中标金额': '￥565 万元（人民币）',
            '本项目招标公告日期': '2017年02月10日',
            '行政区域': '北京市',
            '评审专家名单': '赵莹、樊雁翔、黄鹏、邹自明、常秋明、焦晓菊、张艳丽',
            '采购单位': '中国教学仪器设备有限公司',
            '采购项目名称': '中国教学仪器设备有限公司教仪资源中心信息化建设项目',
          },
          '公告类型': '中标公告',
          '包': [
            '整包',
          ],
          '发布时间': '2017-03-03',
          '地区': '北京',
          '标题': '中国教学仪器设备有限公司教仪资源中心信息化建设项目中标公告',
          '正文': '北京中教仪国际招标代理有限公司受中国教学仪器设备有限公司的委托，就中国教学仪器设备有限公司教仪资源中心信息化建设项目项目（项目编号：CEIECZB01-17XJ024）组织采购，评标工作已经结束，中标结果如下： 一、项目信息项目编号：CEIECZB01-17XJ024项目名称：中国教学仪器设备有限公司教仪资源中心信息化建设项目项目联系人：谢杰、刘思远、施歌联系方式：010-59893114、59893118、59893131 二、采购单位信息采购单位名称：中国教学仪器设备有限公司采购单位地址：北京市西城区大木仓胡同北一巷1号采购单位联系方式：sinron113@163.com 三、项目用途、简要技术要求及合同履行日期：1.采购用途：用于公司信息化建设。2.项目简要技术要求：本项目采用的系统应为先进、成熟的软件，进行的相关开发也应经过完善的设计和充分的测试运行，具备在较长时间内连续无故障的运行能力。3.合同履行日期：合同签订后即刻开始履行。 四、采购代理机构信息采购代理机构全称：北京中教仪国际招标代理有限公司采购代理机构地址：北京市海淀区文慧园北路10号院内，北师大加油站北侧，北京中教仪国际招标代理有限公司603室采购代理机构联系方式：010-59893114、59893118、59893131 五、中标信息招标公告日期：2017年02月10日中标日期：2017年03月03日总中标金额：565.0 万元（人民币）中标供应商名称、联系地址及中标金额： 序号 中标供应商名称 中标供应商联系地址 中标金额(万元) 1 上海汉得信息技术股份有限公司 北京市朝阳区建国路乙118号京汇大厦1801室 565.0  评审专家名单：赵莹、樊雁翔、黄鹏、邹自明、常秋明、焦晓菊、张艳丽 中标标的名称、规格型号、数量、单价、服务要求：1.主要中标标的名称：中国教学仪器设备有限公司教仪资源中心信息化建设2.规格型号：无3.数量：1套4.单价：¥5,650,000.00元5.服务要求：完成整个系统的详细设计，组织系统实施和后期运维。 六、其它补充事宜1.公告期限：自公告发布之日起1个工作日2.未中标供应商请在本中标公告发出后五个工作日内前往我公司领取未成交通知书，同时凭保证金收据或电汇凭证办理退还保证金等事宜。',
          '联系人及联系方式': {
            '代理机构名称': '北京中教仪国际招标代理有限公司',
            '代理机构地址': '北京市海淀区文慧园北路10号院内，北师大加油站北侧，北京中教仪国际招标代理有限公司603室',
            '代理机构联系方式': '010-59893114、59893118、59893131',
            '采购单位': '中国教学仪器设备有限公司',
            '采购单位地址': '北京市西城区大木仓胡同北一巷1号',
            '采购单位联系方式': 'sinron113@163.com',
            '项目联系人': '谢杰、刘思远、施歌',
            '项目联系电话': '010-59893114、59893118、59893131',
          },
          '采购人': [
            '中国教学仪器设备有限公司',
          ],
          '采购品目': '服务/信息技术服务/软件开发服务/应用软件开发服务/行业应用软件开发服务,服务/信息技术服务/软件开发服务/应用软件开发服务/通用应用软件开发服务',
        },
        {
          '_id': '58011cd708e3020b621e9969',
          '中标人': [],
          '候选人': [],
          '公告类型': '招标公告',
          '包': [],
          '发布时间': '2016-09-13',
          '地区': '河南省',
          '标题': '中原农业保险股份有限公司财务和实物资产系统三期开发运维单一来源采购公示',
          '正文': '中原农业保险股份有限公司财务和实物资产系统三期开发运维申请采用单一来源方式采购，现公示如下： 一、拟选定单一采购单位 上海汉得信息技术股份有限公司 二、项目基本情况 中原农业保险股份有限公司财务和实物资产系统项目已由上海汉得信息技术股份有限公司一期组织系统开发工作并提供二期开发运维服务，依据中原农业保险股份有限公司信息化建设需求，三期系统开发运维项目进行单一来源采购。 三、单一来源原因及相关说明 中原农业保险股份有限公司财务和实物资产系统一期是通过由上海汉得信息技术股份有限公司开发实施的，根据合同要求，双方共同开发部分知识产权归双方共有。上海汉得信息技术股份有限公司技术人员对系统比较熟悉，且具有丰富的开发经验、较强的业务能力和技术能力，且已经为我公司提供半年开发运维服务。该公司具备为我公司持续提供高质量开发、运维服务的能力。为满足工作要求。需要对一期财务和实物资产系统进行软件开发、升级改造及系统运维等相关技术工作，因三期开发需要采用相同的技术及数据，为节约资金，拟采用单一来源方式采购。 公示期限从 2016年 9月 13日起 至 2016年 9月 20日 止。 潜在供应商对公示内容有异议的，请于公示期满后 2个工作日内以实名书面形式将意见反馈至河南招标采购服务有限公司（联系电话： 0371-65950225；联系人：冯先生） 附件： 专家论证意见表',
          '采购人': [
            '',
          ],
        },
        {
          '_id': '57d0c84708e3020b62e182f4',
          '中标人': [
            {
              '包': '整包',
              '名字': '上海汉得信息技术股份有限公司',
              '排名': 0,
            },
            {
              '包': '整包',
              '名字': '上海汉得信息技术股份有限公司',
              '排名': 0,
            },
            {
              '包': '整包',
              '名字': '上海汉得信息技术股份有限公司',
              '排名': 0,
            },
          ],
          '候选人': [
            {
              '包': '整包',
              '名字': '上海汉得信息技术股份有限公司',
              '排名': 0,
            },
            {
              '包': '整包',
              '名字': '深圳市宁远科技股份有限公司',
              '排名': 0,
            },
            {
              '包': '整包',
              '名字': '深圳市蓝凌软件股份有限公司',
              '排名': 0,
            },
          ],
          '公告类型': '中标结果公告',
          '包': [
            '整包',
          ],
          '发布时间': '2016-09-07',
          '地区': '广东省',
          '标题': '人力资源管理系统采购项目（重新招标）中标公告',
          '正文': '深圳市振东招标代理有限公司受--的委托，就人力资源管理系统采购项目（重新招标）项目（项目编号：0868-1642ZD241F-D）组织采购，评标工作已经结束，中标结果如下： 一、项目信息 项目编号：0868-1642ZD241F-D 项目名称：人力资源管理系统采购项目（重新招标） 项目联系人：刘小姐 联系方式：0755-82786018/82786038-808 二、采购单位信息 采购单位名称：-- 采购单位地址：-- 采购单位联系方式：-- 三、项目用途、简要技术要求及合同履行日期： 中标公告 深圳市振东招标代理有限公司（以下简称“采购代理机构”）受深圳市政府采购中心的委托，就 人力资源管理系统采购项目（重新招标）（招标编号: 0868-1642ZD241F-D）进行公开招标，经审核评标委员会评审意见，并经采购人确认，现将评标结果公布如下： 一、投标报价及资格核查 序号 投标人名称 投标报价（元) 资格核查 1 上海汉得信息技术股份有限公司 ￥1,900,000.00 合格 2 深圳市宁远科技股份有限公司 ￥1,910,000.00 合格 3 深圳市蓝凌软件股份有限公司 ￥1,907,000.00 合格 二、候选中标供应商名单 1、上海汉得信息技术股份有限公司 2、深圳市宁远科技股份有限公司 三、确定中标供应商 中标供应商 上海汉得信息技术股份有限公司 中标金额 人民币壹佰玖拾万圆整（￥1,900,000.00 ） 四、评标委员会成员： 程德远 孙富国 朱冬范 胡建军 熊庆锋 五、 招标代理机构联系方式： 项目联系人：刘小姐 联系方式：0755-82786018/82786038-808                   现就上述评审结果予以公示，公示期为三天。 二〇一六年九月七日 四、采购代理机构信息 采购代理机构全称：深圳市振东招标代理有限公司 采购代理机构地址：深圳市罗湖区红宝路京基金融中心D座（蔡屋围金龙大厦）10楼03号 采购代理机构联系方式：刘小姐 0755-82786018/82786038-808 五、中标信息 招标公告日期：2016年08月19日 中标日期：2016年08月31日 总中标金额： 190.0 万元（人民币） 中标供应商名称、联系地址及中标金额： 三、确定中标供应商 中标供应商 上海汉得信息技术股份有限公司 中标金额 人民币壹佰玖拾万圆整（￥1,900,000.00 ） 评审专家名单： 程德远 孙富国 朱冬范 胡建军 熊庆锋 中标标的名称、规格型号、数量、单价、服务要求： 中标公告 深圳市振东招标代理有限公司（以下简称“采购代理机构”）受深圳市政府采购中心的委托，就 人力资源管理系统采购项目（重新招标）（招标编号: 0868-1642ZD241F-D）进行公开招标，经审核评标委员会评审意见，并经采购人确认，现将评标结果公布如下： 六、其它补充事宜',
          '采购人': [
            '',
          ],
        },
        {
          '_id': '57902ca9f475b0c270c2a8d0',
          '中标人': [],
          '候选人': [],
          '公告类型': '中标结果公告',
          '包': [],
          '发布时间': '2016-07-21',
          '地区': '陕西省',
          '标题': '西安西电变压器有限责任公司超（特）高压变压器智能制造数字化车间项目 产品质量全生命周期管理系统中标公告',
          '正文': '招标结果公示 项目名称 西安西电变压器有限责任公司超（特）高压变压器智能制造数字化车间项目 产品质量全生命周期管理系统 招标编号 0617-16210471 招标人 西安西电变压器有限责任公司 招标代理机构 西北(陕西)国际招标有限公司 公示时间 2016年7月21日 评标结果 序号 货物名称 中标候选人排序 1 产品质量全生命周期管理系统 1、北京神舟航天软件技术有限公司 2、上海汉得信息技术股份有限公司 3、华存数据信息技术有限公司 注： 一、公示期为3日，若有异议，须在公示期内，提交投诉书。 投诉书应当包括下列内容：（一）投诉人的名称、地址及有效联系方式；（二）被投诉人的名称、地址及有效联系方式；（三）投诉事项的基本事实；（四）相关请求及主张；（五）有效线索和相关证明材料。投诉书必须由其法定代表人或者授权代表签字并加盖单位公章。 二、联系方式 西北（陕西）国际招标有限公司 监督管理处 电话：029-85362812',
          '采购人': [
            '',
          ],
        },
      ],
      'total': 33,
    },
  },

  // 工商资料
  businessInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'business_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.businessInfor = res
      } else {
        hlsPopup.showLongBottom('信息获取失败!')
      }
    })
  },

  // 主要成员
  companyNumber: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'company_number'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.companyNumber = res
      }
    })
  },

  // 股东信息  p3
  investorInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'investor_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.investorInfor = res
      }
    })
  },
  // 对外投资  p4
  investmentInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'investment_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.investmentInfor = res
      }
    })
  },
  // 年报   p5
  nianbaoInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'nianbao_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.nianbaoInfor = res
      }
    })
  },
  // 工商变更  p6
  gsbgInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'gsbg_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.gsbgInfor = res
      }
    })
  },
  // 动产抵押  p7
  dcdyInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'dcdy_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.dcdyInfor = res
      }
    })
  },
  // 股权出质 p8
  gqczInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'gqcz_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.gqczInfor = res
      }
    })
  },
  // 行政处罚  p9
  xzcfInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'xzcf_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.xzcfInfor = res
      }
    })
  },
  // 欠税记录 p10
  qsjlInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'qsjl_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.qsjlInfor = res
      }
    })
  },
  // 税务非正常户 p11
  swfzchInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'swfzch_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.swfzchInfor = res
      }
    })
  },
  // 经营异常 p12
  jyycInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'jyyc_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.jyycInfor = res
      }
    })
  },
  // 开庭公告 p13
  ktggInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'ktgg_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.ktggInfor = res
      }
    })
  },
  // 裁判文书 p14
  cpwsInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'cpws_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.cpwsInfor = res
      }
    })
  },
  // 司法协助 p15
  sfxzInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'sfxz_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.sfxzInfor = res
      }
    })
  },
  // 执行记录 p16
  zhixingInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'zhixing_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.zhixing_infor = res
      }
    })
  },
  // 失信被执行人  p17
  shixinInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'shixin_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.shixinInfor = res
      }
    })
  },
  // 涉诉公告 p18
  ssggInfo: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'ssgg_info'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.ssggInfo = res
      }
    })
  },
  // 专利   p19
  patentInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'patent_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.patentInfor = res
      }
    })
  },
  // 著作权  p20
  zzqInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'zzq_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.zzqInfor = res
      }
    })
  },
  // ICP备案信息   p21
  icpInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'icp_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.icpInfor = res
      }
    })
  },
  // 招投标  p22
  ztbInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'ztb_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.ztbInfor = res
      }
    })
  },
  // 土地信息  p23
  tudiInfor: function (companyOrg) {
    let param = {
      'companyOrg': companyOrg, 'apikey': $config.riskKey,
    }
    let url = $config.riskPath + 'tudi_infor'
    return hlsHttp.post(url, param).then(res => {
      if (!res.message) {
        this.riskInfo.tudiInfor = res
      }
    })
  },
  // 风暴信息查询
  getRiskList: function () {
  //  if ($config.debug) {
    return this.testInfo
  //  } else {
  //    return this.riskInfo
  //  }
  },

  getTabList: function () {
    return this.tabList
  },

  setCompanyName (name) {
    this.companyName = name
  },
  getCompanyName () {
    return this.companyName
  },
  setOrganizationCode (code) {
    this.organizationCode = name
  },
  getOrganizationCode () {
    return this.organizationCode
  },

}
