export default {

  calc: {
    balloon_ratio_from: null,
    customer_ratio: null,
    deposit_ratio_from: null,
    discount_method: null,
    down_payment_ratio_from: null,
    down_payment_ratio_to: null,
    gps_install_flag: null,
    lease_charge_ratio: null,
    pay_type: null,
    price_list: null,
    product_code: null,
    product_name: null,
    product_name_write: null,
    product_plan_id: null,
    product_type: null,
    special_note: null,
    times: null,
    times_from: null,
    times_to: null,
    to_grant: null,
    invoice_price: null,
    annual_pay_times_n: '月', // 还款频率
    annual_pay_times: 12, // 还款频率
    lease_charge: 0, // 手续费
    insurance_price: 0, // 保险费
    gps_amount: 0, // GPS费
    travel_tax: 0, // 车船税
    purchase_tax: 0, // 购置税
    result: {}, // 全部结果集
  },

  setCalc (calc) {
    this.calc = Object.assign(this.calc, calc)
  },

  getCalc () {
    return this.calc
  },

  cleanCalc () {
    for (let key in this.calc) {
      this.calc[key] = ''
    }
  },

  setResult (result) {
    this.calc.result = result
  },

  getResult () {
    return this.calc.result
  },

  /**
   *
   * @param invoic  车价款
   * @param pay_times 还款频率
   * @param lease_times  期限
   * @param int_rato  年利率
   * @param down_payment_ratio  首付比例
   * @param balloon_ratio  尾款比例
   * @param deposit_ratio  保证金比例
   * @param lease_charge  手续费
   * @param insurance_price  保险费
   * @param gps_amount  GPS费
   * @param travel_tax  车船税
   * @param gz  购置税
   * @param pay_type  付款方式
   */
  calcQuotation: function (invoic, payTimes, leaseTimes, intRato, downPaymentRatio, balloonRatio, depositRatio, leaseCharge, insurancePrice, gpsAmount, travelTax,
                           gz, payType) {
    invoic = parseFloat(invoic)
    leaseCharge = parseFloat(leaseCharge)
    insurancePrice = parseFloat(insurancePrice)
    gpsAmount = parseFloat(gpsAmount)
    travelTax = parseFloat(travelTax)
    gz = parseFloat(gz)
    if (!leaseCharge) {
      leaseCharge = 0
    } else if (!insurancePrice) {
      insurancePrice = 0
    } else if (!gpsAmount) {
      gpsAmount = 0
    } else if (!travelTax) {
      travelTax = 0
    } else if (!gz) {
      gz = 0
    }
    // 首付金额  融资额  尾付款  保证金 月供 首次支付
    let result = {
      down_payment: 0, finance_amount: 0, balloon: 0, deposit: 0, mouth_rental: 0, first_amount: 0, cash_flows: [],
    }
    let cashFlows = result.cash_flows
    result.lease_charge = leaseCharge
    result.down_payment = hlsUtil.toDecimal((invoic * downPaymentRatio))
    result.finance_amount = hlsUtil.toDecimal((invoic - result.down_payment + leaseCharge + insurancePrice + gpsAmount + travelTax + gz))
    result.balloon = hlsUtil.toDecimal((invoic * balloonRatio))
    result.deposit = hlsUtil.toDecimal(((invoic + leaseCharge + insurancePrice + gpsAmount + travelTax + gz) * depositRatio))
    result.mouth_rental = hlsUtil.toDecimal(hlsUtil.PMT(intRato / payTimes, leaseTimes, -(result.finance_amount), 0, 0))
    // result.mouth_rental = 2113.9;
    result.first_amount = hlsUtil.toDecimal((result.down_payment + result.deposit + leaseCharge + insurancePrice + gpsAmount + travelTax))

    // 剩余本金
    let outstandingPrincipal

    for (let i = 0; i <= leaseTimes; i++) {
      // 每期现金流
      let cashFlow = {
        time: 0,
        due_amount: 0,
        principal: 0,
        interest: 0,
        outstanding_principal: 0,
      }
      // 期数
      cashFlow.time = i
      if (i === 0) {
        outstandingPrincipal = result.finance_amount
        cashFlow.outstanding_principal = outstandingPrincipal
      } else if (i > 0 && i < leaseTimes) {
        // 租金
        cashFlow.due_amount = result.mouth_rental
        // 利息
        cashFlow.interest = hlsUtil.toDecimal(outstandingPrincipal * (intRato / payTimes))
        // 本金
        cashFlow.principal = hlsUtil.toDecimal((cashFlow.due_amount - cashFlow.interest))

        outstandingPrincipal = hlsUtil.toDecimal((outstandingPrincipal - cashFlow.principal))
        cashFlow.outstanding_principal = outstandingPrincipal
      } else {
        cashFlow.due_amount = result.mouth_rental
        cashFlow.principal = outstandingPrincipal
        cashFlow.interest = hlsUtil.toDecimal((cashFlow.due_amount - cashFlow.principal))
      }
      cashFlows.push(cashFlow)
    }
    return result
  },

}
