const path = require('path')
const fs = require('fs')

const {
  sortDependencies,
  installDependencies,
  printMessage,
} = require('./utils')


module.exports = {
  helpers: {},
  prompts: {
    name: {
      type: 'string',
      required: true,
      message: 'Project name',
    },
    description: {
      type: 'string',
      required: false,
      message: 'Project description',
      default: 'A Vue.js project',
    },
    author: {
      type: 'string',
      message: 'Author',
    },
    bp:{
      type: 'confirm',
      message: 'install partner modules in App?',
    },
    project:{
      type: 'confirm',
      message: 'install project modules in App?',
    },
    contract:{
      type: 'confirm',
      message: 'install contract modules in App?',
    },
    wfl:{
      type: 'confirm',
      message: 'install workflow modules in App?',
    },
    /*calculate:{
      type: 'confirm',
      message: 'install calculate modules in App?',
    },*/
    riskstrom:{
      type: 'confirm',
      message: 'install riskstrom modules in App?',
    },
    robot:{
      type: 'confirm',
      message: 'install robot modules in App?',
    },
    esign:{
      type: 'confirm',
      message: 'install esign modules in App?',
    },
    report:{
      type: 'confirm',
      message: 'install report modules in App?',
    },
    qixin:{
      type: 'confirm',
      message: 'install QiXinBao modules in App?',
    },
    ocr:{
      type: 'confirm',
      message: 'install ocr modules in App?',
    },
    autoInstall: {
      type: 'list',
      message:
        'Should we run `yarn install` for you after the project has been created? (recommended)',
      choices: [
        {
          name: 'Yes, use Yarn',
          value: 'yarn',
          short: 'yarn',
        },
        {
          name: 'No, I will handle that myself',
          value: false,
          short: 'no',
        },
      ],
    },
  },
  filters: {
    'src/pages/applications/partnerManager/**/*': 'bp',
    'src/pages/applications/projectManager/**/*': 'project',
    'src/pages/applications/contractMainten/**/*': 'contract',
    'src/pages/applications/contractSign/**/*': 'contract',
    'src/components/Contract/**/*': 'contract',
    'src/pages/applications/workflow/**/*': 'wfl',
    'src/pages/applications/financCalculate/**/*': 'project',
    'src/pages/applications/riskStorm/**/*': 'riskstrom',
    'src/pages/applications/robot/**/*': 'robot',
    'src/pages/applications/esign/**/*': 'esign',
    'src/pages/applications/reports/**/*': 'report',
    'src/pages/applications/qiXinBao/**/*': 'qixin',
    'src/pages/applications/ocrIdentify/**/*': 'ocr'
  },
  complete(data, { chalk }) {
    const green = chalk.green

    sortDependencies(data, green)

    const cwd = path.join(process.cwd(), data.inPlace ? '' : data.destDirName)

    if (data.autoInstall) {
      installDependencies(cwd, data.autoInstall, green)
     .then(() => {
        printMessage(data, green)
      })
    .catch(e => {
        console.log(chalk.red('Error:'), e)
      })
    } else {
      printMessage(data, chalk)
    }
  },
}
