'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _remove2 = require('lodash/remove');

var _remove3 = _interopRequireDefault(_remove2);

var _desc, _value, _class, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9;

var _mobx = require('mobx');

var _reactRouterCacheRoute = require('react-router-cache-route');

var _axios = require('../components/axios');

var _axios2 = _interopRequireDefault(_axios);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _initDefineProp(target, property, descriptor, context) {
  if (!descriptor) return;
  Object.defineProperty(target, property, {
    enumerable: descriptor.enumerable,
    configurable: descriptor.configurable,
    writable: descriptor.writable,
    value: descriptor.initializer ? descriptor.initializer.call(context) : void 0
  });
}

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

function _initializerWarningHelper(descriptor, context) {
  throw new Error('Decorating class property failed. Please ensure that transform-class-properties is enabled.');
}

function getNodePath(node, treeNodes) {
  if (node.children) {
    node.children.forEach(function (child) {
      return getNodePath(child, treeNodes);
    });
  } else {
    treeNodes.push(node);
  }
}

var MenuStore = (_class = function () {
  function MenuStore() {
    (0, _classCallCheck3['default'])(this, MenuStore);

    _initDefineProp(this, 'collapsed', _descriptor, this);

    _initDefineProp(this, 'menus', _descriptor2, this);

    _initDefineProp(this, 'tabs', _descriptor3, this);

    _initDefineProp(this, 'openKeys', _descriptor4, this);

    _initDefineProp(this, 'selectedKeys', _descriptor5, this);

    _initDefineProp(this, 'activeMenu', _descriptor6, this);

    _initDefineProp(this, 'contentKeys', _descriptor7, this);

    _initDefineProp(this, 'expanded', _descriptor8, this);

    _initDefineProp(this, 'history', _descriptor9, this);
  }

  (0, _createClass3['default'])(MenuStore, [{
    key: 'setContentKey',
    value: function setContentKey(pathname, key) {
      (0, _mobx.set)(this.contentKeys, pathname, key);
      return key;
    }
  }, {
    key: 'setCollapsed',
    value: function setCollapsed(data) {
      this.collapsed = data;
    }
  }, {
    key: 'setTabs',
    value: function setTabs(data) {
      this.tabs = data;
    }
  }, {
    key: 'setMenus',
    value: function setMenus(data) {
      this.menus = data;
    }
  }, {
    key: 'setActiveMenu',
    value: function setActiveMenu(data) {
      this.activeMenu = data;
    }
  }, {
    key: 'setOpenKeys',
    value: function setOpenKeys(data) {
      this.openKeys = data;
    }
  }, {
    key: 'setSelectedKeys',
    value: function setSelectedKeys(data) {
      this.selectedKeys = data;
    }
  }, {
    key: 'setMenuExpanded',
    value: function setMenuExpanded(data) {
      this.expanded = data;
    }
  }, {
    key: 'setHistory',
    value: function setHistory(data) {
      this.history = data;
    }
  }, {
    key: 'closeTab',
    value: function closeTab(value) {
      var prop = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'functionCode';

      var tabs = this.tabs.slice();
      (0, _remove3['default'])(tabs, function (v) {
        return v[prop] === value;
      });
      this.setTabs(tabs);
    }
  }, {
    key: 'clearCacheByCacheKey',
    value: function clearCacheByCacheKey(cacheKey) {
      (0, _reactRouterCacheRoute.dropByCacheKey)(cacheKey);
    }
  }, {
    key: 'closeTabAndClearCacheByCacheKey',
    value: function closeTabAndClearCacheByCacheKey(obj, remainTab) {
      var val = void 0;
      var prop = void 0;
      if (obj.symbol === 'REACT') {
        val = obj.url;
        prop = 'url';
      } else {
        val = obj.functionCode;
        prop = 'functionCode';
      }
      if (!remainTab) {
        this.closeTab(val, prop);
      }
      if (obj.symbol === 'REACT') {
        var existKeys = (0, _reactRouterCacheRoute.getCachingKeys)();
        if (existKeys.includes(obj.url)) {
          (0, _reactRouterCacheRoute.dropByCacheKey)(obj.url);
        } else if (existKeys.includes('/' + obj.url)) {
          (0, _reactRouterCacheRoute.dropByCacheKey)('/' + obj.url);
        }
      }
      // dropByCacheKey(obj.functionCode);
    }
  }, {
    key: 'getSubmenuByCode',
    value: function getSubmenuByCode(code) {
      var menus = this.getMenus;
      var target = {};
      menus.forEach(function (submenu) {
        if (submenu && submenu.children.length) {
          submenu.children.forEach(function (menuList) {
            if (menuList.functionCode === code) {
              target = submenu;
            }
          });
        }
      });
      return target;
    }

    /* eslint-disable */

  }, {
    key: 'getPathById',
    value: function getPathById(functionCode, tree, type, cb) {
      var noMatchCb = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : function () {};

      var key = type === 'HTML' ? 'functionCode' : 'url';
      // const key = isReact ? 'url' : 'functionCode';
      var path = [];
      var targetNode = void 0;
      try {
        var _getNodePath = function _getNodePath(node) {
          path.push(node.functionCode);

          if (node[key] === functionCode) {
            targetNode = node;
            throw 'Get Target Node!';
          }
          if (node.children && node.children.length > 0) {
            for (var i = 0; i < node.children.length; i++) {
              _getNodePath(node.children[i]);
            }
            path.pop();
          } else {
            path.pop();
          }
        };

        tree.forEach(function (v) {
          return _getNodePath(v);
        });
        noMatchCb();
      } catch (e) {
        cb(path, targetNode);
      }
    }

    // getTreeNodeMenus(tree, cb, key = 'functionCode') {
    //   const treeNodes = [];
    //   try {
    //     function getNodePath(node) {
    //       if (!node.children) {
    //         treeNodes.push(node);
    //       }
    //
    //       if (node.children && node.children.length > 0) {
    //         for (let i = 0; i < node.children.length; i++) {
    //           getNodePath(node.children[i]);
    //         }
    //       }
    //     }
    //     tree.forEach(v => getNodePath(v));
    //     cb(treeNodes);
    //   } catch (e) {
    //   }
    // }
    /* eslint-enable */

  }, {
    key: 'getMenuItemByCode',
    value: function getMenuItemByCode(code) {
      var menus = this.getMenus;
      var target = {};
      menus.forEach(function (submenu) {
        if (submenu && submenu.children.length) {
          submenu.children.forEach(function (menuList) {
            if (menuList.functionCode === code) {
              target = menuList;
            }
          });
        }
      });
      return target;
    }
  }, {
    key: 'getNextTab',
    value: function getNextTab(tab) {
      var tabs = this.getTabs;
      var len = tabs.length;
      var idx = tabs.findIndex(function (t) {
        return t.functionCode === tab.functionCode;
      });
      if (idx === 0 && len === 1) return {};
      if (idx === 0 && len > 1) return tabs[1];
      return tabs[idx - 1];
    }
  }, {
    key: 'loadMenus',
    value: function loadMenus() {
      var _this = this;

      var menus = this.menus;

      if (Object.prototype.toString.call(menus) === '[object Array]' && menus.length) {
        return Promise.resolve(menus);
      }
      return _axios2['default'].get('/sys/function/menus').then(function (res) {
        var menusValid = Object.prototype.toString.call(res) === '[object Array]' ? res : [];
        _this.setMenus(menusValid);
        return menusValid;
      });
    }
  }, {
    key: 'openTab',
    value: function openTab(id, title, url, closeIcon) {
      if (!this.history) return;
      this.history.push({
        pathname: '/iframe' + url,
        state: {
          title: title
        }
      });
    }
  }, {
    key: 'openTabR',
    value: function openTabR(url, title) {
      if (!this.history) return;
      this.history.push({
        pathname: url,
        state: {
          title: title
        }
      });
    }
  }, {
    key: 'treeNodeMenus',
    get: function get() {
      var treeNodes = [];
      this.menus.forEach(function (v) {
        return getNodePath(v, treeNodes);
      });
      return treeNodes;
    }
  }, {
    key: 'getMenus',
    get: function get() {
      return this.menus.slice();
    }
  }, {
    key: 'getTabs',
    get: function get() {
      return this.tabs.slice();
    }
  }, {
    key: 'getIframeTabs',
    get: function get() {
      return this.tabs.filter(function (tab) {
        return tab.symbol !== 'REACT';
      });
    }
  }, {
    key: 'getSelectedKeys',
    get: function get() {
      return this.selectedKeys.slice();
    }
  }]);
  return MenuStore;
}(), (_descriptor = _applyDecoratedDescriptor(_class.prototype, 'collapsed', [_mobx.observable], {
  enumerable: true,
  initializer: function initializer() {
    return false;
  }
}), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, 'menus', [_mobx.observable], {
  enumerable: true,
  initializer: function initializer() {
    return [];
  }
}), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, 'tabs', [_mobx.observable], {
  enumerable: true,
  initializer: function initializer() {
    return [{
      children: null,
      expand: false,
      functionCode: 'HOME_PAGE',
      icon: '',
      id: -1,
      ischecked: null,
      score: -1,
      shortcutId: null,
      text: '首页',
      url: '',
      symbol: 'REACT'
    }];
  }
}), _descriptor4 = _applyDecoratedDescriptor(_class.prototype, 'openKeys', [_mobx.observable], {
  enumerable: true,
  initializer: function initializer() {
    return [];
  }
}), _descriptor5 = _applyDecoratedDescriptor(_class.prototype, 'selectedKeys', [_mobx.observable], {
  enumerable: true,
  initializer: function initializer() {
    return [];
  }
}), _descriptor6 = _applyDecoratedDescriptor(_class.prototype, 'activeMenu', [_mobx.observable], {
  enumerable: true,
  initializer: function initializer() {
    return {};
  }
}), _descriptor7 = _applyDecoratedDescriptor(_class.prototype, 'contentKeys', [_mobx.observable], {
  enumerable: true,
  initializer: function initializer() {
    return {};
  }
}), _descriptor8 = _applyDecoratedDescriptor(_class.prototype, 'expanded', [_mobx.observable], {
  enumerable: true,
  initializer: function initializer() {
    return false;
  }
}), _descriptor9 = _applyDecoratedDescriptor(_class.prototype, 'history', [_mobx.observable], {
  enumerable: true,
  initializer: function initializer() {
    return undefined;
  }
}), _applyDecoratedDescriptor(_class.prototype, 'treeNodeMenus', [_mobx.computed], Object.getOwnPropertyDescriptor(_class.prototype, 'treeNodeMenus'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getMenus', [_mobx.computed], Object.getOwnPropertyDescriptor(_class.prototype, 'getMenus'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getTabs', [_mobx.computed], Object.getOwnPropertyDescriptor(_class.prototype, 'getTabs'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getIframeTabs', [_mobx.computed], Object.getOwnPropertyDescriptor(_class.prototype, 'getIframeTabs'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getSelectedKeys', [_mobx.computed], Object.getOwnPropertyDescriptor(_class.prototype, 'getSelectedKeys'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setContentKey', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'setContentKey'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setCollapsed', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'setCollapsed'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setTabs', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'setTabs'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setMenus', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'setMenus'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setActiveMenu', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'setActiveMenu'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setOpenKeys', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'setOpenKeys'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setSelectedKeys', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'setSelectedKeys'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setMenuExpanded', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'setMenuExpanded'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setHistory', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'setHistory'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'closeTab', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'closeTab'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'clearCacheByCacheKey', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'clearCacheByCacheKey'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'closeTabAndClearCacheByCacheKey', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'closeTabAndClearCacheByCacheKey'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'loadMenus', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'loadMenus'), _class.prototype)), _class);


var menuStore = new MenuStore();
exports['default'] = menuStore;