'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _regenerator = require('babel-runtime/regenerator');

var _regenerator2 = _interopRequireDefault(_regenerator);

var _asyncToGenerator2 = require('babel-runtime/helpers/asyncToGenerator');

var _asyncToGenerator3 = _interopRequireDefault(_asyncToGenerator2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _find2 = require('lodash/find');

var _find3 = _interopRequireDefault(_find2);

var _desc, _value, _class, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7;

var _mobx = require('mobx');

var _axios = require('../components/axios');

var _axios2 = _interopRequireDefault(_axios);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _initDefineProp(target, property, descriptor, context) {
  if (!descriptor) return;
  Object.defineProperty(target, property, {
    enumerable: descriptor.enumerable,
    configurable: descriptor.configurable,
    writable: descriptor.writable,
    value: descriptor.initializer ? descriptor.initializer.call(context) : void 0
  });
}

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

function _initializerWarningHelper(descriptor, context) {
  throw new Error('Decorating class property failed. Please ensure that transform-class-properties is enabled.');
}

var AppState = (_class = function () {
  function AppState() {
    (0, _classCallCheck3['default'])(this, AppState);

    _initDefineProp(this, 'isTabMode', _descriptor, this);

    _initDefineProp(this, 'userInfo', _descriptor2, this);

    _initDefineProp(this, 'locales', _descriptor3, this);

    _initDefineProp(this, 'currentLang', _descriptor4, this);

    _initDefineProp(this, 'sysInfo', _descriptor5, this);

    _initDefineProp(this, 'cas', _descriptor6, this);

    _initDefineProp(this, 'hideMenu', _descriptor7, this);

    this.loadSysInfo = function () {
      return _axios2['default'].post('/sys/config/system/info');
    };
  }

  (0, _createClass3['default'])(AppState, [{
    key: 'setHideMenu',
    value: function setHideMenu(data) {
      this.hideMenu = data;
    }
  }, {
    key: 'setCas',
    value: function setCas(data) {
      this.cas = data;
    }
  }, {
    key: 'updateSysInfo',
    value: function updateSysInfo(type, value) {
      this.sysInfo[type] = value;
    }
  }, {
    key: 'setIsTabMode',
    value: function setIsTabMode(data) {
      this.isTabMode = data;
    }
  }, {
    key: 'setUserInfo',
    value: function setUserInfo(user) {
      this.userInfo = user;
      if (user.locale) {
        this.setCurrentLang(user.locale);
      }
    }
  }, {
    key: 'setCurrentLang',
    value: function setCurrentLang(data) {
      this.currentLang = data;
    }
  }, {
    key: 'setLocales',
    value: function setLocales(data) {
      this.locales = data;
    }
  }, {
    key: 'setSysInfo',
    value: function setSysInfo(data) {
      this.sysInfo = data || {};
      window.updateFavicon(data.faviconImageSrc);
    }
  }, {
    key: 'loadUserInfo',
    value: function () {
      var _ref = (0, _asyncToGenerator3['default'])( /*#__PURE__*/_regenerator2['default'].mark(function _callee() {
        var res;
        return _regenerator2['default'].wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                _context.next = 3;
                return _axios2['default'].get('/sys/um/user_personal_info');

              case 3:
                res = _context.sent;

                if (res === '') {
                  this.setCas(true);
                  window.top.location.href = '/index';
                }
                return _context.abrupt('return', res);

              case 8:
                _context.prev = 8;
                _context.t0 = _context['catch'](0);
                throw Error('someting wrong');

              case 11:
              case 'end':
                return _context.stop();
            }
          }
        }, _callee, this, [[0, 8]]);
      }));

      function loadUserInfo() {
        return _ref.apply(this, arguments);
      }

      return loadUserInfo;
    }()

    // loadUserInfo = () => axios.get('/sys/um/user_personal_info');

  }, {
    key: 'loadTabMode',
    value: function loadTabMode() {
      var _this = this;

      _axios2['default'].post('/sys/preferences/queryPreferences').then(function (res) {
        var rows = res.rows;

        var nav = (0, _find3['default'])(rows, function (row) {
          return row.preferences === 'nav';
        }) || {};
        _this.setIsTabMode(!nav.preferencesValue || nav.preferencesValue === 'Y');
      });
    }
  }, {
    key: 'loadLocale',
    value: function loadLocale() {
      return _axios2['default'].get('/common/language/').then(function (res) {
        var locales = {};
        res.forEach(function (v) {
          locales[v.langCode] = v.description;
        });
        return locales;
      });
    }
  }, {
    key: 'getHideMenu',
    get: function get() {
      return this.hideMenu;
    }
  }, {
    key: 'isCas',
    get: function get() {
      return this.cas;
    }
  }, {
    key: 'getUserInfo',
    get: function get() {
      return this.userInfo;
    }
  }, {
    key: 'logo',
    get: function get() {
      return this.sysInfo.logoImageSrc;
    }
  }, {
    key: 'favicon',
    get: function get() {
      return this.sysInfo.faviconImageSrc;
    }
  }, {
    key: 'title',
    get: function get() {
      return this.sysInfo.title;
    }
  }]);
  return AppState;
}(), (_descriptor = _applyDecoratedDescriptor(_class.prototype, 'isTabMode', [_mobx.observable], {
  enumerable: true,
  initializer: function initializer() {
    return true;
  }
}), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, 'userInfo', [_mobx.observable], {
  enumerable: true,
  initializer: function initializer() {
    return {};
  }
}), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, 'locales', [_mobx.observable], {
  enumerable: true,
  initializer: function initializer() {
    return {};
  }
}), _descriptor4 = _applyDecoratedDescriptor(_class.prototype, 'currentLang', [_mobx.observable], {
  enumerable: true,
  initializer: function initializer() {
    return undefined;
  }
}), _descriptor5 = _applyDecoratedDescriptor(_class.prototype, 'sysInfo', [_mobx.observable], {
  enumerable: true,
  initializer: function initializer() {
    return {};
  }
}), _descriptor6 = _applyDecoratedDescriptor(_class.prototype, 'cas', [_mobx.observable], {
  enumerable: true,
  initializer: function initializer() {
    return false;
  }
}), _descriptor7 = _applyDecoratedDescriptor(_class.prototype, 'hideMenu', [_mobx.observable], {
  enumerable: true,
  initializer: function initializer() {
    return true;
  }
}), _applyDecoratedDescriptor(_class.prototype, 'getHideMenu', [_mobx.computed], Object.getOwnPropertyDescriptor(_class.prototype, 'getHideMenu'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setHideMenu', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'setHideMenu'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'isCas', [_mobx.computed], Object.getOwnPropertyDescriptor(_class.prototype, 'isCas'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setCas', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'setCas'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'updateSysInfo', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'updateSysInfo'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setIsTabMode', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'setIsTabMode'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'getUserInfo', [_mobx.computed], Object.getOwnPropertyDescriptor(_class.prototype, 'getUserInfo'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setUserInfo', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'setUserInfo'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setCurrentLang', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'setCurrentLang'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setLocales', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'setLocales'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setSysInfo', [_mobx.action], Object.getOwnPropertyDescriptor(_class.prototype, 'setSysInfo'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'logo', [_mobx.computed], Object.getOwnPropertyDescriptor(_class.prototype, 'logo'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'favicon', [_mobx.computed], Object.getOwnPropertyDescriptor(_class.prototype, 'favicon'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'title', [_mobx.computed], Object.getOwnPropertyDescriptor(_class.prototype, 'title'), _class.prototype)), _class);


var appState = new AppState();
exports['default'] = appState;