'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports['default'] = getWebpackCommonConfig;

var _path = require('path');

var _webpack = require('webpack');

var _webpack2 = _interopRequireDefault(_webpack);

var _extractTextWebpackPlugin = require('extract-text-webpack-plugin');

var _extractTextWebpackPlugin2 = _interopRequireDefault(_extractTextWebpackPlugin);

var _caseSensitivePathsWebpackPlugin = require('case-sensitive-paths-webpack-plugin');

var _caseSensitivePathsWebpackPlugin2 = _interopRequireDefault(_caseSensitivePathsWebpackPlugin);

var _friendlyErrorsWebpackPlugin = require('friendly-errors-webpack-plugin');

var _friendlyErrorsWebpackPlugin2 = _interopRequireDefault(_friendlyErrorsWebpackPlugin);

var _uglifyjsWebpackPlugin = require('uglifyjs-webpack-plugin');

var _uglifyjsWebpackPlugin2 = _interopRequireDefault(_uglifyjsWebpackPlugin);

var _chalk = require('chalk');

var _chalk2 = _interopRequireDefault(_chalk);

var _getBabelCommonConfig = require('./getBabelCommonConfig');

var _getBabelCommonConfig2 = _interopRequireDefault(_getBabelCommonConfig);

var _getTSCommonConfig = require('./getTSCommonConfig');

var _getTSCommonConfig2 = _interopRequireDefault(_getTSCommonConfig);

var _context = require('../bin/common/context');

var _context2 = _interopRequireDefault(_context);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var jsFileName = 'dis/[name].[hash:8].js';
var jsChunkFileName = 'dis/chunks/[name].[chunkhash:5].chunk.js';
var cssFileName = 'dis/[name].[contenthash:8].css';
var assetFileName = 'dis/assets/[name].[hash:8].[ext]';

function getAssetLoader(env, mimetype) {
  var limit = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 10000;

  return {
    loader: 'url-loader',
    options: {
      limit: limit,
      mimetype: mimetype,
      name: assetFileName,
      publicPath: env === 'production' ? '/lib/dist/' : undefined
    }
  };
}

function getWebpackCommonConfig(mode, env) {
  var isDev = _context2['default'].isDev;

  var babelOptions = (0, _getBabelCommonConfig2['default'])(mode, env);
  var tsOptions = (0, _getTSCommonConfig2['default'])();

  var plugins = [new _webpack2['default'].optimize.CommonsChunkPlugin({
    name: 'vendor',
    filename: 'dis/[name].[hash:5].js',
    minChunks: Infinity
  }), new _extractTextWebpackPlugin2['default']({
    filename: cssFileName,
    disable: false,
    allChunks: true
  }), new _caseSensitivePathsWebpackPlugin2['default'](), new _webpack2['default'].ProgressPlugin(function (percentage, msg, addInfo) {
    var stream = process.stderr;
    if (stream.isTTY && percentage < 0.71) {
      stream.cursorTo(0);
      stream.write('\uD83D\uDCE6  ' + _chalk2['default'].magenta(msg) + ' (' + _chalk2['default'].magenta(addInfo) + ')');
      stream.clearLine(1);
    } else if (percentage === 1) {
      /* eslint-disable */
      console.log(_chalk2['default'].green('\nwebpack: bundle build is now finished.'));
      /* eslint-enable */
    }
  }), new _friendlyErrorsWebpackPlugin2['default'](), new _webpack2['default'].ProvidePlugin({
    Choerodon: isDev ? (0, _path.join)(process.cwd(), 'src/containers/common') : (0, _path.join)(__dirname, '../containers/common')
  })];

  if (env === 'production') {
    plugins.push(new _webpack2['default'].LoaderOptionsPlugin({
      minimize: true
    }), new _uglifyjsWebpackPlugin2['default']({
      parallel: true,
      cache: true,
      uglifyOptions: {
        output: {
          comments: false
        },
        compress: {
          warnings: false
        }
      }
    }));
  }
  return {
    output: {
      filename: jsFileName,
      chunkFilename: jsChunkFileName
    },
    resolve: {
      modules: ['node_modules', (0, _path.join)(__dirname, '../../node_modules')],
      extensions: ['.web.tsx', '.web.ts', '.web.jsx', '.web.js', '.ts', '.tsx', '.js', '.jsx', '.json']
    },
    resolveLoader: {
      modules: ['node_modules', (0, _path.join)(__dirname, '../../node_modules')]
    },
    node: {
      fs: 'empty'
    },
    module: {
      noParse: [/moment.js/],
      rules: [{
        test: /\.js$/,
        exclude: /node_modules/,
        loader: 'babel-loader',
        options: babelOptions
      }, {
        test: /\.jsx$/,
        loader: 'babel-loader',
        options: babelOptions
      }, {
        test: /\.tsx?$/,
        use: [{
          loader: 'babel-loader',
          options: babelOptions
        }, {
          loader: 'ts-loader',
          options: {
            transpileOnly: true,
            compilerOptions: tsOptions
          }
        }]
      }, {
        test: /\.woff(\?v=\d+\.\d+\.\d+)?$/,
        use: getAssetLoader(env, 'application/font-woff')
      }, {
        test: /\.woff2(\?v=\d+\.\d+\.\d+)?$/,
        use: getAssetLoader(env, 'application/font-woff')
      }, {
        test: /\.ttf(\?v=\d+\.\d+\.\d+)?$/,
        use: getAssetLoader(env, 'application/octet-stream')
      }, {
        test: /\.eot(\?v=\d+\.\d+\.\d+)?$/,
        use: getAssetLoader(env, 'application/vnd.ms-fontobject')
      }, {
        test: /\.svg(\?v=\d+\.\d+\.\d+)?$/,
        use: getAssetLoader(env, 'image/svg+xml')
      }, {
        test: /\.(png|jpg|jpeg|gif)(\?v=\d+\.\d+\.\d+)?$/i,
        use: getAssetLoader(env)
      }, {
        test: /\.json$/,
        loader: 'json-loader'
      }]
    },
    plugins: plugins
  };
}