'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _objectWithoutProperties2 = require('babel-runtime/helpers/objectWithoutProperties');

var _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function normalizeToSassVariables(modifyVarsOptions) {
  var modifyVars = modifyVarsOptions.modifyVars,
      options = (0, _objectWithoutProperties3['default'])(modifyVarsOptions, ['modifyVars']);

  if (modifyVars) {
    options.data = Object.keys(modifyVars).map(function (key) {
      return '$' + key + ': ' + modifyVars[key] + ';';
    }).join('');
  }
  return options;
}

exports['default'] = function (postcssOptions, loaderOptions) {
  return [{
    test: /\.css$/,
    use: [{
      loader: 'css-loader',
      options: {
        restructuring: false,
        autoprefixer: false
      }
    }, {
      loader: 'postcss-loader',
      options: postcssOptions
    }]
  }, {
    test: /\.less$/,
    use: [{
      loader: 'css-loader',
      options: {
        autoprefixer: false
      }
    }, {
      loader: 'postcss-loader',
      options: postcssOptions
    }, {
      loader: 'less-loader',
      options: loaderOptions
    }]
  }, {
    test: /\.scss$/,
    use: [{
      loader: 'css-loader',
      options: {
        autoprefixer: false
      }
    }, {
      loader: 'postcss-loader',
      options: postcssOptions
    }, {
      loader: 'sass-loader',
      options: normalizeToSassVariables(loaderOptions)
    }]
  }];
};