'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

exports['default'] = getChoerodonConfig;

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _autoprefixer = require('autoprefixer');

var _autoprefixer2 = _interopRequireDefault(_autoprefixer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var defaultConfig = {
  port: 9090,
  output: './dist',
  htmlTemplate: 'index.template.html',
  devServerConfig: {},
  postcssConfig: {
    plugins: [(0, _autoprefixer2['default'])({
      browsers: ['last 2 versions', 'Firefox ESR', '> 1%', 'ie >= 8', 'iOS >= 8', 'Android >= 4']
    })]
  },
  babelConfig: function babelConfig(config, mode, env) {
    return config;
  },
  webpackConfig: function webpackConfig(config, mode, env) {
    return config;
  },
  enterPoints: function enterPoints(mode, env) {
    return {};
  },

  entryName: 'index',
  root: '/',
  routes: null,
  local: true,
  server: '',
  webSocketServer: 'http://localhost:8080',
  titlename: '积木 | 数据转换平台',
  favicon: 'favicon.ico',
  proxyTarget: 'http://localhost:8080',
  distBasePath: './src/main/resources/lib',
  htmlPath: './src/main/resources/WEB-INF/view',
  homePath: undefined
};

function getChoerodonConfig(configFile) {
  var customizedConfig = _fs2['default'].existsSync(configFile) ? require(configFile) : {};
  return (0, _extends3['default'])({}, defaultConfig, customizedConfig);
}