/**
 * hmap子应用登录逻辑
 * @author momoko 2018/05/08
 */

import axios from 'axios'
import { getUrlParam } from './utils'

// 模拟登录
export async function analogLogin () {
  const url = `${$config.baseURL}/oauth/token?client_id=a765ff3f-8d33-49b4-a9c9-48e991544242&client_secret=ec2a9a5d-8b21-40fb-b20b-fa846b944e7b&grant_type=password&authType=TEL&username=17700002674&password=123456`

  const res = await axios.post(url)
  return {
    token: res.data.access_token,
    tokenType: res.data.token_type,
    expires: res.data.expires_in,
    userId: res.data.userId,
    organizationId: res.data.organizationId,
  }
}

// 授权码登录
export async function authorizedLogin () {
  const code = getUrlParam('code')

  const url = `${$config.baseURL}/oauth/token?client_id=a765ff3f-8d33-49b4-a9c9-48e991544242&client_secret=ec2a9a5d-8b21-40fb-b20b-fa846b944e7b&grant_type=authorization_code&code=${encodeURIComponent(code)}`

  const res = await axios.post(url)

  return {
    token: res.data.access_token,
    tokenType: res.data.token_type,
    expires: res.data.expires_in,
    userId: res.data.userId,
    organizationId: res.data.organizationId,
  }
}

// 桥登录
export function bridgeLogin () {
  return new Promise((resolve, reject) => {
    // 登录成功回调
    window.bridgeLoginSuccess = function (str) {
      const res = JSON.parse(str)

      const data = {
        token: res.token,
        tokenType: res.tokenType,
        expires: res.expiresIn,
        userId: res.userId,
        organizationId: res.organizationId,
      }

      resolve(data)
    }
    // 登录失败回调
    window.bridgeLoginFailure = function (res) {
      console.error(res)
      reject(res)
    }

    const dict = {
      'className': 'BaseBridge',
      'function': 'getBaseInfo',
      'successCallBack': 'bridgeLoginSuccess',
      'failureCallBack': 'bridgeLoginFailure',
    }

    HandBridge.postMessage(JSON.stringify(dict))
  })
}

// 获取用户详细信息
export async function getUserInfo (userId) {
  const url = `${$config.baseURL}/i/api/staff/customDetail`
  const data = {
    userId,
  }
  const options = {
    headers: {
      Authorization: `Bearer ${window.localStorage.token}`,
    },
  }
  const res = await axios.post(url, data, options)

  return res.data
}

/**
 * 登录总成
 * @param  {String}  [type] 可选:'online''local'
 * @param  {Boolean} [needInfo] 是否需要获取用户详细信息
 * @return {Object.Promise} 若登录成功PromiseValue为数据对象/登录失败PromiseValue 为 false
 */
export default async function login (type = 'online', needInfo = true) { // 登录
  const env = process.env.CONFIG_ENV // 环境

  try {
    let result = {}

    if (env === 'prod' || env === 'uat') { // 真机
      if (type === 'online') result = await authorizedLogin() // 在线子应用
      if (type === 'local') result = await bridgeLogin() // 本地子应用
    } else {
      result = await analogLogin()
    }

    window.localStorage.token = result.token

    if (needInfo) result.userInfo = await getUserInfo(result.userId)

    return result
  } catch (e) {
    console.error(e)
    return false
  }
}
