import ConfirmComponent from './confirm'
import Vue from 'vue'

import elementUtil from '../../common/scripts/elementUtil'

let $vm

const mergeOptions = function ($vm, options) {
  const defaults = {}
  for (let i in $vm.$options.props) {
    if (i !== 'value') {
      defaults[i] = $vm.$options.props[i].default
    }
  }
  const _options = Object.assign({}, defaults, options)
  for (let i in _options) {
    $vm[i] = _options[i]
  }
}

const confirm = {
  install () {
    elementUtil.createElement('hls-confirm')
    $vm = new Vue(ConfirmComponent)
    $vm.$mount('[hls-confirm]')
  },

  confirmShow (options) {
    this.install()
    setTimeout(() => {
      if (typeof options === 'object') {
        mergeOptions($vm, options)
      }
      if (typeof options === 'object' && (options.onShow || options.onHide)) {
        options.onShow && options.onShow()
      }
      this.$watcher && this.$watcher()
      this.$watcher = $vm.$watch('showValue', (val) => {
        if (!val && options && options.onHide) {
          options.onHide()
        }
        if (val === false) {
          document.body.removeChild($vm.$el)
        }
      })

      $vm.$off('on-cancel')
      $vm.$off('on-confirm')

      $vm.$on('on-cancel', () => {
        options && options.onCancel && options.onCancel()
      })
      $vm.$on('on-confirm', msg => {
        options && options.onConfirm && options.onConfirm(msg)
      })
      $vm.showValue = true
    }, 100)
  },
  confirmHide () {
    $vm.showValue = false
    document.body.removeChild($vm.$el)
  },

}

export default confirm
