import VueLazyload from 'vue-lazyload'
import HView from './HView/index'
import HHeader from './HHeader/index'
import HContent from './HContent/index'
import Scroll from './Scroll/index.vue'
import NumberKeyboard from './NumberKeyboard/index.vue'
import ItemOption from './ItemOption/index'
import OptionButton from './ItemOption/OptionButton'
import HButton from './HButton/index'
import Swipe from './Swipe/index'
import SwipeItem from './Swipe/SwipeItem'
import ListItem from './ListItem/ListItem'
import Item from './ListItem/Item'
import Switch from './Switch/index'
import Spin from './Spin/index'
import TopTip from './TopTip/index'
import Notify from './Dialog/Notify'
import Stab from './STab/index'
import TabItem from './STab/tab-item'
import CheckBox from './CheckBox/index'

import RadioGroup from './Radio/index'
import Radio from './Radio/radio'
import HFile from './HFile/index'

import BottomTab from './BottomTab/index'
import TabButton from './BottomTab/tab-button'
import Modal from './Modal/Modal'
import HLayout from './HLayout/index'
import CurrencyInput from './CurrencyInput/index'
import HProgress from './Progress/index'
import HRange from './Range/index'
import SelectFiled from './Select/SelectFiled'
import DateFiled from './DateFiled/index'

import errLoadingPic from '../common/picture/errloading.jpg'

export default (Vue) => {
  Vue.use(VueLazyload, {
    error: errLoadingPic,
    loading: errLoadingPic,
  })
  Vue.component('h-view', HView)
  Vue.component('h-header', HHeader)
  Vue.component('h-content', HContent)
  Vue.component('s-content', Scroll)
  Vue.component('scroll', Scroll)
  Vue.component('number-keyboard', NumberKeyboard)
  Vue.component('item-option', ItemOption)
  Vue.component('option-button', OptionButton)
  Vue.component('h-button', HButton)
  Vue.component('swipe', Swipe)
  Vue.component('swipe-item', SwipeItem)
  Vue.component('list-item', ListItem)
  Vue.component('item', Item)
  Vue.component('spin', Spin)
  Vue.component('top-tip', TopTip)
  Vue.component('notify', Notify)
  Vue.component('h-switch', Switch)
  Vue.component('s-tab', Stab)
  Vue.component('tab-item', TabItem)
  Vue.component('bottom-tab', BottomTab)
  Vue.component('tab-button', TabButton)
  Vue.component('h-modal', Modal)
  Vue.component('h-check', CheckBox)
  Vue.component('radio-group', RadioGroup)
  Vue.component('h-radio', Radio)
  Vue.component('h-file', HFile)
  Vue.component('h-layout', HLayout)
  Vue.component('currency-input', CurrencyInput)
  Vue.component('h-progress', HProgress)
  Vue.component('h-range', HRange)
  Vue.component('SelectFiled', SelectFiled)
  Vue.component('DateFiled', DateFiled)
}
