/*
 * @Author: zong.wang01@hand-china.com
 * @Date: 2024-07-29 16:36:23
 * @LastEditors: zong.wang01@hand-china.com
 * @LastEditTime: 2024-08-21 15:45:23
 * @Version: 1.0.0
 * @Description: 
 * @Copyright: Copyright (c) 2021, Hand-RongJing
 */
// 引入axios
import axios from 'axios'
import { Toast } from 'vant';
import qs from 'qs'
let promiseArr = {}
let cancel = {}
const CancelToken = axios.CancelToken

const baseUrl = process.env.apiPath

const withTokenAxios = axios.create({
  transformResponse(data) {
    // 对 data 进行任意转换处理
    // eslint-disable-next-line no-undef
    try {
      return JSON.parse(data);
      // return JSON.parse(JSON.stringify(JSONbig.parse(data)));
    } catch (e) {
      return data;
    }
  },
});

// 请求拦截器
withTokenAxios.interceptors.request.use(config => {
  // 发起请求时，取消掉当前正在进行的相同请求
  // config.cancelToken = new CancelToken(c => {
  //   cancel = c
  // })
  // if (promiseArr[config.url]) {
  //   promiseArr[config.url]('操作取消')
  //   promiseArr[config.url] = cancel
  // } else {
  //   promiseArr[config.url] = cancel
  // }
  return config
}, error => {
  return Promise.reject(error)
})
// 响应拦截器即异常处理
withTokenAxios.interceptors.response.use(response => {
  // if ($config.debug) {
  //   let postName = 'post'
  //   console.log(postName + ' success', response.config.url)
  //   console.log(postName + ' response ', response.data)
  //   console.log(postName + ' End!')
  // }
  
  const { status, data } = response;
  if (status === 204) {
    // return response;
    return null;
  }
  if (data && data.failed) {
    // hlsPopup.hideLoading()
    const err = {}
    err.message = response.data.message
    Toast.fail(err.message)
    throw err;
  } else {
    return response.data;
  }
}, err => {
  if (err && err.response) {
    switch (err.response.status) {
      case 400:
        err.message = '错误请求'
        break
      case 401:
        err.message = '登录已失效，请重新登录'
        break
      case 403:
        err.message = '拒绝访问'
        break
      case 404:
        err.message = '请求错误,未找到该资源'
        break
      case 405:
        err.message = '不支持的请求类型'
        break
      case 408:
        err.message = '请求超时'
        break
      case 500:
        err.message = '服务器端出错'
        break
      case 501:
        err.message = '网络未实现'
        break
      case 502:
        err.message = '网络错误'
        break
      case 503:
        err.message = '服务不可用'
        break
      case 504:
        err.message = '网络超时'
        break
      case 505:
        err.message = 'http版本不支持该请求'
        break
      default:
        err.message = `连接错误${err.response.status}`
    }
  } else {
    err.message = '连接到服务器失败'
  }
  if (err.response && err.response.status === 401) {
    Toast.fail(err.message)
    // hlsPopup.hideLoading()
    // hlsPopup.showPopup({
    //   title: '登录失效，重新登录',
    //   onConfirm: () => {

    //   },
    // })
  } else {
    // hlsPopup.hideLoading()
    Toast.fail(err.message + '<br/>' + (err.response.data ? err.response.data.message : ''))
    // hlsPopup.showError(err.message + '<br/>' + (err.response.data ? err.response.data.message : ''))
  }
  throw err;
})
withTokenAxios.defaults.baseURL = ''
withTokenAxios.defaults.timeout = 10000
withTokenAxios.defaults.paramsSerializer = (params) => {
  return qs.stringify(params, {arrayFormat: 'repeat'})
}
// get请求
export function get (url, param = {}) {
  let headers = {}
  if (window.localStorage.access_token) {
    headers = {
      'Content-Type': 'application/json',
      'Authorization': 'Bearer ' + window.localStorage.access_token,
    }
  } else {
    headers = {
      'Content-Type': 'application/json',
    }
  }
  // if ($config.debug) {
  //   let postName = 'GET'
  //   console.log(postName + ' Start!')
  //   console.log(postName + ' url ' + url)
  // }
  return new Promise((resolve, reject) => {
    withTokenAxios({
      method: 'get',
      url: baseUrl + url,
      headers: headers,
      params: param,
    }).then(res => {
      resolve(res)
    }).catch(err => {
      reject(err)
    })
  })
}
// post请求
export function post (url, param = {}, queryParams = {}) {
  param.user_id = window.localStorage.user_id
  param.access_token = window.localStorage.access_token
  let headers = {}
  if (window.localStorage.access_token) {
    headers = {
      'Content-Type': 'application/json',
      'Authorization': 'Bearer ' + window.localStorage.access_token,
    }
  } else {
    headers = {
      'Content-Type': 'application/json',
    }
  }
  // if ($config.debug) {
  //   let postName = 'POST'
  //   console.log(postName + ' Start!')
  //   console.log(postName + ' url ' + url)
  //   console.log(postName + ' parameter ' + JSON.stringify(param, '', 2))
  // }
  console.log(param)
  return new Promise((resolve, reject) => {
    withTokenAxios({
      method: 'post',
      headers: headers,
      url: baseUrl + url,
      data: param,
      params: queryParams
    }).then(res => {
      resolve(res)
    }).catch(err => {
      reject(err)
    })
  })
}

// put
export function put (url, param = {}, queryParams = {}) {
  param.user_id = window.localStorage.user_id
  param.access_token = window.localStorage.access_token
  let headers = {}
  if (window.localStorage.access_token) {
    headers = {
      'Content-Type': 'application/json',
      'Authorization': 'Bearer ' + window.localStorage.access_token,
    }
  } else {
    headers = {
      'Content-Type': 'application/json',
    }
  }

  return new Promise((resolve, reject) => {
    withTokenAxios({
      method: 'put',
      headers: headers,
      url: baseUrl + url,
      data: param,
      params: queryParams
    }).then(res => {
      resolve(res)
    }).catch(err => {
      reject(err)
    })
  })
}

// delete请求
export function deletes (url, param = {}, queryParams = {}) {
  param.user_id = window.localStorage.user_id
  param.access_token = window.localStorage.access_token
  let headers = {}
  if (window.localStorage.access_token) {
    headers = {
      'Content-Type': 'application/json',
      'Authorization': 'Bearer ' + window.localStorage.access_token,
    }
  } else {
    headers = {
      'Content-Type': 'application/json',
    }
  }

  return new Promise((resolve, reject) => {
    withTokenAxios({
      method: 'delete',
      headers: headers,
      url: baseUrl + url,
      data: param,
      params: queryParams
    }).then(res => {
      resolve(res)
    }).catch(err => {
      reject(err)
    })
  })
}

export default {
  get: get,
  post: post,
  put: put,
  delete: deletes
}
