动态配置功能
 目前支持配置 form、s-tab、button 以及底部固定位置的按钮

```html
/**
* @Author think
* @Date 2019-07-16 20:00
*/

<template>
  <h-view class="form">
    <h-header>
      <div slot="left" class="h-header-btn" @click="$hlsExit()">
        <i class="ion-ios-arrow-back"/>
      </div>
      <div slot="center">From</div>
      <div slot="right" class="h-header-btn">右边</div>
    </h-header>
    <h-layout
      v-if="layoutShow"
      :layout-data="layoutData" :show-form-title="showFormTitle" :show-btn-divider="true"
      :show-tab-divider="true" :formData="data" v-model="data" :read-only="readOnly"
      :show-btn="showBtn"
      @tabClick="tabClick"
      @showSelect="showSelect" @showTime="showTime" @filedClick="filedClick"
      @btnClick="btnClick"/>
  </h-view>
</template>
```
```javascript
<script>
import layoutData from './layout.json'

export default {
  name: 'Form',
  data () {
    return {
      tabIndex: 1,
      showFormTitle: true,
      layoutData: [],
      layoutShow: false,
      readOnly: false,
      showBtn: true,
      data: {
        contract: {
          postion: '01',
          postion_n: '技术顾问',
          enable_flag: false,
        },
      },
      postionList: [
        {code: '01', code_name: '技术顾问'},
        {code: '02', code_name: '技术经理'},
        {code: '03', code_name: '项目经理'},
      ],
    }
  },
  created () {
    let vm = this
    /* axios.get('http://leafservice.hand-china.com/r/api/get/layoutCode?layoutCode=CON_QURERY', {
      header: {'Content-Type': 'application/json',
        'Authorization': 'bearer SRHJVdrftyGUYguyhiHiuiojmgrrcgv' },
    }).then(res => {
      vm.layoutData = res.rows
      vm.layoutShow = true
    }) */

    setTimeout(() => {
      vm.layoutData = layoutData
      vm.layoutShow = true
    }, 100)
  },
  methods: {
    /**
     * tab的点击事件
     * @param index
     */
    tabClick (index) {
      this.tabIndex = index
    },
    showPostion (configCode, filedCode) {
      let vm = this
      vm.hlsPopup.selectList({
        list: vm.postionList,
        code: filedCode,
        object: vm.data[configCode],
        returnItem (index) {
          vm.data[configCode][filedCode] = vm.postionList[index].code
          vm.data[configCode][filedCode + '_n'] = vm.postionList[index].code_name
        },
      })
    },
    /**
     * 下拉框点击事件
     * @param configCode
     * @param filedCode
     */
    showSelect (configCode, filedCode) {
      let vm = this
      switch (filedCode) {
        case 'postion':
          vm.showPostion(configCode, filedCode)
          break
        default:
      }
    },
    showOrderDate (configCode, filedCode) {
      let vm = this
      vm.hlsPopup.showTime({
        callback (time) {
          vm.data[configCode][filedCode] = time
        },
      })
    },
    /**
     * 事件选择事件
     * @param configCode
     * @param filedCode
     */
    showTime (configCode, filedCode) {
      let vm = this
      switch (filedCode) {
        case 'order_date':
          vm.showOrderDate(configCode, filedCode)
          break
        default:
      }
    },
    /**
     * 其他字端的点击事件
     * @param configCode
     * @param filedCode
     */
    filedClick (configCode, filedCode) {
      debugger
    },
    /**
     * 按钮点击事件
     * @param btn
     */
    btnClick (btn) {
      console.log(JSON.stringify(this.data, '', 2))
      if (btn.btnType === 'BottomTab') {
        if (btn.btnCode === 'save') {
          alert('底部固定按钮的保存')
        }
        if (btn.btnCode === 'submit') {
          alert('底部固定按钮的提交')
        }
      } if (btn.btnType === 'Button') {
        if (btn.btnCode === 'nextBtn') {
          alert('按钮继续')
        }
      }
    },
  },
}
</script>
```
```less
<style  lang="less">
  .form {
  }
</style>
``` 
1. 动态布局目前仅仅支持一个 s-tab组件，一个底部按钮bottom-tab 组件
2. 组件名为h-layout，需要在布局查询出来之后再去渲染此组件否则渲染失败
3. 布局的查询在created生命周期函数内查询，查询成功再去渲染组件
4. 因无法在data里面直接set数据，故需在data里面新建data数据对象用于组件解析成功以及数据双向绑定使用
5. 支持在自定义data对象设置默认值，默认值的优先级高于组件定义的默认值
6. 组件使用v-model与formData进行传递data数据实现双向绑定，两者缺一不可
7. 组件中会解析出全部的按钮，每个按钮对应 组件code、按钮code、以及按钮描述。以btns数组反馈给父组件，用于按钮点击事件
8. 所有的下拉框、时间以及按钮的触发逻辑全部交由父组件处理，子组件通知父组件，子组件内不做任何业务处理逻辑


props
* layoutData:组件布局默认数组
* showFormTitle:是否展示form表单上的title，title也可以点击实现form的缩放 默认 true
* showTabDivider:是否显示s-tab的分割线 默认true
* showTabBorder:是否显示s-tab的下边框 默认false
* showBtn:是否显示按钮组件(button与bottom-tab)
* showBtnDivider:是否底部按钮的分割线 默认true
* formData:组件数据，用于双向绑定
* readOnly:设置组件全部只读，禁用字端及按钮的输入点击

emit
* tabClick s-tab组件切换点击事件 返回当前点击的index
* showSelect 下拉框点开事件 返回布局组件code，字端的code，用于判断是哪个下拉框
* showTime  事件点开事件 返回组件code，字端的code，用于判断是哪个时间选择
* filedClick 其它字端点击事件，字端类型为其它的点击事件 返回组件code，字端的code，可用于超链接，提示等
* btnClick 按钮点击事件，返回当前btn对象，包含组件code、按钮code、以及按钮描述，可根据此判断点击的是哪个按钮


