/*
 * @Author: zong.wang01@hand-china.com
 * @Date: 2024-07-30 17:19:32
 * @LastEditors: zong.wang01@hand-china.com
 * @LastEditTime: 2024-07-30 17:34:57
 * @Version: 1.0.0
 * @Description: 布局抽象类
 * @Copyright: Copyright (c) 2021, Hand-RongJing
 */
import Vue from 'vue';
import { Fragment } from 'vue-fragment';
 
const AbstractLayout = {
  // functional: true,
  // Props 是可选的
  props: {
    components: { // 是否需要返回键
      type: Boolean,
      default: true
    },
    staticLayoutTabs: {
      type: Array,
      default: () => [],
    }
  },
  data () {
    return {
      counter: 0, // 配置信息
    }
  },
  methods: {
    /**
     *  包装渲染布局下组件
     * @param {Array.<VueElement>} components 组件
     */
    packageContents(components) {
      return components;
    },
    getCounter() {
      this.counter += 1;
      return this.counter;
    },
    /**
     *  获取框架
     * @param {*} content
     * @returns {Element}
     */
    getLayoutFrame(content) {
      return <div>{content}</div>;
    }

  },
  // 为了弥补缺少的实例
  // 提供第二个参数作为上下文
  render: function (h, context) {
    return <div></div>
    return <Fragment>{this.getLayoutFrame(this.packageContents(components))}</Fragment>;
  }
};
 
export default AbstractLayout;



