/*
 * @Author: zong.wang01@hand-china.com
 * @Date: 2024-08-09 10:54:02
 * @LastEditors: zong.wang01@hand-china.com
 * @LastEditTime: 2024-08-19 11:08:33
 * @Version: 1.0.0
 * @Description: 页面配置请求
 * @Copyright: Copyright (c) 2021, Hand-RongJing
 */
import {getOrganizationId} from './utils/utils';
import hlsHttp from './utils/hlsHttp'

export async function query(layoutCode, param) {
  let config = {
    datas: {},
    param: {},
  };
  try {
    const data = await hlsHttp.get(`/hllc/v1/${getOrganizationId()}/doc-layouts/config/app/${layoutCode}`, param);
    config.param = param;
    config.datas = data || {};
    return config;
  } catch (err) {
    return config;
  }
}

export async function queryRoute(match, param) {
  let config = {
    datas: {},
    param: {},
  };
  try {
    const res = await hlsHttp.get(
      `/hllc/v1/${getOrganizationId()}/rule-engine-low-code?route=${window.encodeURIComponent(
        match
      )}`
    );
    if (res) {
      const data = await this.query(res.routeResultValue, param);
      return data;
    } else {
      return config;
    }
  } catch (err) {
    return config;
  }
  
}

// 获取下拉框值
export function getSelectOptions(params) {
  return hlsHttp.get(`/hpfm/v1/${getOrganizationId()}/lovs/data`, params);
}

// 获取lov配置信息
export function getLovConfig(params) {
  return hlsHttp.get(`/hpfm/v1/${getOrganizationId()}/lov-view/info`, params);
}

// 获取lov数据
export function getLovData(url, params) {
  const newParams = {
    ...params,
    tenantId: getOrganizationId(),
  }
  return hlsHttp.get(url, newParams);
}

// 获取表单数据
export function getFormData(url, params) {
  return hlsHttp.get(url, params);
}

// 获取表格数据
export function getTableData(url, params) {
  return hlsHttp.get(url, params);
}

// 表格单条数据保存
export function saveTableRecord(url, params) {
  return hlsHttp.post(url, params);
}

// 表格删除
export function deleteTableRecords(destroyUrl, dataSetName, params) {
  const url = destroyUrl || 
        `/hllc/v1/${getOrganizationId()}/dynamic-crud/delete${dataSetName ? '?datasetName=' + dataSetName : ''}`;
  return hlsHttp.delete(url, params);
}

// 页面大保存
export function save(params) {
  return hlsHttp.post(`/hllc/v1/${getOrganizationId()}/dynamic-crud/save`, params);
}
