/*
 * @Author: zong.wang01@hand-china.com
 * @Date: 2024-07-30 09:41:54
 * @LastEditors: zong.wang01@hand-china.com
 * @LastEditTime: 2024-08-19 14:40:12
 * @Version: 1.0.0
 * @Description: 
 * @Copyright: Copyright (c) 2021, Hand-RongJing
 */
import Vue from 'vue';
import {Button} from 'vant'
import layouts from '../layout/index.js';
import {ColumnBuilder, ComponentBuilder} from './LayoutBuilder.jsx'
import QueryForm from './QueryForm';
import DTable from './DTable';
import DForm from './DForm';
 
const ConfigRenderComponent = {
  // functional: true,
  // Props 是可选的
  components: {
    QueryForm,
    DTable,
    DForm,
  },
  props: {
    needBack: { // 是否需要返回键
      type: Boolean,
      default: true
    },
    componentRenderers: {
      type: Array,
      default: () => [],
    },
    staticLayoutTabs: {
      type: Array,
      default: () => [],
    },
    componentButtons: {
      type: Array,
      default: () => [],
    },
  },
  data () {
    return {
      configInfo: {}, // 配置信息
      layoutComponents: ['HBox', 'VBox', 'Tabs', 'TabPane', 'NavigationBar'],
      queryParams: {}, // 路由参数
    }
  },
  inject: ['dynamicInfo'],
  created() {
    this.queryParams = {
      ...this.$route.params,
      ...this.$route.query
    }
  },
  mounted() {
    this.configInfo = this.dynamicInfo().config;
  },
  activated () {
    this.configInfo = this.dynamicInfo().config;
  },
  methods: {
    getTabs(layoutTabs, state, layoutCode, createElement) {
      return layoutTabs.map(layoutTab => {
        const parentTabCode = layoutTab.tabCode;
        // 布局类型
        const layoutName = layoutTab.tabType;
        if (!layoutTab.childrenTabs || layoutTab.childrenTabs.length === 0) {
          return [];
        }
        // 组件描述
        const componentNames = [];
        let components;
        if (this.layoutComponents.some(item => layoutTab.childrenTabs[0].tabType === item)) {
          layoutTab.childrenTabs.forEach(childrenTab => {
            componentNames.push({code: childrenTab.tabCode, label: childrenTab.description})
          });
          components = this.getTabs(layoutTab.childrenTabs, state, layoutCode, createElement);
        } else {
          components = layoutTab.childrenTabs.map(childrenTab => {
            const {
              tabType,
              tabCode,
              tabFields,
              description
            } = childrenTab;
            
            componentNames.push({code: tabCode, label: description});
            
            const columns = new ColumnBuilder()
              .withFields(tabFields)
              .withType(tabType)
              .withTabCode(tabCode)
              .withLayoutCode(childrenTab.layoutCode || layoutCode)
              .withParentTabCode(parentTabCode)
              .withComponentRenderers(this.componentRenderers)
              .build();
             
            const findField = find(tabFields, { formatCascadeFlag: 'Y' });
            
            return new ComponentBuilder()
              .withCascadeKey(findField && findField.columnName)
              .withRouteParams(this.queryParams)
              .withCreateElement(createElement)
              .withTabType(tabType)
              .withColumns(columns)
              .withLayoutCode(childrenTab.layoutCode || layoutCode)
              .withTabCode(childrenTab.tabCode)
              .withProps(childrenTab)
              .withStaticComponents(this.staticLayoutTabs)
              .withComponentButtons(this.componentButtons)
              .withParentProps(this)
              .build();
          });
        }
        const Layout = this.getLayout(layoutName);
        return <Layout componentNames={componentNames} components={components}/>
      });
    },
    getLayout(layoutName) {
      return layouts[layoutName];
    }
  },
  // 为了弥补缺少的实例
  // 提供第二个参数作为上下文
  render: function (h, context) {
    // console.log('context', context, this.configInfo)
    const { layoutCode, layoutTabs = [] } = this.configInfo;
    return <div style="height: 100%;display: flex; flex-direction: column">{layoutTabs.length ? this.getTabs(layoutTabs, this, layoutCode, h) : null}</div>;
  }
};
 
export default ConfigRenderComponent;