/**
 * Created by LJh on 2017/4/13.
 */
export default {
// 获取设备号
  onGetRegistrationID: function (data) {
    try {
      // alert("JPushPlugin:registrationID is " + JSON.stringify(data));
      if (data.length !== 0) {
        window.localStorage.setItem('registrationID', data)
      }
      if (data.length === 0) {
        window.setTimeout(this.getRegistrationID, 1000)
      }
    } catch (exception) {
      // alert(angular.toJson(exception));
    }
  },
  // 获取设备号
  getRegistrationID: function () {
    window.plugins.jPushPlugin.getRegistrationID(this.onGetRegistrationID)
  },
  onReceiveNotification: function (event) {
    try {
      let alertContent // eslint-disable-line
      if (device.platform === 'Android') { // eslint-disable-line
        alertContent = event.alert
      } else {
        alertContent = event.aps.alert
      }
    } catch (exception) {
      console.log(exception)
    }
  },

  onReceiveMessage: function (event) {
    try {
      let message // eslint-disable-line
      if (device.platform === 'Android') { // eslint-disable-line
        message = event.message
      } else {
        message = event.content
      }
    } catch (exception) {
      // console.log("JPushPlugin:onReceiveMessage-->" + exception);
    }
  },

  onOpenNotification: function (event) {
    window.plugins.jPushPlugin.resetBadge()// 设置Badge
    window.plugins.jPushPlugin.setApplicationIconBadgeNumber(0)
    try {
      let alertContent // eslint-disable-line
      if (device.platform === 'Android') { // eslint-disable-line
        alertContent = event.alert
      } else {
        alertContent = event.aps.alert
      }
      // alert("open Notification:" + JSON.stringify(event,'',2));
    } catch (exception) {
      // console.log("JPushPlugin:onOpenNotification" + exception);
    }
  },
  // 启动极光推送
  _init: function () {
    if (process.env.isMobilePlatform) {
      window.plugins.jPushPlugin.init()
      window.plugins.jPushPlugin.setDebugMode(false)
      window.plugins.jPushPlugin.getRegistrationID(this.onGetRegistrationID)
      document.addEventListener('jpush.openNotification', this.onOpenNotification)
      window.plugins.jPushPlugin.resetBadge()// 设置Badge
      window.plugins.jPushPlugin.setApplicationIconBadgeNumber(0)
      // document.addEventListener('jpush.receiveMessage', this.onReceiveMessage);
      // document.addEventListener('jpush.receiveNotification', this.onReceiveNotification);
    }
  },

  /*
   * 获取状态
   * */
  _isPushStopped: function (fun) {
    window.plugins.jPushPlugin.isPushStopped(fun)
  },
  /*
   * 停止极光推送
   * */
  _stopPush: function () {
    window.plugins.jPushPlugin.stopPush()
  },
  /*
   * 重启极光推送
   * */
  _resumePush: function () {
    window.plugins.jPushPlugin.resumePush()
  },

  /**
   * 设置标签。
   * 注意：该接口是覆盖逻辑，而不是增量逻辑。即新的调用会覆盖之前的设置。
   *
   * @param params = { 'sequence': number, 'tags': ['tag1', 'tag2'] }
   */
  _setTags: function (params, successCallback, errorCallback) {
    window.plugins.jPushPlugin.setTags(params, successCallback, errorCallback)
  },
  /**
   * 新增标签。
   *
   * @param params = { 'sequence': number, 'tags': ['tag1', 'tag2'] }
   */
  _addTags: function (params, successCallback, errorCallback) {
    window.plugins.jPushPlugin.addTags(params, successCallback, errorCallback)
  },
  /**
   * 删除指定标签。
   *
   * @param params = { 'sequence': number, 'tags': ['tag1', 'tag2'] }
   */
  _deleteTags: function (params, successCallback, errorCallback) {
    window.plugins.jPushPlugin.deleteTags(params, successCallback, errorCallback)
  },
  /**
   * 清除标签
   * @param params
   * @param successCallback
   * @param errorCallback
   * @private
   */
  _cleanTags: function (params, successCallback, errorCallback) {
    window.plugins.jPushPlugin.cleanTags(params, successCallback, errorCallback)
  },
  /**
   * 查询所有标签。
   *
   * @param params = { 'sequence': number }
   */
  _getAllTags: function (params, successCallback, errorCallback) {
    window.plugins.jPushPlugin.getAllTags(params, successCallback, errorCallback)
  },
  /*
   * 设置别名
   * */
  _setAlias: function (params, successCallback, errorCallback) {
    window.plugins.jPushPlugin.setAlias(params, successCallback, errorCallback)
  },
  /**
   * 删除别名。
   *
   * @param params = { 'sequence': number }
   */
  _deleteAlias: function (params, successCallback, errorCallback) {
    window.plugins.jPushPlugin.deleteAlias(params, successCallback, errorCallback)
  },
  /**
   * 查询当前绑定的别名。
   *
   * @param params = { 'sequence': number }
   */
  _getAlias: function (params, successCallback, errorCallback) {
    window.plugins.jPushPlugin.getAlias(params, successCallback, errorCallback)
  },
  /**
   * 设置角标
   * @param value
   * @private
   */
  _setBadge: function (value) {
    window.plugins.jPushPlugin.setBadge(value)
  },
  /*
   * 清除角标
   * */
  _resetBadge: function () {
    window.plugins.jPushPlugin.resetBadge()
    window.plugins.jPushPlugin.setApplicationIconBadgeNumber(0)
  },

  _setLogOFF: function () {
    window.plugins.jPushPlugin.setLogOFF()
  },

  // 极光推送
  _jpush_config: function (tagOption) {
    if (process.env.isMobilePlatform) {
      let userId = window.localStorage.user_id
      let tags = []
      for (let key in tagOption) {
        tags.push(tagOption[key])
      }
      /* if (userName) {
        tags.push(userName.toUpperCase())
      } */
      window.plugins.jPushPlugin.setTags({sequence: Number(userId), tags: tags},
        function (result) {
          // alert(result.tags)
        }, function (error) {
          // alert(error.code)
        })
    }
  },
}
