import Vue from 'vue'
import Router from 'vue-router'

import Home from '@/pages/home'

// test工具类
import HlsPopup from '@/pages/hlsPopup'

Vue.use(Router)

export default new Router({
  routes: [
    {
      path: '/',
      redirect: '/home',
    },
    {path: '/home', component: Home, name: 'Home', meta: {keepAlive: false}},
    // test工具类
    {path: '/hls-popup', component: HlsPopup, name: 'HlsPopup', meta: {keepAlive: false}},
  ],
  scrollBehavior (to, from, savedPosition) {
    if (to.hash) {
      return {
        selector: to.hash,
      }
    }
  },
})
