/*
 * @Description: In User Settings Edit
 * @Author: huangtianyang
 * @Date: 2020-01-16 09:41
 */
// import {
//   CentField,
//   CheckBox,
//   Currency,
//   DatePicker,
//   DateTimePicker,
//   EmailField,
//   Lov,
//   MonthPicker,
//   NumberField,
//   Radio,
//   Select,
//   Switch,
//   TextArea,
//   TextField,
//   TimePicker
// } from 'leaf-ui/pro';
import {
  Field,
  Checkbox,
  Radio,
  Switch,
} from 'vant';
import { isNil } from 'lodash';
import Vue from 'vue'

// 表单字段
const FormFields = {
  "TextField": Field,
  Checkbox,
  Radio,
  Switch,
};

export default function FormField(field) {
  const {
    columnName: name,
    columnCount: colSpan,
    rowCount: rowSpan,
    description: label,
    clearButton,
    dataSet,
    columnSeq
  } = field;
  const fieldProps = {
    ...field,
    name,
    colSpan,
    rowSpan,
    label,
    clearButton: clearButton === 'Y',
    newLine: columnSeq === 1,
    disabled: !isNil(dataSet) && dataSet.fields.get(name).props.readOnly,
    id: undefined
  };
  const FieldComponent = FormFields[field.validationTypeDisplay];
  console.log('FieldComponent', FieldComponent)
  if (field.dataType === 'multiple') {
    fieldProps.multiple = true;
  }
  /* if (field.validationTypeDisplay === 'CentField') {
    fieldProps.renderer = ({ text, value }) => {
      if (isNil(value)) {
        return text;
      } else {
        return NumberField.format(value, undefined, { minimumFractionDigits: 4 });
      }
    };
  } else */
  if (field.validationTypeDisplay === 'TextArea') {
    fieldProps.resize = 'both';
  } else if (field.validationTypeDisplay === 'Currency' && field.isHundredth === 1) {
    fieldProps.renderer = ({ text, value }) => {
      if (isNil(value)) {
        return text;
      }
      const fixed = value.toFixed(2);
      const splits = fixed.split('.');
      return `${NumberField.format(splits[0])}.${splits[1]}`;
    };
  }
  return FieldComponent // <FieldComponent {...fieldProps} disabledIfReadOnly />;
}
