滑动删除

```html
<template>
  <div>
    <!--
    slot="buttons" 滑动按钮的插槽
    option-button 滑动的按钮
                 type 按钮的颜色
                 text 按钮文字
    -->
    <item-option  v-for="(color,index) in colors" :key="index"
                       class="mySlider">
              <div>{{color.name}}</div>
              <div>{{color.hex}}</div>
              <div slot="buttons">
                <option-button type="default" text="默认" @click.native="deleteFun"></option-button>
                <option-button type="primary" text="编辑" @click.native="deleteFun"></option-button>
                <option-button type="warn" text="删除" @click.native="deleteFun"></option-button>
              </div>
            </item-option>
  </div>
</template>

<script>
  export default {
    data(){
      return{
        colors: [ { name: 'Yellow', hex: '#f4d03f' }, { name: 'Green', hex: '#229954' }, { name: 'Purple', hex: '#9b59b6' } ],
      }
    },
    methods:{
      //e为该元素在数组的下标
      deleteFun(e){
        console.log(e);
      }
    }
  }
</script>

<style scoped lang="less" type="text/less">
  //修改子组件样式的方法，非默认样式可以直接加上，默认样式需要以important覆盖
  //item高度
  .list{
    height:150px!important;
  }
</style>
```
