/**
 * Created by LJh on 2017/4/13.
 */
export default {
  /**
   * @param {object} params = {
   *  'isOpenMessageRoaming': boolean  // 是否开启消息漫游，不传默认关闭。
   * }
   *
   * 打开消息漫游之后，用户多个设备之间登录时，SDK 会自动将当前登录用户的历史消息同步到本地。
   */
  _init: function (params) {
    if (process.env.isMobilePlatform) {
      JMessagePlugin.init(params)
      JMessagePlugin.setBadge({
        badge: 0,
      })
    }
  },
  /**
   *  @param {object} params = {
   *   username:'username',
        password:'password',
        nickname: String,
        ...
   *  }
   * @param {function} success = function () {}
   * @param {function} error = function ({'code': '错误码', 'description': '错误信息'}) {}
   */
  _register: function (params, success, error) {
    JMessagePlugin.register(params, success, error)
  },
  /**
   * @param {object} params = {
   *  username: 'username',
   *  password: 'password',
   * }
   * @param {function} success = function () {}
   * @param {function} error = function ({'code': '错误码', 'description': '错误信息'}) {}
   */
  _login: function (params, success, error) {
    JMessagePlugin.login(params, success, error)
  },
  /**
   * @param {object} params = {
   *  'type': String,                                // 'single' / 'group' / 'chatRoom'
   *  'username': String,                            // 当 type 为 'single' 时，username 不能为空
   *  'appKey': String,      // 当 type 为 'single' 时，用于指定对象所属应用的 appKey。如果为空，默认为当前应用
   *  'text': String,                                // 消息内容
   * }
   * @param {function} success = function (msg) {}   // 以参数形式返回消息对象。
   * @param {function} error = function ({'code': '错误码', 'description': '错误信息'}) {}
   */
  _sendTextMessage: function (params, success, error) {
    JMessagePlugin.sendTextMessage(params, success, error)
  },

  /**
   * 添加收到消息事件监听。
   *
   @param {function} listener = function (message) {}  // 以参数形式返回消息对象。
   * message = {
   *  'id': String,
   *  'from': object,    // 消息发送者信息对象。
   *  'target': object,  // 消息接收方信息（可能为用户或者群组）。
   *  'type': string     // 'text' / 'image' / 'voice' / 'location' / 'file' / 'custom' / 'event'
   * }
   **/
  _addReceiveMessageListener: function (listener) {
    JMessagePlugin.addReceiveMessageListener(listener)
  },

  /**
   *
   * @param username
   * @param password
   * @private
   */
  /* eslint handle-callback-err: "warn" */
  _jmessage_config: function (username, password) {
    if (process.env.isMobilePlatform) {
      var login = function () {
        JMessagePlugin.login({'username': username, 'password': password}, function () {
          // alert("login success");
        }, function (error) {
          // alert("Login failed: " + error.description);
          register()
        })
      }

      /* eslint handle-callback-err: "warn" */
      var register = function () {
        JMessagePlugin.register({'username': username, 'password': password}, function () {
          login()
        }, function (error) {
          // alert('Register failed: ' + error.description);
        })
      }
      login()
    }
  },
}
