/*
 * @Author: zong.wang01@hand-china.com
 * @Date: 2024-08-02 11:36:24
 * @LastEditors: zong.wang01@hand-china.com
 * @LastEditTime: 2024-08-05 15:45:37
 * @Version: 1.0.0
 * @Description: 导航栏
 * @Copyright: Copyright (c) 2021, Hand-RongJing
 */
import Vue from 'vue';
import { v4 as uuidv4 } from 'uuid';
import { Tab, Tabs } from 'vant';
import './index.less';

const NavigationBar = {
  name: 'NavigationBar',
  components: {
    [Tab.name]: Tab,
    [Tabs.name]: Tabs
  },
  props: {
    components: {
      type: Array,
      default: () => []
    },
    componentNames: {
      type: Array,
      default: () => []
    }
  },
  data() {
    return {
      navId: uuidv4(),
      navContentId: uuidv4(),
      componentIds: [],
      activeNav: '', // 默认显示nav
    }
  },
  mounted () {
    let ids = [];
    this.components.forEach((com, index) => {
      ids.push(`${this.componentNames[index].code}_${uuidv4()}`);
    });
    this.componentIds = ids;
    this.activeNav = this.componentNames[0].code;
    
  },
  activated() {
    // this.onScroll();
  },
  deactivated() {

  },
  methods: {
    navClick(nav, index) {
      this.activeNav = nav.code;
      this.scrollToViewCenter(index);
      this.scrollToPoint(index);
    },
    // 滚动到锚点
    scrollToPoint(index) {
      const target = document.getElementById(this.componentIds[index]);
      if (target) {
        // 滚动到目标位置
        const top = target.offsetTop;
        document.getElementById(this.navContentId).scrollTo({
          top: top,
          // behavior: 'smooth'
        });
      }
    },
    // 滚动到视图中心
    scrollToViewCenter(index) {
      const navEle = document.getElementById(`nav_${this.componentIds[index]}`);
      if (navEle) {
        const { left, width } = navEle.getBoundingClientRect();
        const elCenter = left + width / 2; // 元素的中心高度
        const center = window.innerWidth / 2; // 窗口的中心高度
        const ele = document.getElementById(this.navId);
        if (ele) {
          ele.scrollTo({
            left: ele.scrollLeft - (center - elCenter),
            behavior: 'smooth'
          })
        }
      }
    },
    // 滚动监听 
    onScroll(e) {
      if (e.type === 'scroll') {
        const top = e.target.scrollTop;
        this.componentIds.forEach((o, index) => {
          const ele = document.getElementById(o);
          if (ele) {
            const childTop = ele.offsetTop;
            const nextEle = (index < this.componentIds.length - 1) ? document.getElementById(this.componentIds[index + 1]) : null;
            if (nextEle) {
              const childNextTop = nextEle.offsetTop;
              if (childTop < top && top < childNextTop) {
                if (this.activeNav !== this.componentNames[index].code) {
                  this.activeNav = this.componentNames[index].code;
                  this.scrollToViewCenter(index);
                }
              }
            } else{
              if (childTop < top) {
                if (this.activeNav !== this.componentNames[index].code) { // 此处减少不必要的渲染
                  this.activeNav = this.componentNames[index].code;
                  this.scrollToViewCenter(index);
                }
              }
            }
          }
        });
      }
    }
  },
  render: function (h, context) {
    return (
      <div class="d-navs">
        <div class="d-nav" id={this.navId}>
          {this.componentNames.map((name, index) => (
            <span
              id={`nav_${this.componentIds[index]}`}
              class={this.activeNav === name.code ? "d-nav-item active" : "d-nav-item"} 
              onClick={() => this.navClick(name, index, false)}
            >{name.label}</span>
          ))}
        </div>
        <div class="d-nav-content" id={this.navContentId} onScroll={this.onScroll}>
          {this.components.map((component, index) => (
            <div id={this.componentIds[index]}>{component}</div>
          ))}
        </div>
      </div>
    )
    
  }
}

export default NavigationBar;

