文件上传组建 h-file 用于选择本地文件预览上传

```html
<template>
  <h-view>
    <h-content>
      <h-file
        :file-list="fileList" v-model="fileList" :upload="upload"
        :upload-config="uploadConfig" :disabled="disable" :accept="accept" :beforeRead="beforeRead"
        :afterRead="afterRead" :maxCount="maxCount" :max-size="maxSize" :previewImage="previewImage"
        :deleteImage="deleteImage"
        :result-type="resultType"
        @upload="uploaded"
        @delete="deletePic"
        @oversize="oversize"/>
    </h-content>
  </h-view>
</template>

<script>
export default {

  name: 'FileTest',
  data () {
    return {
      fileList: [], // 文件数组 必填
      disable: false, // 是否禁用文件上传 默认false 可选
      accept: 'image/png,image/jpeg', // 接受的文件类型 可选
      upload: false, // 选取完成是否自动上传 默认 false 可选
      maxSize: 2000000, // 文件大小限制，单位为byte 可选 超过大小的文件会自动取消
      maxCount: 5, // 文件上传数量限制 可选超过数量自动隐藏选择按钮
      deleteImage: true, // 是否删除文件 默认true 可选
      previewImage: true, // 是否在选取完成后展示预览图 默认true 可选
      resultType: 'dataUrl', // 文件读取结果类型 默认读取完成后取base64 可选值为text
      uploadConfig: { // 文件上传配置
        uploadUrl: $config.rootPath + '/app/fileUploadSvc?sysName=HLS_APP&apiName=attachment_upload', // 上传的URL
        params: { // 上传的额外参数
          user_id: 1,
          source_type: 'HLS_DOC_FILE_TEMPLET',
          pkvalue: 42,
        },
        uploadSuccess: this.fileSuccess, // 上传成功后的回调函数 用于给文件添加服务端唯一标示或其他
      },
    }
  },
  methods: {
    /**
     * email事件 可选
     * 删除文件后触发 返回当前文件以及 对应的index
     * @param file
     * @param index
     */
    deletePic (file, index) {
      debugger
    },
    /**
     * 可选
     * 文件选择完成后读取前触发 返回当前选择的文件数组
     * 返回 ture 或者promise对象 标示继续读取，否则终止 操作
     * @param files 选择的文件数组
     * @returns {boolean}
     */
    beforeRead (files) {
      files.forEach((file, index) => {
        console.log(file.size)
      })
      return true
    },
    /**
     * 可选
     * 文件读取成功后触发添加了文件的content内容
     * @param files 选择的文件数组
     * @returns {boolean}
     */
    afterRead (files) {
      files.forEach((item, index) => {
        console.log(item.file.name)
      })
      return true
    },
    /**
     * email事件 可选
     * 全部文件上传成功后触发
     * @param fileList 全部文件数组
     */
    uploaded (fileList) {
      debugger
    },
    /**
     * email事件 可选
     * 文件大小超过配置的大小
     * @param files
     */
    oversize (files) {
      debugger
    },
    /**
     * 每个文件上传成功后的回调 可选配置
     * @param fileList 文件数组
     * @param result 上传返回结果
     */

    fileSuccess (fileList, result) {
      this.fileList = fileList
      this.fileList.forEach((itemFile, index) => {
        if (result.response && itemFile.file && !itemFile.attachment_id && result.response.fileName === itemFile.file.name) {
          itemFile.attachment_id = result.response.attachment_id
        }
      })
    },
  },
}
</script>

<style scoped lang="less">

</style>

```
默认插槽 slot 用于自定义选择文件样式

v-model 绑定文件数组

fileList 文件数组 [{file:File,content:''base64 or url'}]

disable: false, // 是否禁用文件上传 默认false 可选
      
accept: 'image/png,image/jpeg', // 接受的文件类型 可选

upload: false, // 选取完成是否自动上传 默认 false 可选

maxSize: 2000000, // 文件大小限制，单位为byte 可选 超过大小的文件会自动取消

maxCunt: 5, // 文件上传数量限制 可选超过数量自动隐藏选择按钮
      
deleteImage: true, // 是否删除文件 默认true 可选

previewImage: true, // 是否在选取完成后展示预览图 默认true 可选

resultType: 'dataUrl', // 文件读取结果类型 默认base64 可选值为text

    uploadConfig: { // 文件上传配置
      uploadUrl: $config.rootPath + '/app/fileUploadSvc?sysName=HLS_APP&apiName=attachment_upload', // 上传的URL
        params: { // 上传的额外参数
           user_id: 1,
           source_type: 'HLS_DOC_FILE_TEMPLET',
           pkvalue: 42,
        },
        uploadSuccess: this.fileSuccess, // 上传成功后的回调函数 用于给文件添加服务端唯一标示或其他
      },
