import Vue from 'vue'
import Router from 'vue-router'

import Home from '@/pages/home'

// test工具类
import HlsPopup from '@/pages/hlsPopup'
import Radio from '@/pages/radioTest'
import HFile from '@/pages/fileTest'
import Form from '@/pages/form'

Vue.use(Router)

export default new Router({
  routes: [
    {
      path: '/',
      redirect: '/home',
    },
    {path: '/home', component: Home, name: 'Home', meta: {keepAlive: false}},
    // test工具类
    {path: '/hls-popup', component: HlsPopup, name: 'HlsPopup', meta: {keepAlive: false}},
    {path: '/Radio', component: Radio, name: 'Radio', meta: {keepAlive: true}},
    {path: '/HFile', component: HFile, name: 'HFile', meta: {keepAlive: true}},
    {path: '/Form', component: Form, name: 'Form', meta: {keepAlive: true}}
  ],
  scrollBehavior (to, from, savedPosition) {
    if (to.hash) {
      return {
        selector: to.hash,
      }
    }
  },
})
